/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.api.security;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;

public final class SecurityHelper {
    private SecurityHelper() {
    }

    public static boolean isAllowed(ServerPlayer player, Permission permission, Set<InWorldNetworkNodeContainer> containers) {
        for (InWorldNetworkNodeContainer container : containers) {
            if (SecurityHelper.isAllowed(player, permission, container.getNode())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowed(ServerPlayer player, Permission permission, NetworkNode node) {
        Network network = node.getNetwork();
        if (network == null) {
            return false;
        }
        return SecurityHelper.isAllowed(player, permission, network);
    }

    public static boolean isAllowed(ServerPlayer player, Permission permission, Network network) {
        return network.getComponent(PlatformSecurityNetworkComponent.class).isAllowed(permission, player);
    }
}

