/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.core.component.ComponentMapFactory;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.NetworkBuilder;
import com.refinedmods.refinedstorage.api.network.NetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.NetworkBuilderImpl;
import com.refinedmods.refinedstorage.api.network.impl.NetworkFactory;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternProviderItem;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategyFactory;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategyFactory;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.GridSynchronizer;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategyFactory;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.importer.ImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.api.storage.externalstorage.ExternalStorageProviderFactory;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.energy.EnergyItemHelper;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemHelper;
import com.refinedmods.refinedstorage.common.api.support.registry.PlatformRegistry;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceFactory;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceProvider;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.api.wirelesstransmitter.WirelessTransmitterRangeModifier;
import com.refinedmods.refinedstorage.common.autocrafting.CompositePatternProviderExternalPatternSinkFactory;
import com.refinedmods.refinedstorage.common.content.ContentIds;
import com.refinedmods.refinedstorage.common.grid.NoopGridSynchronizer;
import com.refinedmods.refinedstorage.common.grid.strategy.CompositeGridExtractionStrategy;
import com.refinedmods.refinedstorage.common.grid.strategy.CompositeGridInsertionStrategy;
import com.refinedmods.refinedstorage.common.grid.strategy.CompositeGridScrollingStrategy;
import com.refinedmods.refinedstorage.common.grid.view.GridResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.networking.CompositeWirelessTransmitterRangeModifier;
import com.refinedmods.refinedstorage.common.storage.ClientStorageRepository;
import com.refinedmods.refinedstorage.common.storage.StorageContainerItemHelperImpl;
import com.refinedmods.refinedstorage.common.storage.StorageRepositoryImpl;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlock;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockBlockEntity;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockCodecs;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockContainerMenu;
import com.refinedmods.refinedstorage.common.storagemonitor.CompositeStorageMonitorExtractionStrategy;
import com.refinedmods.refinedstorage.common.storagemonitor.CompositeStorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.energy.EnergyItemHelperImpl;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemEnergyStorage;
import com.refinedmods.refinedstorage.common.support.network.ConnectionProviderImpl;
import com.refinedmods.refinedstorage.common.support.network.InWorldNetworkNodeContainerBuilder;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeContainerProviderImpl;
import com.refinedmods.refinedstorage.common.support.network.item.NetworkItemHelperImpl;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.registry.PlatformRegistryImpl;
import com.refinedmods.refinedstorage.common.support.resource.CompositeRecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.support.resource.FluidResourceFactory;
import com.refinedmods.refinedstorage.common.support.resource.ItemResourceFactory;
import com.refinedmods.refinedstorage.common.support.slotreference.CompositeSlotReferenceProvider;
import com.refinedmods.refinedstorage.common.support.slotreference.InventorySlotReference;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeRegistryImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.ServerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;

public class RefinedStorageApiImpl
implements RefinedStorageApi {
    private final StorageRepository clientStorageRepository = new ClientStorageRepository(C2SPackets::sendStorageInfoRequest);
    private final ComponentMapFactory<NetworkComponent, Network> networkComponentMapFactory = new ComponentMapFactory();
    private final NetworkBuilder networkBuilder = new NetworkBuilderImpl(new NetworkFactory(this.networkComponentMapFactory));
    private final PlatformRegistry<StorageType> storageTypeRegistry = new PlatformRegistryImpl<StorageType>();
    private final PlatformRegistry<ResourceType> resourceTypeRegistry = new PlatformRegistryImpl<ResourceType>();
    private final PlatformRegistry<GridSynchronizer> gridSynchronizerRegistry = new PlatformRegistryImpl<GridSynchronizer>();
    private final GridResourceRepositoryMapper gridResourceRepositoryMapper = new GridResourceRepositoryMapper();
    private final PlatformRegistry<ImporterTransferStrategyFactory> importerTransferStrategyRegistry = new PlatformRegistryImpl<ImporterTransferStrategyFactory>();
    private final PlatformRegistry<ExporterTransferStrategyFactory> exporterTransferStrategyRegistry = new PlatformRegistryImpl<ExporterTransferStrategyFactory>();
    private final UpgradeRegistry upgradeRegistry = new UpgradeRegistryImpl();
    private final List<ExternalStorageProviderFactory> externalStorageProviderFactories = new ArrayList<ExternalStorageProviderFactory>();
    private final Queue<DestructorStrategyFactory> destructorStrategyFactories = new PriorityQueue<DestructorStrategyFactory>(Comparator.comparingInt(DestructorStrategyFactory::getPriority));
    private final Queue<ConstructorStrategyFactory> constructorStrategyFactories = new PriorityQueue<ConstructorStrategyFactory>(Comparator.comparingInt(ConstructorStrategyFactory::getPriority));
    private final CompositeStorageMonitorInsertionStrategy storageMonitorInsertionStrategy = new CompositeStorageMonitorInsertionStrategy();
    private final CompositeStorageMonitorExtractionStrategy storageMonitorExtractionStrategy = new CompositeStorageMonitorExtractionStrategy();
    private final CompositeRecipeModIngredientConverter ingredientConverter = new CompositeRecipeModIngredientConverter();
    private final StorageContainerItemHelper storageContainerItemHelper = new StorageContainerItemHelperImpl();
    private final List<GridInsertionStrategyFactory> gridInsertionStrategyFactories = new ArrayList<GridInsertionStrategyFactory>();
    private final List<GridExtractionStrategyFactory> gridExtractionStrategyFactories = new ArrayList<GridExtractionStrategyFactory>();
    private final List<GridScrollingStrategyFactory> gridScrollingStrategyFactories = new ArrayList<GridScrollingStrategyFactory>();
    private final ResourceFactory itemResourceFactory = new ItemResourceFactory();
    private final ResourceFactory fluidResourceFactory = new FluidResourceFactory();
    private final Set<ResourceFactory> resourceFactories = new HashSet<ResourceFactory>();
    private final CompositeWirelessTransmitterRangeModifier wirelessTransmitterRangeModifier = new CompositeWirelessTransmitterRangeModifier();
    private final EnergyItemHelper energyItemHelper = new EnergyItemHelperImpl();
    private final NetworkItemHelper networkItemHelper = new NetworkItemHelperImpl();
    private final PlatformRegistry<SlotReferenceFactory> slotReferenceFactoryRegistry = new PlatformRegistryImpl<SlotReferenceFactory>();
    private final CompositeSlotReferenceProvider slotReferenceProvider = new CompositeSlotReferenceProvider();
    private final PlatformRegistry<PlatformPermission> permissionRegistry = new PlatformRegistryImpl<PlatformPermission>();
    private final List<ResourceContainerInsertStrategy> resourceExtractStrategies = new ArrayList<ResourceContainerInsertStrategy>();
    private final WeakHashMap<Level, Map<UUID, Pattern>> patternCache = new WeakHashMap();
    private final CompositePatternProviderExternalPatternSinkFactory patternProviderExternalPatternSinkFactory = new CompositePatternProviderExternalPatternSinkFactory();

    public RefinedStorageApiImpl() {
        this.gridSynchronizerRegistry.register(IdentifierUtil.createIdentifier("off"), NoopGridSynchronizer.INSTANCE);
    }

    @Override
    public PlatformRegistry<StorageType> getStorageTypeRegistry() {
        return this.storageTypeRegistry;
    }

    @Override
    public StorageRepository getClientStorageRepository() {
        return this.clientStorageRepository;
    }

    @Override
    public StorageRepository getStorageRepository(Level level) {
        ServerLevel serverLevel = Objects.requireNonNull(level.getServer().getLevel(Level.OVERWORLD));
        return (StorageRepository)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(StorageRepositoryImpl::new, StorageRepositoryImpl::new, null), "refinedstorage_storages");
    }

    @Override
    public StorageContainerItemHelper getStorageContainerItemHelper() {
        return this.storageContainerItemHelper;
    }

    @Override
    public PlatformRegistry<ResourceType> getResourceTypeRegistry() {
        return this.resourceTypeRegistry;
    }

    @Override
    public PlatformRegistry<ImporterTransferStrategyFactory> getImporterTransferStrategyRegistry() {
        return this.importerTransferStrategyRegistry;
    }

    @Override
    public PlatformRegistry<ExporterTransferStrategyFactory> getExporterTransferStrategyRegistry() {
        return this.exporterTransferStrategyRegistry;
    }

    @Override
    public void addExternalStorageProviderFactory(ExternalStorageProviderFactory factory) {
        this.externalStorageProviderFactories.add(factory);
    }

    @Override
    public Collection<ExternalStorageProviderFactory> getExternalStorageProviderFactories() {
        return this.externalStorageProviderFactories;
    }

    @Override
    public Collection<DestructorStrategyFactory> getDestructorStrategyFactories() {
        return this.destructorStrategyFactories;
    }

    @Override
    public void addDestructorStrategyFactory(DestructorStrategyFactory factory) {
        this.destructorStrategyFactories.add(factory);
    }

    @Override
    public Collection<ConstructorStrategyFactory> getConstructorStrategyFactories() {
        return this.constructorStrategyFactories;
    }

    @Override
    public void addConstructorStrategyFactory(ConstructorStrategyFactory factory) {
        this.constructorStrategyFactories.add(factory);
    }

    @Override
    public void addStorageMonitorExtractionStrategy(StorageMonitorExtractionStrategy strategy) {
        this.storageMonitorExtractionStrategy.addStrategy(strategy);
    }

    @Override
    public StorageMonitorExtractionStrategy getStorageMonitorExtractionStrategy() {
        return this.storageMonitorExtractionStrategy;
    }

    @Override
    public void addStorageMonitorInsertionStrategy(StorageMonitorInsertionStrategy strategy) {
        this.storageMonitorInsertionStrategy.addStrategy(strategy);
    }

    @Override
    public StorageMonitorInsertionStrategy getStorageMonitorInsertionStrategy() {
        return this.storageMonitorInsertionStrategy;
    }

    @Override
    public void addPatternProviderExternalPatternSinkFactory(PatternProviderExternalPatternSinkFactory factory) {
        this.patternProviderExternalPatternSinkFactory.addFactory(factory);
    }

    @Override
    public PatternProviderExternalPatternSinkFactory getPatternProviderExternalPatternSinkFactory() {
        return this.patternProviderExternalPatternSinkFactory;
    }

    @Override
    public ComponentMapFactory<NetworkComponent, Network> getNetworkComponentMapFactory() {
        return this.networkComponentMapFactory;
    }

    @Override
    public PlatformRegistry<GridSynchronizer> getGridSynchronizerRegistry() {
        return this.gridSynchronizerRegistry;
    }

    @Override
    public ResourceRepositoryMapper<GridResource> getGridResourceRepositoryMapper() {
        return this.gridResourceRepositoryMapper;
    }

    @Override
    public void addGridResourceRepositoryMapper(Class<? extends ResourceKey> resourceClass, ResourceRepositoryMapper<GridResource> mapper) {
        this.gridResourceRepositoryMapper.addFactory(resourceClass, mapper);
    }

    @Override
    public UpgradeRegistry getUpgradeRegistry() {
        return this.upgradeRegistry;
    }

    @Override
    public NetworkNodeContainerProvider createNetworkNodeContainerProvider() {
        return new NetworkNodeContainerProviderImpl();
    }

    @Override
    public InWorldNetworkNodeContainer.Builder createNetworkNodeContainer(BlockEntity blockEntity, NetworkNode networkNode) {
        return new InWorldNetworkNodeContainerBuilder(blockEntity, networkNode);
    }

    @Override
    public void initializeNetworkNodeContainer(InWorldNetworkNodeContainer container, @Nullable Level level, @Nullable Runnable callback) {
        if (level == null || level.isClientSide()) {
            return;
        }
        ConnectionProviderImpl connectionProvider = new ConnectionProviderImpl(level);
        ServerListener.queue(server -> {
            if (container.isRemoved()) {
                return;
            }
            this.networkBuilder.initialize(container, connectionProvider);
            if (callback != null) {
                callback.run();
            }
        });
    }

    @Override
    public void removeNetworkNodeContainer(InWorldNetworkNodeContainer container, @Nullable Level level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        if (container.getNode().getNetwork() == null) {
            return;
        }
        ConnectionProviderImpl connectionProvider = new ConnectionProviderImpl(level);
        this.networkBuilder.remove(container, connectionProvider);
    }

    @Override
    public void updateNetworkNodeContainer(InWorldNetworkNodeContainer container, @Nullable Level level) {
        if (level == null || level.isClientSide() || container.getNode().getNetwork() == null) {
            return;
        }
        ConnectionProviderImpl connectionProvider = new ConnectionProviderImpl(level);
        this.networkBuilder.update(container, connectionProvider);
    }

    @Override
    public GridInsertionStrategy createGridInsertionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        return new CompositeGridInsertionStrategy(Platform.INSTANCE.getDefaultGridInsertionStrategyFactory().create(containerMenu, player, grid), this.gridInsertionStrategyFactories.stream().map(f -> f.create(containerMenu, player, grid)).toList());
    }

    @Override
    public void addGridInsertionStrategyFactory(GridInsertionStrategyFactory insertionStrategyFactory) {
        this.gridInsertionStrategyFactories.add(insertionStrategyFactory);
    }

    @Override
    public void addResourceContainerInsertStrategy(ResourceContainerInsertStrategy strategy) {
        this.resourceExtractStrategies.add(strategy);
    }

    @Override
    public Collection<ResourceContainerInsertStrategy> getResourceContainerInsertStrategies() {
        return Collections.unmodifiableList(this.resourceExtractStrategies);
    }

    @Override
    public GridExtractionStrategy createGridExtractionStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        List<GridExtractionStrategy> strategies = this.gridExtractionStrategyFactories.stream().map(f -> f.create(containerMenu, player, grid)).toList();
        return new CompositeGridExtractionStrategy(strategies);
    }

    @Override
    public void addGridExtractionStrategyFactory(GridExtractionStrategyFactory extractionStrategyFactory) {
        this.gridExtractionStrategyFactories.add(extractionStrategyFactory);
    }

    @Override
    public GridScrollingStrategy createGridScrollingStrategy(AbstractContainerMenu containerMenu, ServerPlayer player, Grid grid) {
        List<GridScrollingStrategy> strategies = this.gridScrollingStrategyFactories.stream().map(f -> f.create(containerMenu, player, grid)).toList();
        return new CompositeGridScrollingStrategy(strategies);
    }

    @Override
    public void addGridScrollingStrategyFactory(GridScrollingStrategyFactory scrollingStrategyFactory) {
        this.gridScrollingStrategyFactories.add(scrollingStrategyFactory);
    }

    @Override
    public void addResourceFactory(ResourceFactory factory) {
        this.resourceFactories.add(factory);
    }

    @Override
    public ResourceFactory getItemResourceFactory() {
        return this.itemResourceFactory;
    }

    @Override
    public StorageType getItemStorageType() {
        return StorageTypes.ITEM;
    }

    @Override
    public ResourceFactory getFluidResourceFactory() {
        return this.fluidResourceFactory;
    }

    @Override
    public StorageType getFluidStorageType() {
        return StorageTypes.FLUID;
    }

    @Override
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.resourceFactories;
    }

    @Override
    public void addIngredientConverter(RecipeModIngredientConverter converter) {
        this.ingredientConverter.addConverter(converter);
    }

    @Override
    public RecipeModIngredientConverter getIngredientConverter() {
        return this.ingredientConverter;
    }

    @Override
    public void addWirelessTransmitterRangeModifier(WirelessTransmitterRangeModifier rangeModifier) {
        this.wirelessTransmitterRangeModifier.addModifier(rangeModifier);
    }

    @Override
    public WirelessTransmitterRangeModifier getWirelessTransmitterRangeModifier() {
        return this.wirelessTransmitterRangeModifier;
    }

    @Override
    public Optional<EnergyStorage> getEnergyStorage(ItemStack stack) {
        return Platform.INSTANCE.getEnergyStorage(stack);
    }

    @Override
    public EnergyItemHelper getEnergyItemHelper() {
        return this.energyItemHelper;
    }

    @Override
    public EnergyStorage asItemEnergyStorage(EnergyStorage energyStorage, ItemStack stack) {
        return new ItemEnergyStorage(stack, energyStorage);
    }

    @Override
    public EnergyStorage asBlockItemEnergyStorage(EnergyStorage energyStorage, ItemStack stack, BlockEntityType<?> blockEntityType) {
        return new ItemBlockEnergyStorage(energyStorage, stack, blockEntityType);
    }

    @Override
    public NetworkItemHelper getNetworkItemHelper() {
        return this.networkItemHelper;
    }

    @Override
    public PlatformRegistry<SlotReferenceFactory> getSlotReferenceFactoryRegistry() {
        return this.slotReferenceFactoryRegistry;
    }

    @Override
    public void addSlotReferenceProvider(SlotReferenceProvider provider) {
        this.slotReferenceProvider.addProvider(provider);
    }

    @Override
    public SlotReference createInventorySlotReference(Player player, InteractionHand hand) {
        return InventorySlotReference.of(player, hand);
    }

    @Override
    public void useSlotReferencedItem(Player player, Item ... items) {
        HashSet<Item> validItems = new HashSet<Item>(Arrays.asList(items));
        this.slotReferenceProvider.findForUse(player, items[0], validItems).ifPresent(C2SPackets::sendUseSlotReferencedItem);
    }

    @Override
    public PlatformRegistry<PlatformPermission> getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Override
    public SecurityPolicy createDefaultSecurityPolicy() {
        return new SecurityPolicy(this.permissionRegistry.getAll().stream().filter(PlatformPermission::isAllowedByDefault).collect(Collectors.toSet()));
    }

    @Override
    public void sendNoPermissionToOpenMessage(ServerPlayer player, Component target) {
        this.sendNoPermissionMessage(player, (Component)IdentifierUtil.createTranslation("misc", "no_permission.open", target));
    }

    @Override
    public void sendNoPermissionMessage(ServerPlayer player, Component message) {
        S2CPackets.sendNoPermission(player, message);
    }

    @Override
    public boolean canPlaceNetworkNode(ServerPlayer player, Level level, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = pos.relative(direction);
            NetworkNodeContainerProvider adjacentProvider = Platform.INSTANCE.getContainerProvider(level, adjacentPos, direction.getOpposite());
            if (adjacentProvider == null || adjacentProvider.canBuild(player)) continue;
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(player, (Component)IdentifierUtil.createTranslation("misc", "no_permission.build.place", state.getBlock().getName()));
            return false;
        }
        return true;
    }

    @Override
    public Optional<Pattern> getPattern(ItemStack stack, Level level) {
        Item item = stack.getItem();
        if (!(item instanceof PatternProviderItem)) {
            return Optional.empty();
        }
        PatternProviderItem providerItem = (PatternProviderItem)item;
        UUID id = providerItem.getId(stack);
        if (id == null) {
            return Optional.empty();
        }
        Map patternLevelCache = this.patternCache.computeIfAbsent(level, l -> new HashMap());
        return Optional.ofNullable(patternLevelCache.computeIfAbsent(id, i -> providerItem.getPattern(stack, level).orElse(null)));
    }

    @Override
    public ResourceLocation getCreativeModeTabId() {
        return ContentIds.CREATIVE_MODE_TAB;
    }

    @Override
    public ResourceLocation getColoredCreativeModeTabId() {
        return ContentIds.COLORED_CREATIVE_MODE_TAB;
    }

    @Override
    public AbstractNetworkNodeContainerBlockEntity<?> createStorageBlockEntity(BlockPos pos, BlockState state, StorageBlockProvider provider) {
        return new StorageBlockBlockEntity(pos, state, provider);
    }

    @Override
    public Block createStorageBlock(BlockBehaviour.Properties properties, StorageBlockProvider provider) {
        return new StorageBlock(properties, provider);
    }

    @Override
    public AbstractContainerMenu createStorageBlockContainerMenu(int syncId, Player player, StorageBlockData data, ResourceFactory resourceFactory, MenuType<?> menuType) {
        return new StorageBlockContainerMenu(menuType, syncId, player, data, resourceFactory);
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, StorageBlockData> getStorageBlockDataStreamCodec() {
        return StorageBlockCodecs.STREAM_CODEC;
    }
}

