/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storage.ExposedStorage;
import com.refinedmods.refinedstorage.api.network.impl.storage.NetworkNodeStorageConfiguration;
import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.network.storage.StorageProvider;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageNetworkNode
extends AbstractStorageContainerNetworkNode
implements StorageProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageNetworkNode.class);
    private final StorageConfiguration storageConfiguration = new NetworkNodeStorageConfiguration(this);
    private final ExposedStorage storage = new ExposedStorage(this.storageConfiguration);

    public StorageNetworkNode(long energyUsage, long energyUsagePerStorage, int size) {
        super(energyUsage, energyUsagePerStorage, size);
    }

    @Override
    protected void onStorageChange(AbstractStorageContainerNetworkNode.StorageChange change) {
        if (!this.isActive()) {
            return;
        }
        if (change.removed()) {
            this.storage.removeSource(change.storage());
        } else {
            this.storage.addSource(change.storage());
        }
    }

    @Override
    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        if (this.network == null) {
            return;
        }
        LOGGER.debug("Activeness got changed to {}, updating underlying internal storages", (Object)newActive);
        if (newActive) {
            this.enableAllStorages();
        } else {
            this.disableAllStorages();
        }
    }

    private void enableAllStorages() {
        for (StateTrackedStorage internalStorage : this.storages) {
            if (internalStorage == null) continue;
            this.storage.addSource(internalStorage);
        }
    }

    private void disableAllStorages() {
        this.storage.clearSources();
    }

    public StorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public long getStored() {
        long stored = 0L;
        for (StateTrackedStorage internalStorage : this.storages) {
            if (internalStorage == null) continue;
            stored += internalStorage.getStored();
        }
        return stored;
    }

    public long getCapacity() {
        long capacity = 0L;
        for (StateTrackedStorage internalStorage : this.storages) {
            if (internalStorage == null) continue;
            capacity += internalStorage.getCapacity();
        }
        return capacity;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }
}

