/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.grid;

import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherRegistration;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE, since="2.0.0-milestone.3.3")
public class GridWatcherManagerImpl
implements GridWatcherManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridWatcherManagerImpl.class);
    private final Map<GridWatcher, GridWatcherRegistration> watchers = new HashMap<GridWatcher, GridWatcherRegistration>();

    @Override
    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType, @Nullable RootStorage rootStorage) {
        if (this.watchers.containsKey(watcher)) {
            throw new IllegalArgumentException("Watcher is already registered");
        }
        GridWatcherRegistration registration = new GridWatcherRegistration(watcher, actorType);
        if (rootStorage != null) {
            this.attach(registration, rootStorage, false);
        }
        this.watchers.put(watcher, registration);
        LOGGER.debug("Added watcher {}, new count is {}", (Object)watcher, (Object)this.watchers.size());
    }

    @Override
    public void attachAll(@Nullable RootStorage rootStorage) {
        this.watchers.forEach((watcher, registration) -> {
            watcher.invalidate();
            if (rootStorage != null) {
                this.attach((GridWatcherRegistration)registration, rootStorage, true);
            }
        });
    }

    private void attach(GridWatcherRegistration registration, RootStorage rootStorage, boolean replay) {
        LOGGER.debug("Attaching {} to {}", (Object)registration, (Object)rootStorage);
        registration.attach(rootStorage, replay);
    }

    @Override
    public void removeWatcher(GridWatcher watcher, @Nullable RootStorage rootStorage) {
        GridWatcherRegistration registration = this.watchers.get(watcher);
        if (registration == null) {
            throw new IllegalArgumentException("Watcher is not registered");
        }
        if (rootStorage != null) {
            this.detach(registration, rootStorage);
        }
        this.watchers.remove(watcher);
        LOGGER.debug("Removed watcher {}, remaining {}", (Object)watcher, (Object)this.watchers.size());
    }

    @Override
    public void detachAll(RootStorage rootStorage) {
        LOGGER.debug("Detaching {} watchers", (Object)this.watchers.size());
        this.watchers.values().forEach(watcher -> this.detach((GridWatcherRegistration)watcher, rootStorage));
    }

    private void detach(GridWatcherRegistration registration, RootStorage rootStorage) {
        LOGGER.debug("Detaching {} from {}", (Object)registration, (Object)rootStorage);
        registration.detach(rootStorage);
    }

    @Override
    public void activeChanged(boolean active) {
        this.watchers.keySet().forEach(watcher -> watcher.onActiveChanged(active));
    }
}

