/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.grid;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManagerImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.storage.Actor;
import java.util.Objects;
import javax.annotation.Nullable;

public class GridNetworkNode
extends AbstractNetworkNode {
    private final long energyUsage;
    private final GridWatcherManager watchers = new GridWatcherManagerImpl();

    public GridNetworkNode(long energyUsage) {
        this.energyUsage = energyUsage;
    }

    @Override
    public long getEnergyUsage() {
        return this.energyUsage;
    }

    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        this.watchers.addWatcher(watcher, actorType, Objects.requireNonNull(this.network).getComponent(StorageNetworkComponent.class));
    }

    public void removeWatcher(GridWatcher watcher) {
        this.watchers.removeWatcher(watcher, Objects.requireNonNull(this.network).getComponent(StorageNetworkComponent.class));
    }

    @Override
    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        this.watchers.activeChanged(newActive);
    }

    @Override
    public void setNetwork(@Nullable Network network) {
        if (this.network != null) {
            this.watchers.detachAll(this.network.getComponent(StorageNetworkComponent.class));
        }
        super.setNetwork(network);
        if (this.network != null) {
            this.watchers.attachAll(this.network.getComponent(StorageNetworkComponent.class));
        }
    }
}

