/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.exporter;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.api.storage.TransferHelper;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.ToLongFunction;

public class ExporterTransferStrategyImpl
implements ExporterTransferStrategy {
    private final InsertableStorage destination;
    private final ToLongFunction<ResourceKey> transferQuotaProvider;
    private final BiFunction<RootStorage, ResourceKey, Collection<ResourceKey>> expander;

    public ExporterTransferStrategyImpl(InsertableStorage destination, ToLongFunction<ResourceKey> transferQuotaProvider) {
        this(destination, transferQuotaProvider, (rootStorage, resource) -> Collections.singletonList(resource));
    }

    public ExporterTransferStrategyImpl(InsertableStorage destination, ToLongFunction<ResourceKey> transferQuotaProvider, BiFunction<RootStorage, ResourceKey, Collection<ResourceKey>> expander) {
        this.destination = destination;
        this.transferQuotaProvider = transferQuotaProvider;
        this.expander = expander;
    }

    @Override
    public ExporterTransferStrategy.Result transfer(ResourceKey resource, Actor actor, Network network) {
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        long amount = this.transferQuotaProvider.applyAsLong(resource);
        if (amount <= 0L) {
            return ExporterTransferStrategy.Result.EXPORTED;
        }
        for (ResourceKey expandedResource : this.expander.apply(rootStorage, resource)) {
            long extractedSimulated = rootStorage.extract(expandedResource, amount, Action.SIMULATE, actor);
            if (extractedSimulated == 0L) continue;
            long insertedSimulated = this.destination.insert(expandedResource, extractedSimulated, Action.SIMULATE, actor);
            if (insertedSimulated == 0L) {
                return ExporterTransferStrategy.Result.DESTINATION_DOES_NOT_ACCEPT;
            }
            long extracted = rootStorage.extract(expandedResource, insertedSimulated, Action.EXECUTE, actor);
            if (extracted == 0L) continue;
            long inserted = this.destination.insert(expandedResource, extracted, Action.EXECUTE, actor);
            long leftover = extracted - inserted;
            if (leftover > 0L) {
                TransferHelper.handleLeftover(expandedResource, actor, rootStorage, leftover);
            }
            return ExporterTransferStrategy.Result.EXPORTED;
        }
        return ExporterTransferStrategy.Result.RESOURCE_MISSING;
    }
}

