/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.structureessentials.StructureEssentials;
import com.structureessentials.Timings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={PlacedFeature.class})
public abstract class PlacedFeatureErrorMixin {
    PlacedFeature self = (PlacedFeature)this;

    @Shadow
    protected abstract boolean placeWithContext(PlacementContext var1, RandomSource var2, BlockPos var3);

    @Redirect(method={"place"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;placeWithContext(Lnet/minecraft/world/level/levelgen/placement/PlacementContext;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;)Z"))
    private boolean onPlace(PlacedFeature feature, PlacementContext context, RandomSource randomSource, BlockPos pos) {
        ResourceLocation key = ((Registry)context.getLevel().registryAccess().registry(Registries.PLACED_FEATURE).get()).getKey((Object)this.self);
        try {
            long prev = System.nanoTime();
            boolean result = this.placeWithContext(context, randomSource, pos);
            prev = (System.nanoTime() - prev) / 10L;
            if (key != null) {
                Timings.featureTimings.put(key, Timings.featureTimings.getOrDefault(key, 0L) + prev);
            }
            return result;
        }
        catch (Exception e) {
            StructureEssentials.LOGGER.warn("Feature: " + String.valueOf(key) + " errored during placement at " + String.valueOf(pos));
            return false;
        }
    }

    @Redirect(method={"placeWithBiomeCheck"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;placeWithContext(Lnet/minecraft/world/level/levelgen/placement/PlacementContext;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;)Z"))
    private boolean onPlaceWithBiome(PlacedFeature feature, PlacementContext context, RandomSource randomSource, BlockPos pos) {
        ResourceLocation key = ((Registry)context.getLevel().registryAccess().registry(Registries.PLACED_FEATURE).get()).getKey((Object)this.self);
        try {
            long prev = System.nanoTime();
            boolean result = this.placeWithContext(context, randomSource, pos);
            prev = (System.nanoTime() - prev) / 10L;
            if (key != null) {
                Timings.featureTimings.put(key, Timings.featureTimings.getOrDefault(key, 0L) + prev);
            }
            return result;
        }
        catch (Exception e) {
            StructureEssentials.LOGGER.warn("Feature: " + String.valueOf(key) + " errored during placement at " + String.valueOf(pos));
            return false;
        }
    }
}

