/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.items;

import com.mrbysco.skinnedcarts.entity.AbstractSkinnedCart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class CustomCartItem
extends Item {
    public static final DispenseItemBehavior MINECART_DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = source.level();
            Vec3 center = source.center();
            double d0 = center.x() + (double)direction.getStepX() * 1.125;
            double d1 = Math.floor(center.y()) + (double)direction.getStepY();
            double d2 = center.z() + (double)direction.getStepZ() * 1.125;
            BlockPos blockpos = source.pos().relative(direction);
            BlockState blockstate = level.getBlockState(blockpos);
            RailShape railShape = railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.is(BlockTags.RAILS)) {
                d3 = railshape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!blockstate.isAir() || !level.getBlockState(blockpos.below()).is(BlockTags.RAILS)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }
                BlockState blockstate1 = level.getBlockState(blockpos.below());
                RailShape railshape1 = blockstate1.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate1.getBlock()).getRailDirection(blockstate1, (BlockGetter)level, blockpos.below(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railshape1.isAscending() ? -0.4 : -0.9;
            }
            AbstractSkinnedCart skinnedCart = AbstractSkinnedCart.create((Level)level, d0, d1 + d3, d2, ((CustomCartItem)stack.getItem()).cartType);
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                skinnedCart.setCustomName(stack.getHoverName());
            }
            level.addFreshEntity((Entity)skinnedCart);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource source) {
            source.level().levelEvent(1000, source.pos(), 0);
        }
    };
    private final AbstractSkinnedCart.Type cartType;

    public CustomCartItem(AbstractSkinnedCart.Type type, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.cartType = type;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (!state.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.getItemInHand();
        if (!level.isClientSide) {
            RailShape shape = state.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)state.getBlock()).getRailDirection(state, (BlockGetter)level, pos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (shape.isAscending()) {
                d0 = 0.5;
            }
            AbstractSkinnedCart skinnedCart = AbstractSkinnedCart.create(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.0625 + d0, (double)pos.getZ() + 0.5, this.cartType);
            if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                skinnedCart.setCustomName(itemstack.getHoverName());
            }
            level.addFreshEntity((Entity)skinnedCart);
        }
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }
}

