/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.entity;

import com.mrbysco.skinnedcarts.config.CartConfig;
import com.mrbysco.skinnedcarts.entity.AbstractSkinnedCart;
import com.mrbysco.skinnedcarts.init.CartRegistry;
import java.util.Calendar;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FrogCartEntity
extends AbstractSkinnedCart {
    public FrogCartEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public FrogCartEntity(EntityType<?> type, Level level, double x, double y, double z) {
        super(type, level, x, y, z);
    }

    public EntityType<?> getType() {
        return CartRegistry.FROG_CART.get();
    }

    @Override
    public AbstractSkinnedCart.Type getSkinCartType() {
        return AbstractSkinnedCart.Type.FROG;
    }

    @Override
    protected Item getReturnItem() {
        return (Item)CartRegistry.FROG_CART_ITEM.get();
    }

    private void playLivingSound() {
        this.playSound((SoundEvent)CartRegistry.WEDNESDAY_FROG_CART.get(), this.getSoundVolume(), this.getSoundPitch());
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected float getSoundPitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (((Boolean)CartConfig.SERVER.wednesdayFrogCart.get()).booleanValue() && this.itsWednesday() && !this.level().isClientSide) {
            this.playLivingSound();
        }
        return super.interactAt(player, vec, hand);
    }

    private boolean itsWednesday() {
        return Calendar.getInstance().get(7) == 4;
    }
}

