/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.entity;

import com.mrbysco.skinnedcarts.entity.BeeCartEntity;
import com.mrbysco.skinnedcarts.entity.ElephantCartEntity;
import com.mrbysco.skinnedcarts.entity.FrogCartEntity;
import com.mrbysco.skinnedcarts.entity.GreenFrogCartEntity;
import com.mrbysco.skinnedcarts.entity.LadybugCartEntity;
import com.mrbysco.skinnedcarts.entity.PandaCartEntity;
import com.mrbysco.skinnedcarts.entity.PelicanCartEntity;
import com.mrbysco.skinnedcarts.entity.PenguinCartEntity;
import com.mrbysco.skinnedcarts.entity.PufferFishCartEntity;
import com.mrbysco.skinnedcarts.entity.SnailCartEntity;
import com.mrbysco.skinnedcarts.entity.TurtleCartEntity;
import com.mrbysco.skinnedcarts.entity.WombatCartEntity;
import com.mrbysco.skinnedcarts.init.CartRegistry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class AbstractSkinnedCart
extends Minecart {
    public AbstractSkinnedCart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public AbstractSkinnedCart(EntityType<?> type, Level level, double x, double y, double z) {
        super(level, x, y, z);
    }

    protected abstract Item getReturnItem();

    public Item getDropItem() {
        return this.getReturnItem();
    }

    public abstract Type getSkinCartType();

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public boolean isPoweredCart() {
        return false;
    }

    public static AbstractSkinnedCart create(Level level, double x, double y, double z, Type typeIn) {
        return switch (typeIn.ordinal()) {
            default -> new TurtleCartEntity(CartRegistry.TURTLE_CART.get(), level, x, y, z);
            case 0 -> new ElephantCartEntity(CartRegistry.ELEPHANT_CART.get(), level, x, y, z);
            case 1 -> new FrogCartEntity(CartRegistry.FROG_CART.get(), level, x, y, z);
            case 2 -> new PandaCartEntity(CartRegistry.PANDA_CART.get(), level, x, y, z);
            case 3 -> new PelicanCartEntity(CartRegistry.PELICAN_CART.get(), level, x, y, z);
            case 4 -> new PufferFishCartEntity(CartRegistry.PUFFERFISH_CART.get(), level, x, y, z);
            case 5 -> new SnailCartEntity(CartRegistry.SNAIL_CART.get(), level, x, y, z);
            case 7 -> new BeeCartEntity(CartRegistry.BEE_CART.get(), level, x, y, z);
            case 8 -> new GreenFrogCartEntity(CartRegistry.GREEN_FROG_CART.get(), level, x, y, z);
            case 9 -> new LadybugCartEntity(CartRegistry.LADYBUG_CART.get(), level, x, y, z);
            case 10 -> new PenguinCartEntity(CartRegistry.PENGUIN_CART.get(), level, x, y, z);
            case 11 -> new WombatCartEntity(CartRegistry.WOMBAT_CART.get(), level, x, y, z);
        };
    }

    public static enum Type {
        ELEPHANT,
        FROG,
        PANDA,
        PELICAN,
        PUFFERFISH,
        SNAIL,
        TURTLE,
        BEE,
        GREEN_FROG,
        LADYBUG,
        PENGUIN,
        WOMBAT;

    }
}

