/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.datagen;

import com.mrbysco.skinnedcarts.SkinnedCarts;
import com.mrbysco.skinnedcarts.init.CartRegistry;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CartDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput, lookupProvider));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Language(packOutput));
            generator.addProvider(true, (DataProvider)new SoundDefinitions(packOutput, helper));
            generator.addProvider(true, (DataProvider)new ItemModels(packOutput, helper));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput recipeOutput) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.BEE_CART_ITEM.get())).pattern("YBY").pattern("BMB").pattern("YBY").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('B'), (ItemLike)Items.BLACK_WOOL).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.ELEPHANT_CART_ITEM.get())).pattern("GGG").pattern("GMG").pattern("GGG").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('G'), (ItemLike)Items.GRAY_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.FROG_CART_ITEM.get())).pattern("GGG").pattern("GMG").pattern("GGG").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('G'), (ItemLike)Items.LIGHT_GRAY_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.GREEN_FROG_CART_ITEM.get())).pattern("GGG").pattern("GMG").pattern("WWW").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('G'), (ItemLike)Items.GREEN_WOOL).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.LADYBUG_CART_ITEM.get())).pattern("RRR").pattern("RMR").pattern("BBB").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('R'), (ItemLike)Items.RED_WOOL).define(Character.valueOf('B'), (ItemLike)Items.BLACK_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.PANDA_CART_ITEM.get())).pattern("BWB").pattern("WMW").pattern("BWB").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('B'), (ItemLike)Items.BLACK_WOOL).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.PELICAN_CART_ITEM.get())).pattern("WWW").pattern("YMW").pattern("YYY").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.PENGUIN_CART_ITEM.get())).pattern("BBB").pattern("YMY").pattern("WWW").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('B'), (ItemLike)Items.BLACK_WOOL).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.PUFFERFISH_CART_ITEM.get())).pattern("YWY").pattern("WMW").pattern("YWY").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('W'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.SNAIL_CART_ITEM.get())).pattern("BBB").pattern("BMB").pattern("GGG").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('B'), (ItemLike)Items.BROWN_WOOL).define(Character.valueOf('G'), (ItemLike)Items.LIGHT_GRAY_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.TURTLE_CART_ITEM.get())).pattern("GGG").pattern("GMG").pattern("YYY").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('G'), (ItemLike)Items.GREEN_WOOL).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)CartRegistry.WOMBAT_CART_ITEM.get())).pattern("BBB").pattern("BMB").pattern("BBB").define(Character.valueOf('M'), (ItemLike)Items.MINECART).define(Character.valueOf('B'), (ItemLike)Items.BROWN_WOOL).unlockedBy("has_minecart", Recipes.has((ItemLike)Items.MINECART)).save(recipeOutput);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "skinnedcarts", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.skinnedcarts.tab", "Skinned Carts");
            this.add("skinnedcarts.config.title", "Skinned Carts config");
            this.addItem((Supplier)CartRegistry.ELEPHANT_CART_ITEM, "Elephant Minecart");
            this.addItem((Supplier)CartRegistry.FROG_CART_ITEM, "Frog Minecart");
            this.addItem((Supplier)CartRegistry.PANDA_CART_ITEM, "Panda Minecart");
            this.addItem((Supplier)CartRegistry.PELICAN_CART_ITEM, "Pelican Minecart");
            this.addItem((Supplier)CartRegistry.PUFFERFISH_CART_ITEM, "Pufferfish Minecart");
            this.addItem((Supplier)CartRegistry.SNAIL_CART_ITEM, "Snail Minecart");
            this.addItem((Supplier)CartRegistry.TURTLE_CART_ITEM, "Turtle Minecart");
            this.addItem((Supplier)CartRegistry.BEE_CART_ITEM, "Bee Minecart");
            this.addItem((Supplier)CartRegistry.GREEN_FROG_CART_ITEM, "Green Frog Minecart");
            this.addItem((Supplier)CartRegistry.LADYBUG_CART_ITEM, "Ladybug Minecart");
            this.addItem((Supplier)CartRegistry.PENGUIN_CART_ITEM, "Penguin Minecart");
            this.addItem((Supplier)CartRegistry.WOMBAT_CART_ITEM, "Wombat Minecart");
            this.addEntityType(CartRegistry.ELEPHANT_CART, "Elephant Minecart");
            this.addEntityType(CartRegistry.FROG_CART, "Frog Minecart");
            this.addEntityType(CartRegistry.PANDA_CART, "Panda Minecart");
            this.addEntityType(CartRegistry.PELICAN_CART, "Pelican Minecart");
            this.addEntityType(CartRegistry.PUFFERFISH_CART, "Pufferfish Minecart");
            this.addEntityType(CartRegistry.SNAIL_CART, "Snail Minecart");
            this.addEntityType(CartRegistry.TURTLE_CART, "Turtle Minecart");
            this.addEntityType(CartRegistry.BEE_CART, "Bee Minecart");
            this.addEntityType(CartRegistry.GREEN_FROG_CART, "Green Frog Minecart");
            this.addEntityType(CartRegistry.LADYBUG_CART, "Ladybug Minecart");
            this.addEntityType(CartRegistry.PENGUIN_CART, "Penguin Minecart");
            this.addEntityType(CartRegistry.WOMBAT_CART, "Wombat Minecart");
            this.addSubtitle((Supplier<SoundEvent>)CartRegistry.WEDNESDAY_FROG_CART, "It's wednesday");
            this.addConfig("title", "Skinned Carts Config", null);
            this.addConfig("general", "General", "General Settings");
            this.addConfig("wednesdayFrogCart", "Wednesday Frog Cart", "Setting this to true occasionally makes the frog carts acknowledge the day (Default: false)");
        }

        public void addSubtitle(Supplier<SoundEvent> sound, String name) {
            this.addSubtitle(sound.get(), name);
        }

        public void addSubtitle(SoundEvent sound, String name) {
            String path = "skinnedcarts.subtitle." + sound.getLocation().getPath();
            this.add(path, name);
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("skinnedcarts.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("skinnedcarts.configuration." + path + ".tooltip", description);
            }
        }
    }

    private static class SoundDefinitions
    extends SoundDefinitionsProvider {
        public SoundDefinitions(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "skinnedcarts", helper);
        }

        public void registerSounds() {
            this.add((Supplier)CartRegistry.WEDNESDAY_FROG_CART, SoundDefinitions.definition().subtitle(this.modSubtitle(CartRegistry.WEDNESDAY_FROG_CART.getId())).with(SoundDefinitions.sound((ResourceLocation)SkinnedCarts.modLoc("wednesday"))));
        }

        public String modSubtitle(ResourceLocation id) {
            return "skinnedcarts.subtitle." + id.getPath();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "skinnedcarts", helper);
        }

        protected void registerModels() {
            CartRegistry.ITEMS.getEntries().forEach(item -> {
                String path = Objects.requireNonNull(item.getId()).getPath();
                this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
            });
        }
    }
}

