/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.config;

import com.mrbysco.skinnedcarts.SkinnedCarts;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CartConfig {
    public static final ModConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        SkinnedCarts.LOGGER.debug("Loaded SkinnedCart's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        SkinnedCarts.LOGGER.debug("SkinnedCart's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ModConfigSpec.BooleanValue wednesdayFrogCart;

        Server(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.wednesdayFrogCart = builder.comment("Setting this to true occasionally makes the frog carts acknowledge the day (Default: false)").define("wednesdayFrogCart", true);
            builder.pop();
        }
    }
}

