/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts;

import com.mojang.logging.LogUtils;
import com.mrbysco.skinnedcarts.client.ClientHandler;
import com.mrbysco.skinnedcarts.config.CartConfig;
import com.mrbysco.skinnedcarts.init.CartRegistry;
import com.mrbysco.skinnedcarts.items.CustomCartItem;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.slf4j.Logger;

@Mod(value="skinnedcarts")
public class SkinnedCarts {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "skinnedcarts";

    public SkinnedCarts(IEventBus eventBus, ModContainer container, Dist dist) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CartConfig.serverSpec);
        eventBus.register(CartConfig.class);
        eventBus.addListener(this::setup);
        CartRegistry.ITEMS.register(eventBus);
        CartRegistry.CREATIVE_MODE_TABS.register(eventBus);
        CartRegistry.ENTITY_TYPES.register(eventBus);
        CartRegistry.SOUND_EVENTS.register(eventBus);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::registerEntityRenders);
            eventBus.addListener(ClientHandler::registerLayerDefinitions);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (DeferredHolder deferredHolder : CartRegistry.ITEMS.getEntries()) {
                Object patt0$temp = deferredHolder.get();
                if (!(patt0$temp instanceof CustomCartItem)) continue;
                CustomCartItem cart = (CustomCartItem)((Object)((Object)patt0$temp));
                DispenserBlock.registerBehavior((ItemLike)cart, (DispenseItemBehavior)CustomCartItem.MINECART_DISPENSER_BEHAVIOR);
            }
        });
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

