/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class OtherPlayerInventory
implements Container {
    private final ServerPlayer player;

    public OtherPlayerInventory(ServerPlayer player) {
        this.player = player;
    }

    public int getContainerSize() {
        return 45;
    }

    public boolean isEmpty() {
        return this.player.getInventory().isEmpty();
    }

    public boolean isInvalidSlot(int index) {
        return index >= 4 && index < 8;
    }

    public int getSlot(int index) {
        if (index == 8) {
            return 40;
        }
        if (index >= 0 && index <= 3) {
            return 39 - index;
        }
        if (index >= 9 && index <= 35) {
            return index;
        }
        if (index >= 36 && index <= 44) {
            return index - 36;
        }
        return -1;
    }

    public ItemStack getItem(int index) {
        if (this.isInvalidSlot(index)) {
            return ItemStack.EMPTY;
        }
        int slot = this.getSlot(index);
        return slot == -1 ? ItemStack.EMPTY : this.player.getInventory().getItem(slot);
    }

    public ItemStack removeItem(int index, int count) {
        if (this.isInvalidSlot(index)) {
            return ItemStack.EMPTY;
        }
        int slot = this.getSlot(index);
        return slot == -1 ? ItemStack.EMPTY : this.player.getInventory().removeItem(slot, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        if (this.isInvalidSlot(index)) {
            return ItemStack.EMPTY;
        }
        int slot = this.getSlot(index);
        return slot == -1 ? ItemStack.EMPTY : this.player.getInventory().removeItemNoUpdate(slot);
    }

    public void setItem(int index, ItemStack is) {
        if (this.isInvalidSlot(index)) {
            return;
        }
        int slot = this.getSlot(index);
        if (slot != -1) {
            this.player.getInventory().setItem(slot, is);
            this.setChanged();
        }
    }

    public int getMaxStackSize() {
        return this.player.getInventory().getMaxStackSize();
    }

    public void setChanged() {
        this.player.getInventory().setChanged();
        this.player.containerMenu.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (this.isInvalidSlot(index)) {
            return false;
        }
        int slot = this.getSlot(index);
        return slot != -1 && this.player.getInventory().canPlaceItem(slot, stack);
    }

    public void clearContent() {
        this.player.getInventory().clearContent();
    }
}

