/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.ToggleableConfig;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public record SimpleCommandPlayer(String name, int permissionLevel, ToggleableConfig config, EntitySelectorAction action) implements FTBCommand
{
    public static SimpleCommandPlayer create(String name, int permissionLevel, ToggleableConfig config, EntitySelectorAction action) {
        return new SimpleCommandPlayer(name, permissionLevel, config, action);
    }

    public static SimpleCommandPlayer create(String name, ToggleableConfig config, EntitySelectorAction action) {
        return new SimpleCommandPlayer(name, 0, config, action);
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        LiteralArgumentBuilder command = Commands.literal((String)this.name);
        if (this.permissionLevel > 0) {
            command.requires(cs -> cs.hasPermission(this.permissionLevel));
        }
        ((LiteralArgumentBuilder)command.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            this.action.accept((CommandContext<CommandSourceStack>)context, player);
            return 1;
        })).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer entities = EntityArgument.getPlayer((CommandContext)context, (String)"target");
            this.action.accept((CommandContext<CommandSourceStack>)context, entities);
            return 1;
        }));
        return List.of(command);
    }

    @Override
    public boolean enabled() {
        return this.config.isEnabled();
    }

    @FunctionalInterface
    public static interface EntitySelectorAction {
        public void accept(CommandContext<CommandSourceStack> var1, ServerPlayer var2);
    }
}

