/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.leaves;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.client.particle.RuParticleTypes;
import net.regions_unexplored.config.RuCommonConfig;

public class MauveLeavesBlock
extends LeavesBlock {
    public MauveLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        BlockPos blockpos;
        BlockState blockstate;
        super.animateTick(state, level, blockPos, randomSource);
        if (randomSource.nextInt(10) == 0 && !MauveLeavesBlock.isFaceFull((VoxelShape)(blockstate = level.getBlockState(blockpos = blockPos.below())).getCollisionShape((BlockGetter)level, blockpos), (Direction)Direction.UP) && ((Boolean)RuCommonConfig.TOGGLE_MAUVE_LEAVES_PARTICLE.get()).booleanValue()) {
            MauveLeavesBlock.spawnParticleBelow(level, blockPos, randomSource, (ParticleOptions)RuParticleTypes.MAUVE_LEAVES);
        }
    }

    public static void spawnParticleBelow(Level level, BlockPos blockPos, RandomSource source, ParticleOptions particleOptions) {
        double d0 = (double)blockPos.getX() + source.nextDouble();
        double d1 = (double)blockPos.getY() - 0.05;
        double d2 = (double)blockPos.getZ() + source.nextDouble();
        level.addParticle(particleOptions, d0, d1, d2, 0.0, 0.0, 0.0);
    }
}

