/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.worldgen.features.RuNetherFeatures;
import net.regions_unexplored.data.worldgen.features.RuVegetationFeatures;
import net.regions_unexplored.registry.PlacedFeatureRegistry;

public class RuNetherPlacements {
    public static final ResourceKey<PlacedFeature> SMALL_YELLOW_BIOSHROOM = PlacedFeatureRegistry.createKey("small_yellow_bioshroom");
    public static final ResourceKey<PlacedFeature> MYCOTOXIC_MUSHROOMS = PlacedFeatureRegistry.createKey("mycotoxic_mushrooms");
    public static final ResourceKey<PlacedFeature> MYCOTOXIC_GRASS = PlacedFeatureRegistry.createKey("mycotoxic_grass");
    public static final ResourceKey<PlacedFeature> MYCOTOXIC_DAISY = PlacedFeatureRegistry.createKey("mycotoxic_daisy");
    public static final ResourceKey<PlacedFeature> MYCOTOXIC_BIOSHROOM = PlacedFeatureRegistry.createKey("mycotoxic_bioshroom");
    public static final ResourceKey<PlacedFeature> BRIMSPROUT = PlacedFeatureRegistry.createKey("brimsprout");
    public static final ResourceKey<PlacedFeature> BRIM_FLAMES = PlacedFeatureRegistry.createKey("brim_flames");
    public static final ResourceKey<PlacedFeature> DORCEL = PlacedFeatureRegistry.createKey("dorcel");
    public static final ResourceKey<PlacedFeature> BRIMWOOD_SHRUB = PlacedFeatureRegistry.createKey("brimwood_shrub");
    public static final ResourceKey<PlacedFeature> GLISTERING_MEADOW_ROCK = PlacedFeatureRegistry.createKey("glistering_meadow_rock");
    public static final ResourceKey<PlacedFeature> GLISTERING_IVY = PlacedFeatureRegistry.createKey("glistering_ivy");
    public static final ResourceKey<PlacedFeature> GLISTERING_SPROUT = PlacedFeatureRegistry.createKey("glistering_sprout");
    public static final ResourceKey<PlacedFeature> GLISTERING_FERN = PlacedFeatureRegistry.createKey("glistering_fern");
    public static final ResourceKey<PlacedFeature> GLISTERING_BLOOM = PlacedFeatureRegistry.createKey("glistering_bloom");
    public static final ResourceKey<PlacedFeature> GLISTER_SPIRE = PlacedFeatureRegistry.createKey("glister_spire");
    public static final ResourceKey<PlacedFeature> GLISTER_BULB = PlacedFeatureRegistry.createKey("glister_bulb");
    public static final ResourceKey<PlacedFeature> HANGING_EARLIGHT = PlacedFeatureRegistry.createKey("hanging_earlight");
    public static final ResourceKey<PlacedFeature> COBALT_ROOTS = PlacedFeatureRegistry.createKey("cobalt_roots");
    public static final ResourceKey<PlacedFeature> BLACKSTONE_CLUSTER = PlacedFeatureRegistry.createKey("blackstone_cluster");
    public static final ResourceKey<PlacedFeature> COBALT_EARLIGHT = PlacedFeatureRegistry.createKey("cobalt_earlight");
    public static final ResourceKey<PlacedFeature> TALL_COBALT_EARLIGHT = PlacedFeatureRegistry.createKey("tall_cobalt_earlight");
    public static final ResourceKey<PlacedFeature> OBSIDIAN_SPIRE = PlacedFeatureRegistry.createKey("obsidian_spire");
    public static final ResourceKey<PlacedFeature> POINTED_REDSTONE_NETHER = PlacedFeatureRegistry.createKey("pointed_redstone_nether");
    public static final ResourceKey<PlacedFeature> LARGE_POINTED_REDSTONE_NETHER = PlacedFeatureRegistry.createKey("large_pointed_redstone_nether");
    public static final ResourceKey<PlacedFeature> POINTED_REDSTONE_CLUSTER_NETHER = PlacedFeatureRegistry.createKey("pointed_redstone_cluster_nether");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter featureGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference SMALL_YELLOW_BIOSHROOM = featureGetter.getOrThrow(RuNetherFeatures.SMALL_YELLOW_BIOSHROOM);
        Holder.Reference MYCOTOXIC_MUSHROOMS = featureGetter.getOrThrow(RuNetherFeatures.PATCH_MYCOTOXIC_MUSHROOMS);
        Holder.Reference MYCOTOXIC_GRASS = featureGetter.getOrThrow(RuNetherFeatures.PATCH_MYCOTOXIC_GRASS);
        Holder.Reference MYCOTOXIC_DAISY = featureGetter.getOrThrow(RuNetherFeatures.PATCH_MYCOTOXIC_DAISY);
        Holder.Reference MYCOTOXIC_BIOSHROOM = featureGetter.getOrThrow(RuVegetationFeatures.PATCH_YELLOW_BIOSHROOM);
        Holder.Reference BRIMSPROUT = featureGetter.getOrThrow(RuNetherFeatures.PATCH_BRIMSPROUT);
        Holder.Reference BRIM_FLAMES = featureGetter.getOrThrow(RuNetherFeatures.PATCH_BRIM_FLAMES);
        Holder.Reference DORCEL = featureGetter.getOrThrow(RuNetherFeatures.DORCEL);
        Holder.Reference BRIMWOOD_SHRUB = featureGetter.getOrThrow(RuNetherFeatures.BRIMWOOD_SHRUB);
        Holder.Reference GLISTERING_MEADOW_ROCK = featureGetter.getOrThrow(RuNetherFeatures.NETHER_ROCK);
        Holder.Reference GLISTERING_IVY = featureGetter.getOrThrow(RuNetherFeatures.PATCH_GLISTERING_IVY);
        Holder.Reference GLISTERING_SPROUT = featureGetter.getOrThrow(RuNetherFeatures.PATCH_GLISTERING_SPROUT);
        Holder.Reference GLISTERING_FERN = featureGetter.getOrThrow(RuNetherFeatures.PATCH_GLISTERING_FERN);
        Holder.Reference GLISTERING_BLOOM = featureGetter.getOrThrow(RuNetherFeatures.PATCH_GLISTERING_BLOOM);
        Holder.Reference GLISTER_SPIRE = featureGetter.getOrThrow(RuNetherFeatures.PATCH_GLISTER_SPIRE);
        Holder.Reference GLISTER_BULB = featureGetter.getOrThrow(RuNetherFeatures.PATCH_GLISTER_BULB);
        Holder.Reference HANGING_EARLIGHT = featureGetter.getOrThrow(RuNetherFeatures.PATCH_HANGING_EARLIGHT);
        Holder.Reference COBALT_ROOTS = featureGetter.getOrThrow(RuNetherFeatures.PATCH_COBALT_ROOTS);
        Holder.Reference BLACKSTONE_CLUSTER = featureGetter.getOrThrow(RuNetherFeatures.PATCH_BLACKSTONE_CLUSTER);
        Holder.Reference COBALT_EARLIGHT = featureGetter.getOrThrow(RuNetherFeatures.PATCH_COBALT_EARLIGHT);
        Holder.Reference TALL_COBALT_EARLIGHT = featureGetter.getOrThrow(RuNetherFeatures.TALL_COBALT_EARLIGHT);
        Holder.Reference OBSIDIAN_SPIRE = featureGetter.getOrThrow(RuNetherFeatures.OBSIDIAN_SPIRE);
        Holder.Reference POINTED_REDSTONE_NETHER = featureGetter.getOrThrow(RuNetherFeatures.POINTED_REDSTONE_NETHER);
        Holder.Reference LARGE_POINTED_REDSTONE_NETHER = featureGetter.getOrThrow(RuNetherFeatures.LARGE_POINTED_REDSTONE_NETHER);
        Holder.Reference POINTED_REDSTONE_CLUSTER_NETHER = featureGetter.getOrThrow(RuNetherFeatures.POINTED_REDSTONE_CLUSTER_NETHER);
        RuNetherPlacements.register(context, RuNetherPlacements.SMALL_YELLOW_BIOSHROOM, SMALL_YELLOW_BIOSHROOM, List.of(CountOnEveryLayerPlacement.of((int)1), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.MYCOTOXIC_GRASS.get()), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.MYCOTOXIC_MUSHROOMS, MYCOTOXIC_MUSHROOMS, List.of(CountOnEveryLayerPlacement.of((int)1), NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)12), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.MYCOTOXIC_GRASS, MYCOTOXIC_GRASS, List.of(CountOnEveryLayerPlacement.of((int)30), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.MYCOTOXIC_DAISY, MYCOTOXIC_DAISY, List.of(CountOnEveryLayerPlacement.of((int)5), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.MYCOTOXIC_BIOSHROOM, MYCOTOXIC_BIOSHROOM, List.of(CountOnEveryLayerPlacement.of((int)7), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.STONE_BUD.get()), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.BRIMSPROUT, BRIMSPROUT, List.of(CountOnEveryLayerPlacement.of((int)30), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.BRIM_FLAMES, BRIM_FLAMES, List.of(CountOnEveryLayerPlacement.of((int)5), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.BRIMSPROUT.get()), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.DORCEL, DORCEL, List.of(CountOnEveryLayerPlacement.of((int)2), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.BRIMSPROUT.get()), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.BRIMWOOD_SHRUB, BRIMWOOD_SHRUB, List.of(CountOnEveryLayerPlacement.of((int)1), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.BRIMSPROUT.get()), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTERING_MEADOW_ROCK, GLISTERING_MEADOW_ROCK, new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)1), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.GLISTERING_NYLIUM.get()), BiomeFilter.biome()});
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTERING_IVY, GLISTERING_IVY, new PlacementModifier[]{CountPlacement.of((int)155), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome()});
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTERING_SPROUT, GLISTERING_SPROUT, List.of(CountOnEveryLayerPlacement.of((int)30), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTERING_FERN, GLISTERING_FERN, List.of(CountOnEveryLayerPlacement.of((int)15), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTERING_BLOOM, GLISTERING_BLOOM, List.of(CountOnEveryLayerPlacement.of((int)7), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTER_SPIRE, GLISTER_SPIRE, List.of(CountOnEveryLayerPlacement.of((int)3), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.GLISTER_BULB, GLISTER_BULB, List.of(CountOnEveryLayerPlacement.of((int)2), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.HANGING_EARLIGHT, HANGING_EARLIGHT, new PlacementModifier[]{CountPlacement.of((int)225), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome()});
        RuNetherPlacements.register(context, RuNetherPlacements.COBALT_ROOTS, COBALT_ROOTS, List.of(CountOnEveryLayerPlacement.of((int)8), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.BLACKSTONE_CLUSTER, BLACKSTONE_CLUSTER, List.of(CountOnEveryLayerPlacement.of((int)4), PlacementUtils.filteredByBlockSurvival((Block)RuBlocks.STONE_BUD.get()), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.COBALT_EARLIGHT, COBALT_EARLIGHT, List.of(CountOnEveryLayerPlacement.of((int)3), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.TALL_COBALT_EARLIGHT, TALL_COBALT_EARLIGHT, List.of(CountOnEveryLayerPlacement.of((int)3), BiomeFilter.biome()));
        RuNetherPlacements.register(context, RuNetherPlacements.OBSIDIAN_SPIRE, OBSIDIAN_SPIRE, new PlacementModifier[]{CountPlacement.of((int)155), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome()});
        RuNetherPlacements.register(context, RuNetherPlacements.POINTED_REDSTONE_NETHER, POINTED_REDSTONE_NETHER, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, CountPlacement.of((IntProvider)UniformInt.of((int)1, (int)5)), RandomOffsetPlacement.of((IntProvider)ClampedNormalInt.of((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.of((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.biome()});
        RuNetherPlacements.register(context, RuNetherPlacements.LARGE_POINTED_REDSTONE_NETHER, LARGE_POINTED_REDSTONE_NETHER, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)10, (int)48)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        RuNetherPlacements.register(context, RuNetherPlacements.POINTED_REDSTONE_CLUSTER_NETHER, POINTED_REDSTONE_CLUSTER_NETHER, new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)78, (int)126)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placement) {
        RuNetherPlacements.register(context, key, feature, List.of(placement));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placement) {
        context.register(key, (Object)new PlacedFeature(feature, placement));
    }
}

