/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.surface;

import com.google.common.collect.ImmutableList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.config.RuCommonConfig;
import net.regions_unexplored.data.noise.RuNoises;
import net.regions_unexplored.data.noise.RuleWeight;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;

public class RuSurfaceRuleData {
    private static final SurfaceRules.RuleSource AIR = RuSurfaceRuleData.makeStateRule(Blocks.CAVE_AIR);
    private static final SurfaceRules.RuleSource WATER = RuSurfaceRuleData.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.RuleSource LAVA = RuSurfaceRuleData.makeStateRule(Blocks.LAVA);
    private static final SurfaceRules.RuleSource PEAT_GRASS_BLOCK = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.PEAT_GRASS_BLOCK.get() : Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource PEAT_COARSE_DIRT = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.PEAT_COARSE_DIRT.get() : Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource PEAT_PODZOL = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.PEAT_PODZOL.get() : Blocks.PODZOL);
    private static final SurfaceRules.RuleSource PEAT_DIRT = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.PEAT_DIRT.get() : Blocks.DIRT);
    private static final SurfaceRules.RuleSource PEAT_MUD = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.PEAT_MUD.get() : Blocks.MUD);
    private static final SurfaceRules.RuleSource SILT_GRASS_BLOCK = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.SILT_GRASS_BLOCK.get() : Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource SILT_COARSE_DIRT = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.SILT_COARSE_DIRT.get() : Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource SILT_PODZOL = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.SILT_PODZOL.get() : Blocks.PODZOL);
    private static final SurfaceRules.RuleSource SILT_DIRT = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.SILT_DIRT.get() : Blocks.DIRT);
    private static final SurfaceRules.RuleSource SILT_MUD = RuSurfaceRuleData.makeStateRule((Boolean)RuCommonConfig.TOGGLE_CUSTOM_DIRTS.get() != false ? RuBlocks.SILT_MUD.get() : Blocks.MUD);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = RuSurfaceRuleData.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource MOSS_BLOCK = RuSurfaceRuleData.makeStateRule(Blocks.MOSS_BLOCK);
    private static final SurfaceRules.RuleSource MYCELIUM = RuSurfaceRuleData.makeStateRule(Blocks.MYCELIUM);
    private static final SurfaceRules.RuleSource COARSE_DIRT = RuSurfaceRuleData.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource PODZOL = RuSurfaceRuleData.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.RuleSource DIRT = RuSurfaceRuleData.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource MUD = RuSurfaceRuleData.makeStateRule(Blocks.MUD);
    private static final SurfaceRules.RuleSource ASHEN_DIRT = RuSurfaceRuleData.makeStateRule(RuBlocks.ASHEN_DIRT.get());
    private static final SurfaceRules.RuleSource ASH_VENT = RuSurfaceRuleData.makeStateRule(RuBlocks.ASH_VENT.get());
    private static final SurfaceRules.RuleSource ALPHA_GRASS = RuSurfaceRuleData.makeStateRule(RuBlocks.ALPHA_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource ARGILLITE_GRASS_BLOCK = RuSurfaceRuleData.makeStateRule(RuBlocks.ARGILLITE_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource CHALK_GRASS_BLOCK = RuSurfaceRuleData.makeStateRule(RuBlocks.CHALK_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource PRISMOSS = RuSurfaceRuleData.makeStateRule(RuBlocks.PRISMOSS.get());
    private static final SurfaceRules.RuleSource VIRIDESCENT_NYLIUM = RuSurfaceRuleData.makeStateRule(RuBlocks.VIRIDESCENT_NYLIUM.get());
    private static final SurfaceRules.RuleSource DEEPSLATE_PRISMOSS = RuSurfaceRuleData.makeStateRule(RuBlocks.DEEPSLATE_PRISMOSS.get());
    private static final SurfaceRules.RuleSource DEEPSLATE_VIRIDESCENT_NYLIUM = RuSurfaceRuleData.makeStateRule(RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get());
    private static final SurfaceRules.RuleSource ARGILLITE = RuSurfaceRuleData.makeStateRule(RuBlocks.ARGILLITE.get());
    private static final SurfaceRules.RuleSource CHALK = RuSurfaceRuleData.makeStateRule(RuBlocks.CHALK.get());
    private static final SurfaceRules.RuleSource STONE = RuSurfaceRuleData.makeStateRule(Blocks.STONE);
    private static final SurfaceRules.RuleSource CALCITE = RuSurfaceRuleData.makeStateRule(Blocks.STONE);
    private static final SurfaceRules.RuleSource DEEPSLATE = RuSurfaceRuleData.makeStateRule(Blocks.DEEPSLATE);
    private static final SurfaceRules.RuleSource NETHERRACK = RuSurfaceRuleData.makeStateRule(Blocks.NETHERRACK);
    private static final SurfaceRules.RuleSource BLACKSTONE = RuSurfaceRuleData.makeStateRule(Blocks.BLACKSTONE);
    private static final SurfaceRules.RuleSource END_STONE = RuSurfaceRuleData.makeStateRule(Blocks.END_STONE);
    private static final SurfaceRules.RuleSource BEDROCK = RuSurfaceRuleData.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource RAW_REDSTONE = RuSurfaceRuleData.makeStateRule(RuBlocks.RAW_REDSTONE_BLOCK.get());
    private static final SurfaceRules.RuleSource TERRACOTTA = RuSurfaceRuleData.makeStateRule(Blocks.TERRACOTTA);
    private static final SurfaceRules.RuleSource ORANGE_TERRACOTTA = RuSurfaceRuleData.makeStateRule(Blocks.ORANGE_TERRACOTTA);
    private static final SurfaceRules.RuleSource WHITE_TERRACOTTA = RuSurfaceRuleData.makeStateRule(Blocks.ORANGE_TERRACOTTA);
    private static final SurfaceRules.RuleSource COBBLESTONE = RuSurfaceRuleData.makeStateRule(Blocks.COBBLESTONE);
    private static final SurfaceRules.RuleSource MOSSY_STONE = RuSurfaceRuleData.makeStateRule(RuBlocks.MOSSY_STONE.get());
    private static final SurfaceRules.RuleSource SANDSTONE = RuSurfaceRuleData.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.RuleSource RED_SANDSTONE = RuSurfaceRuleData.makeStateRule(Blocks.RED_SANDSTONE);
    private static final SurfaceRules.RuleSource SAND = RuSurfaceRuleData.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource RED_SAND = RuSurfaceRuleData.makeStateRule(Blocks.RED_SAND);
    private static final SurfaceRules.RuleSource GRAVEL = RuSurfaceRuleData.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource ASH = RuSurfaceRuleData.makeStateRule(RuBlocks.ASH.get());
    private static final SurfaceRules.RuleSource SNOW_BLOCK = RuSurfaceRuleData.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource POWDER_SNOW = RuSurfaceRuleData.makeStateRule(Blocks.POWDER_SNOW);
    private static final SurfaceRules.RuleSource ICE = RuSurfaceRuleData.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.RuleSource PACKED_ICE = RuSurfaceRuleData.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.RuleSource BRIMSPROUT_NYLIUM = RuSurfaceRuleData.makeStateRule(RuBlocks.BRIMSPROUT_NYLIUM.get());
    private static final SurfaceRules.RuleSource MYCOTOXIC_NYLIUM = RuSurfaceRuleData.makeStateRule(RuBlocks.MYCOTOXIC_NYLIUM.get());
    private static final SurfaceRules.RuleSource GLISTERING_NYLIUM = RuSurfaceRuleData.makeStateRule(RuBlocks.GLISTERING_NYLIUM.get());
    private static final SurfaceRules.RuleSource GLISTERING_WART = RuSurfaceRuleData.makeStateRule(RuBlocks.GLISTERING_WART.get());
    private static final SurfaceRules.RuleSource COBALT_NYLIUM = RuSurfaceRuleData.makeStateRule(RuBlocks.COBALT_NYLIUM.get());
    private static final SurfaceRules.RuleSource SOUL_SAND = RuSurfaceRuleData.makeStateRule(Blocks.SOUL_SAND);
    private static final SurfaceRules.RuleSource SOUL_SOIL = RuSurfaceRuleData.makeStateRule(Blocks.SOUL_SOIL);
    private static final SurfaceRules.RuleSource BASALT = RuSurfaceRuleData.makeStateRule(Blocks.BASALT);
    private static final SurfaceRules.RuleSource WARPED_WART_BLOCK = RuSurfaceRuleData.makeStateRule(Blocks.WARPED_WART_BLOCK);
    private static final SurfaceRules.RuleSource WARPED_NYLIUM = RuSurfaceRuleData.makeStateRule(Blocks.WARPED_NYLIUM);
    private static final SurfaceRules.RuleSource NETHER_WART_BLOCK = RuSurfaceRuleData.makeStateRule(Blocks.NETHER_WART_BLOCK);
    private static final SurfaceRules.RuleSource CRIMSON_NYLIUM = RuSurfaceRuleData.makeStateRule(Blocks.CRIMSON_NYLIUM);

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    public static SurfaceRules.RuleSource cave() {
        return RuSurfaceRuleData.overworldLike(false, false, true);
    }

    public static SurfaceRules.RuleSource overworld() {
        return RuSurfaceRuleData.overworldLike(true, false, true);
    }

    public static SurfaceRules.RuleSource overworldLike(boolean isSurface, boolean bedrockRoof, boolean bedrockFloor) {
        SurfaceRules.ConditionSource deepslateLevel = SurfaceRules.verticalGradient((String)"deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8));
        SurfaceRules.ConditionSource yStart63 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)-1);
        SurfaceRules.ConditionSource yStart74 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)74), (int)1);
        SurfaceRules.ConditionSource y60 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)60), (int)0);
        SurfaceRules.ConditionSource y62 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0);
        SurfaceRules.ConditionSource y63 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0);
        SurfaceRules.ConditionSource y97 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)97), (int)2);
        SurfaceRules.ConditionSource y256 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)256), (int)0);
        SurfaceRules.ConditionSource surfaceNoise1 = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.909, (double)-0.5454);
        SurfaceRules.ConditionSource surfaceNoise2 = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.1818, (double)0.1818);
        SurfaceRules.ConditionSource surfaceNoise3 = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.5454, (double)0.909);
        SurfaceRules.ConditionSource waterBlockCheck = SurfaceRules.waterBlockCheck((int)0, (int)0);
        SurfaceRules.ConditionSource waterBlockCheck1 = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.ConditionSource oceanGravelCheck = SurfaceRules.waterStartCheck((int)-6, (int)-1);
        SurfaceRules.ConditionSource holeCondition = SurfaceRules.hole();
        SurfaceRules.ConditionSource steepCondition = SurfaceRules.steep();
        SurfaceRules.ConditionSource isSandBiome = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ROCKY_REEF, RuBiomes.TROPICAL_RIVER, RuBiomes.GRASSY_BEACH});
        SurfaceRules.ConditionSource isPeatBiome = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BAYOU, RuBiomes.FEN, RuBiomes.PINE_TAIGA, RuBiomes.BLACKWOOD_TAIGA, RuBiomes.BOREAL_TAIGA, RuBiomes.COLD_BOREAL_TAIGA, RuBiomes.GOLDEN_BOREAL_TAIGA});
        SurfaceRules.ConditionSource isSiltBiome = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.PUMPKIN_FIELDS, RuBiomes.POPPY_FIELDS, RuBiomes.AUTUMNAL_MAPLE_FOREST, RuBiomes.SILVER_BIRCH_FOREST, RuBiomes.TROPICS, RuBiomes.DRY_BUSHLAND, RuBiomes.JOSHUA_DESERT, RuBiomes.BARLEY_FIELDS, RuBiomes.PRAIRIE, RuBiomes.ORCHARD, RuBiomes.STEPPE});
        SurfaceRules.ConditionSource isGrassBiome = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ANCIENT_DELTA, RuBiomes.BAOBAB_SAVANNA, RuBiomes.BIOSHROOM_CAVES, RuBiomes.DECIDUOUS_FOREST, RuBiomes.FROZEN_TUNDRA, RuBiomes.FUNGAL_FEN, RuBiomes.PRISMACHASM, RuBiomes.REDSTONE_CAVES, RuBiomes.SCORCHING_CAVES});
        SurfaceRules.RuleSource AlphaGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)ALPHA_GRASS), DIRT});
        SurfaceRules.RuleSource GrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.RuleSource PeatGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)PEAT_GRASS_BLOCK), PEAT_DIRT});
        SurfaceRules.RuleSource SiltGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)SILT_GRASS_BLOCK), SILT_DIRT});
        SurfaceRules.RuleSource ChalkSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)CHALK_GRASS_BLOCK), CHALK});
        SurfaceRules.RuleSource ArgilliteSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)ARGILLITE_GRASS_BLOCK), ARGILLITE});
        SurfaceRules.RuleSource ViridescentSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)VIRIDESCENT_NYLIUM), STONE});
        SurfaceRules.RuleSource DeepslateViridescentSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)DEEPSLATE_VIRIDESCENT_NYLIUM), DEEPSLATE});
        SurfaceRules.RuleSource PrismossSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)PRISMOSS), STONE});
        SurfaceRules.RuleSource DeepslatePrismossSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)DEEPSLATE_PRISMOSS), DEEPSLATE});
        SurfaceRules.RuleSource sandWithSandstoneOverhang = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        SurfaceRules.RuleSource redSandWithSandstoneOverhang = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)RED_SANDSTONE), RED_SAND});
        SurfaceRules.RuleSource gravelWithStoneOverhang = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)STONE), GRAVEL});
        SurfaceRules.RuleSource powderSnowPatch1 = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.58), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)POWDER_SNOW));
        SurfaceRules.RuleSource powderSnowPatch2 = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.35, (double)0.6), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)POWDER_SNOW));
        SurfaceRules.RuleSource deepSurfaceBlocks = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.CHALK_CLIFFS}), (SurfaceRules.RuleSource)CHALK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ARID_MOUNTAINS, RuBiomes.BAOBAB_SAVANNA}), (SurfaceRules.RuleSource)TERRACOTTA)});
        SurfaceRules.RuleSource CaveRules = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.REDSTONE_CAVES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)RuleWeight.getPercent(40)), (SurfaceRules.RuleSource)RAW_REDSTONE))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BIOSHROOM_CAVES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)deepslateLevel, (SurfaceRules.RuleSource)DeepslateViridescentSurface), ViridescentSurface}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ANCIENT_DELTA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.SHIELD, (double)-0.95), (SurfaceRules.RuleSource)ArgilliteSurface)), ARGILLITE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.PRISMACHASM}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)deepslateLevel, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(0.5), (SurfaceRules.RuleSource)DeepslatePrismossSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)RuleWeight.getPercent(30)), (SurfaceRules.RuleSource)DeepslatePrismossSurface)})), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(0.5), (SurfaceRules.RuleSource)PrismossSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)RuleWeight.getPercent(30)), (SurfaceRules.RuleSource)PrismossSurface)})})))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ANCIENT_DELTA}), (SurfaceRules.RuleSource)ARGILLITE))});
        SurfaceRules.RuleSource underSurfaceNoTop = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.MOUNTAINS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)138), (int)0)), (SurfaceRules.RuleSource)DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)186), (int)0), (SurfaceRules.RuleSource)SNOW_BLOCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)CALCITE), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ICY_HEIGHTS, RuBiomes.SPIRES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SNOW_BLOCK)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ARID_MOUNTAINS}), (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BAOBAB_SAVANNA}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.9), (SurfaceRules.RuleSource)TERRACOTTA)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.JOSHUA_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)sandWithSandstoneOverhang)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.SAGUARO_DESERT}), (SurfaceRules.RuleSource)sandWithSandstoneOverhang), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.OUTBACK}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)RuleWeight.getPercent(20)), (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)RuleWeight.getPercent(60)), (SurfaceRules.RuleSource)redSandWithSandstoneOverhang)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ALPHA_GROVE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)66), (int)0)), (SurfaceRules.RuleSource)gravelWithStoneOverhang), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)AlphaGrassSurface), DIRT})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.TROPICS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)64), (int)0)), (SurfaceRules.RuleSource)sandWithSandstoneOverhang)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.MUDDY_RIVER}), (SurfaceRules.RuleSource)PEAT_MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.COLD_RIVER, RuBiomes.GRAVEL_BEACH}), (SurfaceRules.RuleSource)gravelWithStoneOverhang), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSandBiome, (SurfaceRules.RuleSource)sandWithSandstoneOverhang)});
        SurfaceRules.RuleSource underSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ICY_HEIGHTS, RuBiomes.SPIRES, RuBiomes.FROZEN_PINE_TAIGA}), (SurfaceRules.RuleSource)powderSnowPatch1), underSurfaceNoTop, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.TOWERING_CLIFFS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.MAPLE_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.shieldNoise(1.65), (SurfaceRules.RuleSource)STONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.HYACINTH_DEEPS}), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ASHEN_WOODLAND}), (SurfaceRules.RuleSource)ASHEN_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.OLD_GROWTH_BAYOU}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)64), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)MUD))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isPeatBiome, (SurfaceRules.RuleSource)PEAT_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSiltBiome, (SurfaceRules.RuleSource)SILT_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isGrassBiome, (SurfaceRules.RuleSource)DIRT)});
        SurfaceRules.RuleSource onSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.FROZEN_PINE_TAIGA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{powderSnowPatch2, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.FROZEN_TUNDRA}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)SNOW_BLOCK)), underSurfaceNoTop, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.TOWERING_CLIFFS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.25), (SurfaceRules.RuleSource)COBBLESTONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)GRAVEL), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-0.5), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.25), (SurfaceRules.RuleSource)GRASS_BLOCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)-0.25), (SurfaceRules.RuleSource)COARSE_DIRT), COBBLESTONE}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.MAPLE_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.shieldNoise(1.65), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.25), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)MOSSY_STONE), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.shieldNoise(0.0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.25), (SurfaceRules.RuleSource)GRASS_BLOCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)-0.25), (SurfaceRules.RuleSource)COARSE_DIRT), MOSSY_STONE}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.DECIDUOUS_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PODZOL)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.PINE_TAIGA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)PEAT_COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PEAT_PODZOL)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.PUMPKIN_FIELDS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-1.75), (SurfaceRules.RuleSource)SILT_PODZOL)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.POPPY_FIELDS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)RuleWeight.getPercent(50)), (SurfaceRules.RuleSource)SILT_COARSE_DIRT)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.DRY_BUSHLAND}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)RuleWeight.getPercent(30)), (SurfaceRules.RuleSource)SILT_COARSE_DIRT)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.FEN}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.1), (SurfaceRules.RuleSource)PEAT_COARSE_DIRT)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.FUNGAL_FEN}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)MYCELIUM), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-0.5), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)0.1), (SurfaceRules.RuleSource)MYCELIUM))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ASHEN_WOODLAND}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)-0.25), (SurfaceRules.RuleSource)ASHEN_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)RuleWeight.getPercent(4)), (SurfaceRules.RuleSource)ASH_VENT), ASH})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BAYOU}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)64), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)PEAT_MUD))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.OLD_GROWTH_BAYOU}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)MUD)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.TROPICS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)65), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)sandWithSandstoneOverhang))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BAOBAB_SAVANNA}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)RuSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.PINE_SLOPES}), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.REDWOODS}), (SurfaceRules.RuleSource)PODZOL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.CHALK_CLIFFS}), (SurfaceRules.RuleSource)ChalkSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isPeatBiome, (SurfaceRules.RuleSource)PeatGrassSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSiltBiome, (SurfaceRules.RuleSource)SiltGrassSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isGrassBiome, (SurfaceRules.RuleSource)GrassSurface)});
        SurfaceRules.RuleSource buildSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.FEN}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)y62, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)y63), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(RuNoises.WEIGHTED, (double)0.0), (SurfaceRules.RuleSource)WATER))))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)waterBlockCheck1, (SurfaceRules.RuleSource)onSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.HYACINTH_DEEPS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)RuleWeight.getPercent(30)), (SurfaceRules.RuleSource)MOSSY_STONE), GRAVEL}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)oceanGravelCheck, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)deepSurfaceBlocks), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)underSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isSandBiome, (SurfaceRules.RuleSource)SANDSTONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.SAGUARO_DESERT}), (SurfaceRules.RuleSource)SANDSTONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ICY_HEIGHTS, RuBiomes.SPIRES}), (SurfaceRules.RuleSource)PACKED_ICE)}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.ROCKY_REEF}), (SurfaceRules.RuleSource)sandWithSandstoneOverhang)}))});
        ImmutableList.Builder builder = ImmutableList.builder();
        if (bedrockRoof) {
            builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)BEDROCK));
        }
        if (bedrockFloor) {
            builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        }
        SurfaceRules.RuleSource surfaceBlocks = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)buildSurface);
        builder.add((Object)(isSurface ? surfaceBlocks : buildSurface));
        builder.add((Object)CaveRules);
        builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)deepslateLevel, (SurfaceRules.RuleSource)DEEPSLATE));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource nether() {
        SurfaceRules.ConditionSource above31 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)31), (int)0);
        SurfaceRules.ConditionSource above32 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)32), (int)0);
        SurfaceRules.ConditionSource start30 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)30), (int)0);
        SurfaceRules.ConditionSource end35 = SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)35), (int)0));
        SurfaceRules.ConditionSource belowTop5 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0);
        SurfaceRules.ConditionSource hole = SurfaceRules.hole();
        SurfaceRules.ConditionSource soulSandLayerNoise = SurfaceRules.noiseCondition((ResourceKey)Noises.SOUL_SAND_LAYER, (double)-0.012);
        SurfaceRules.ConditionSource gravelLayerNoise = SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL_LAYER, (double)-0.012);
        SurfaceRules.ConditionSource patchNoise = SurfaceRules.noiseCondition((ResourceKey)Noises.PATCH, (double)-0.012);
        SurfaceRules.ConditionSource netherrackNoise = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHERRACK, (double)0.54);
        SurfaceRules.ConditionSource wartNoise = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHER_WART, (double)1.17);
        SurfaceRules.ConditionSource stateSelectorNoise = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHER_STATE_SELECTOR, (double)0.0);
        SurfaceRules.RuleSource gravelPatch = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)patchNoise, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)start30, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)end35, (SurfaceRules.RuleSource)GRAVEL)));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)BEDROCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)belowTop5, (SurfaceRules.RuleSource)NETHERRACK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.INFERNAL_HOLT}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)stateSelectorNoise, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR), (SurfaceRules.RuleSource)BLACKSTONE))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)netherrackNoise, (SurfaceRules.RuleSource)BLACKSTONE))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)above32), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)hole, (SurfaceRules.RuleSource)LAVA)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BLACKSTONE_BASIN}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)netherrackNoise, (SurfaceRules.RuleSource)BLACKSTONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)above31, (SurfaceRules.RuleSource)COBALT_NYLIUM)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.GLISTERING_MEADOW}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.NETHERRACK, (double)0.45)), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)above31, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)wartNoise, (SurfaceRules.RuleSource)GLISTERING_WART), GLISTERING_NYLIUM})))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.MYCOTOXIC_UNDERGROWTH}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)netherrackNoise), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)above31, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)wartNoise, (SurfaceRules.RuleSource)NETHERRACK), MYCOTOXIC_NYLIUM})))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.INFERNAL_HOLT}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)netherrackNoise, (SurfaceRules.RuleSource)BLACKSTONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)above31, (SurfaceRules.RuleSource)BRIMSPROUT_NYLIUM)}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.BLACKSTONE_BASIN}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)stateSelectorNoise, (SurfaceRules.RuleSource)BLACKSTONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)BLACKSTONE)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{RuBiomes.REDSTONE_ABYSS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)soulSandLayerNoise, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)hole), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)start30, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)end35, (SurfaceRules.RuleSource)SOUL_SAND))), NETHERRACK}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)above31, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)end35, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)gravelLayerNoise, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)above32, (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)hole), (SurfaceRules.RuleSource)GRAVEL)})))))}))});
    }

    public static SurfaceRules.RuleSource end() {
        return END_STONE;
    }

    public static SurfaceRules.RuleSource air() {
        return AIR;
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double p_194809_) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(p_194809_ / 8.25), (double)Double.MAX_VALUE);
    }

    private static SurfaceRules.ConditionSource shieldNoise(double noise) {
        return SurfaceRules.noiseCondition(RuNoises.SHIELD, (double)(noise / 8.25), (double)Double.MAX_VALUE);
    }
}

