/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored;

import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.regions_unexplored.RegionsUnexplored;
import net.regions_unexplored.RegionsUnexploredNeoClient;
import net.regions_unexplored.client.RegionsUnexploredClient;
import net.regions_unexplored.config.RuCommonConfig;
import net.regions_unexplored.config.RuPrimaryRegionConfig;
import net.regions_unexplored.config.RuSecondaryRegionConfig;
import net.regions_unexplored.platform.NeoForgeRegistar;
import net.regions_unexplored.registry.BiomeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="regions_unexplored")
public class RegionsUnexploredNeo {
    public static final Logger LOGGER = LogManager.getLogger(RegionsUnexploredNeo.class);

    public RegionsUnexploredNeo(ModContainer container) {
        IEventBus bus = container.getEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        this.registerConfig(container);
        RegionsUnexplored.init("Forge Mod Initializer");
        NeoForgeRegistar.CACHE.values().forEach(deferredRegister -> deferredRegister.register(bus));
        RegionsUnexploredNeoClient.regionsUnexploredNeoClient(bus);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        RegionsUnexploredClient.clientInit();
    }

    @SubscribeEvent
    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BiomeRegistry.setupTerrablender();
            RegionsUnexplored.afterRegistriesFreeze();
        });
    }

    private void registerConfig(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RuCommonConfig.SPEC, "regions_unexplored/regions_unexplored-common.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RuPrimaryRegionConfig.SPEC, "regions_unexplored/regions_unexplored-primary-region.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RuSecondaryRegionConfig.SPEC, "regions_unexplored/regions_unexplored-secondary-region.toml");
    }
}

