/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.client.rendering;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.balm.mixin.ModelBakeryAccessor;
import net.blay09.mods.balm.neoforge.client.rendering.NeoForgeCachedDynamicModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.SimpleModelState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.slf4j.Logger;

public class NeoForgeBalmModels
implements BalmModels {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final List<DeferredModel> modelsToBake = Collections.synchronizedList(new ArrayList());
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();
    private ModelBakery modelBakery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBakeModels(ModelBakery modelBakery, ModelBakery.TextureGetter textureGetter) {
        this.modelBakery = modelBakery;
        this.registrations.values().forEach(it -> it.setTextureGetter(textureGetter));
        List<DeferredModel> list = this.modelsToBake;
        synchronized (list) {
            for (DeferredModel deferredModel : this.modelsToBake) {
                deferredModel.resolveAndSet(modelBakery, modelBakery.getBakedTopLevelModels(), textureGetter);
            }
        }
    }

    @Override
    public DeferredObject<BakedModel> loadModel(ResourceLocation identifier) {
        DeferredModel deferredModel = new DeferredModel(this, new ModelResourceLocation(identifier, "standalone")){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ModelResourceLocation, BakedModel> modelRegistry, ModelBakery.TextureGetter textureGetter) {
                return modelRegistry.get(this.getModelResourceLocation());
            }
        };
        this.getActiveRegistrations().additionalModels.add(deferredModel);
        return deferredModel;
    }

    @Override
    public DeferredObject<BakedModel> bakeModel(final ModelResourceLocation identifier, final UnbakedModel model) {
        DeferredModel deferredModel = new DeferredModel(identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ModelResourceLocation, BakedModel> modelRegistry, ModelBakery.TextureGetter textureGetter) {
                ModelBaker baker = NeoForgeBalmModels.this.createBaker(identifier, textureGetter);
                return model.bake(baker, baker.getModelTextureGetter(), NeoForgeBalmModels.this.getModelState(Transformation.identity()));
            }
        };
        this.modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public DeferredObject<BakedModel> retexture(final ModelResourceLocation identifier, final Map<String, String> textureMap) {
        DeferredModel deferredModel = new DeferredModel(identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ModelResourceLocation, BakedModel> modelRegistry, ModelBakery.TextureGetter textureGetter) {
                UnbakedModel model = NeoForgeBalmModels.this.retexture(bakery, identifier, textureMap);
                ModelBaker baker = NeoForgeBalmModels.this.createBaker(identifier, textureGetter);
                return model.bake(baker, baker.getModelTextureGetter(), NeoForgeBalmModels.this.getModelState(Transformation.identity()));
            }
        };
        this.modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public DeferredObject<BakedModel> loadDynamicModel(final ModelResourceLocation identifier, final Set<ModelResourceLocation> models, @Nullable Function<BlockState, ModelResourceLocation> modelFunction, final @Nullable Function<BlockState, Map<String, String>> textureMapFunction, final @Nullable BiConsumer<BlockState, Matrix4f> transformFunction, final List<RenderType> renderTypes) {
        final Function<BlockState, ModelResourceLocation> effectiveModelFunction = modelFunction != null ? modelFunction : it -> identifier;
        DeferredModel deferredModel = new DeferredModel(this, identifier){

            @Override
            public BakedModel resolve(ModelBakery bakery, Map<ModelResourceLocation, BakedModel> modelRegistry, ModelBakery.TextureGetter textureGetter) {
                HashMap<ModelResourceLocation, UnbakedModel> unbakedModels = new HashMap<ModelResourceLocation, UnbakedModel>();
                for (ModelResourceLocation modelId : models) {
                    unbakedModels.put(modelId, ((ModelBakeryAccessor)bakery).callGetModel(modelId.id()));
                }
                return new NeoForgeCachedDynamicModel(bakery, unbakedModels, effectiveModelFunction, null, textureMapFunction, transformFunction, renderTypes, identifier, textureGetter);
            }
        };
        this.modelsToBake.add(deferredModel);
        return deferredModel;
    }

    @Override
    public void overrideModel(Supplier<Block> block, Supplier<BakedModel> model) {
        this.getActiveRegistrations().overrides.add((Pair<Supplier<Block>, Supplier<BakedModel>>)Pair.of(block, model));
    }

    @Override
    public ModelState getModelState(Transformation transformation) {
        return new SimpleModelState(transformation);
    }

    @Override
    public UnbakedModel getUnbakedModelOrMissing(ResourceLocation location) {
        return ((ModelBakeryAccessor)this.modelBakery).callGetModel(location);
    }

    @Override
    public UnbakedModel getUnbakedMissingModel() {
        return ((ModelBakeryAccessor)this.modelBakery).callGetModel(ModelBakery.MISSING_MODEL_LOCATION);
    }

    public void register(String modId, IEventBus eventBus) {
        eventBus.register((Object)this.getRegistrations(modId));
    }

    private Registrations getActiveRegistrations() {
        return this.getRegistrations(ModLoadingContext.get().getActiveNamespace());
    }

    private Registrations getRegistrations(String modId) {
        return this.registrations.computeIfAbsent(modId, it -> new Registrations());
    }

    @Override
    public ModelBaker createBaker(ModelResourceLocation location, ModelBakery.TextureGetter textureGetter) {
        try {
            Class<?> clazz = Class.forName("net.minecraft.client.resources.model.ModelBakery$ModelBakerImpl");
            Constructor<?> constructor = clazz.getDeclaredConstructor(ModelBakery.class, ModelBakery.TextureGetter.class, ModelResourceLocation.class);
            constructor.setAccessible(true);
            return (ModelBaker)constructor.newInstance(this.modelBakery, textureGetter, location);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Balm failed to create model baker", e);
        }
    }

    private static abstract class DeferredModel
    extends DeferredObject<BakedModel> {
        private final ModelResourceLocation modelResourceLocation;

        public DeferredModel(ModelResourceLocation modelResourceLocation) {
            super(modelResourceLocation.id());
            this.modelResourceLocation = modelResourceLocation;
        }

        public void resolveAndSet(ModelBakery modelBakery, Map<ModelResourceLocation, BakedModel> modelRegistry, ModelBakery.TextureGetter textureGetter) {
            try {
                this.set(this.resolve(modelBakery, modelRegistry, textureGetter));
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to bake model: '{}':", (Object)this.getIdentifier(), (Object)exception);
                this.set((BakedModel)modelBakery.getBakedTopLevelModels().get(ModelBakery.MISSING_MODEL_LOCATION));
            }
        }

        public abstract BakedModel resolve(ModelBakery var1, Map<ModelResourceLocation, BakedModel> var2, ModelBakery.TextureGetter var3);

        public ModelResourceLocation getModelResourceLocation() {
            return this.modelResourceLocation;
        }
    }

    private static class Registrations {
        public final List<DeferredModel> additionalModels = new ArrayList<DeferredModel>();
        public final List<Pair<Supplier<Block>, Supplier<BakedModel>>> overrides = new ArrayList<Pair<Supplier<Block>, Supplier<BakedModel>>>();
        private ModelBakery.TextureGetter textureGetter;

        private Registrations() {
        }

        public void setTextureGetter(ModelBakery.TextureGetter textureGetter) {
            this.textureGetter = textureGetter;
        }

        @SubscribeEvent
        public void onRegisterAdditionalModels(ModelEvent.RegisterAdditional event) {
            this.additionalModels.forEach(it -> event.register(it.getModelResourceLocation()));
        }

        @SubscribeEvent
        public void onModelBakingCompleted(ModelEvent.ModifyBakingResult event) {
            for (Pair<Supplier<Block>, Supplier<BakedModel>> override : this.overrides) {
                Block block = (Block)((Supplier)override.getFirst()).get();
                BakedModel bakedModel = (BakedModel)((Supplier)override.getSecond()).get();
                block.getStateDefinition().getPossibleStates().forEach(state -> {
                    ModelResourceLocation modelLocation = BlockModelShaper.stateToModelLocation((BlockState)state);
                    event.getModels().put(modelLocation, bakedModel);
                });
            }
        }

        @SubscribeEvent
        public void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
            for (DeferredModel deferredModel : this.additionalModels) {
                deferredModel.resolveAndSet(event.getModelBakery(), event.getModels(), this.textureGetter);
            }
            this.textureGetter = null;
        }
    }
}

