/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.BalmHooks;
import net.blay09.mods.balm.api.BalmProxy;
import net.blay09.mods.balm.api.BalmRegistries;
import net.blay09.mods.balm.api.BalmRuntime;
import net.blay09.mods.balm.api.block.BalmBlockEntities;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.command.BalmCommands;
import net.blay09.mods.balm.api.compat.BalmModSupport;
import net.blay09.mods.balm.api.component.BalmComponents;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BalmEvents;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.loot.BalmLootTables;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.balm.api.network.BalmNetworking;
import net.blay09.mods.balm.api.particle.BalmParticles;
import net.blay09.mods.balm.api.permission.BalmPermissions;
import net.blay09.mods.balm.api.provider.BalmProviders;
import net.blay09.mods.balm.api.proxy.ModProxy;
import net.blay09.mods.balm.api.proxy.PlatformProxy;
import net.blay09.mods.balm.api.proxy.ProxyResolutionException;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.balm.api.recipe.BalmRecipes;
import net.blay09.mods.balm.api.resources.BalmResources;
import net.blay09.mods.balm.api.sound.BalmSounds;
import net.blay09.mods.balm.api.stats.BalmStats;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.common.CommonBalmLootTables;
import net.blay09.mods.balm.common.proxy.ModProxyImpl;
import net.blay09.mods.balm.common.proxy.PlatformProxyImpl;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.blay09.mods.balm.neoforge.NeoForgeBalmHooks;
import net.blay09.mods.balm.neoforge.NeoForgeBalmRegistries;
import net.blay09.mods.balm.neoforge.NeoForgeLoadContext;
import net.blay09.mods.balm.neoforge.block.NeoForgeBalmBlocks;
import net.blay09.mods.balm.neoforge.block.entity.NeoForgeBalmBlockEntities;
import net.blay09.mods.balm.neoforge.command.NeoForgeBalmCommands;
import net.blay09.mods.balm.neoforge.compat.NeoForgeBalmModSupport;
import net.blay09.mods.balm.neoforge.component.NeoForgeBalmComponents;
import net.blay09.mods.balm.neoforge.config.NeoForgeBalmConfig;
import net.blay09.mods.balm.neoforge.entity.NeoForgeBalmEntities;
import net.blay09.mods.balm.neoforge.event.NeoForgeBalmCommonEvents;
import net.blay09.mods.balm.neoforge.event.NeoForgeBalmEvents;
import net.blay09.mods.balm.neoforge.item.NeoForgeBalmItems;
import net.blay09.mods.balm.neoforge.menu.NeoForgeBalmMenus;
import net.blay09.mods.balm.neoforge.network.NeoForgeBalmNetworking;
import net.blay09.mods.balm.neoforge.particle.NeoForgeBalmParticles;
import net.blay09.mods.balm.neoforge.permission.NeoForgeBalmPermissions;
import net.blay09.mods.balm.neoforge.provider.NeoForgeBalmProviders;
import net.blay09.mods.balm.neoforge.recipe.NeoForgeBalmRecipes;
import net.blay09.mods.balm.neoforge.resources.NeoForgeBalmResources;
import net.blay09.mods.balm.neoforge.sound.NeoForgeBalmSounds;
import net.blay09.mods.balm.neoforge.stats.NeoForgeBalmStats;
import net.blay09.mods.balm.neoforge.world.NeoForgeBalmWorldGen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;

public class NeoForgeBalmRuntime
implements BalmRuntime<NeoForgeLoadContext> {
    private static final List<Runnable> initCallbacks = Collections.synchronizedList(new ArrayList());
    private final BalmWorldGen worldGen = new NeoForgeBalmWorldGen();
    private final BalmBlocks blocks = new NeoForgeBalmBlocks();
    private final BalmBlockEntities blockEntities = new NeoForgeBalmBlockEntities();
    private final NeoForgeBalmEvents events = new NeoForgeBalmEvents();
    private final BalmItems items = new NeoForgeBalmItems();
    private final BalmMenus menus = new NeoForgeBalmMenus();
    private final BalmNetworking networking = new NeoForgeBalmNetworking();
    private final BalmConfig config = new NeoForgeBalmConfig();
    private final BalmHooks hooks = new NeoForgeBalmHooks();
    private final BalmRegistries registries = new NeoForgeBalmRegistries();
    private final BalmSounds sounds = new NeoForgeBalmSounds();
    private final BalmEntities entities = new NeoForgeBalmEntities();
    private final BalmProviders providers = new NeoForgeBalmProviders();
    private final BalmCommands commands = new NeoForgeBalmCommands();
    private final BalmLootTables lootTables = new CommonBalmLootTables();
    private final BalmStats stats = new NeoForgeBalmStats();
    private final BalmRecipes recipes = new NeoForgeBalmRecipes();
    private final BalmComponents components = new NeoForgeBalmComponents();
    private final BalmModSupport modSupport = new NeoForgeBalmModSupport(this);
    private final BalmParticles particles = new NeoForgeBalmParticles();
    private final BalmPermissions permissions = new NeoForgeBalmPermissions();
    private final BalmResources resources = new NeoForgeBalmResources();
    private final SidedProxy<BalmProxy> proxy = this.sidedProxy("net.blay09.mods.balm.api.BalmProxy", "net.blay09.mods.balm.api.client.BalmClientProxy");
    private final List<String> addonClasses = new ArrayList<String>();
    private boolean ready;

    public NeoForgeBalmRuntime() {
        NeoForgeBalmCommonEvents.registerEvents(this.events);
    }

    @Override
    public BalmProxy getProxy() {
        return this.proxy.get();
    }

    @Override
    public BalmConfig getConfig() {
        return this.config;
    }

    @Override
    public BalmEvents getEvents() {
        return this.events;
    }

    @Override
    public BalmWorldGen getWorldGen() {
        return this.worldGen;
    }

    @Override
    public BalmBlocks getBlocks() {
        return this.blocks;
    }

    @Override
    public BalmBlockEntities getBlockEntities() {
        return this.blockEntities;
    }

    @Override
    public BalmItems getItems() {
        return this.items;
    }

    @Override
    public BalmMenus getMenus() {
        return this.menus;
    }

    @Override
    public BalmNetworking getNetworking() {
        return this.networking;
    }

    @Override
    public BalmHooks getHooks() {
        return this.hooks;
    }

    @Override
    public BalmRegistries getRegistries() {
        return this.registries;
    }

    @Override
    public BalmSounds getSounds() {
        return this.sounds;
    }

    @Override
    public BalmEntities getEntities() {
        return this.entities;
    }

    @Override
    public BalmProviders getProviders() {
        return this.providers;
    }

    @Override
    public BalmCommands getCommands() {
        return this.commands;
    }

    @Override
    public BalmLootTables getLootTables() {
        return this.lootTables;
    }

    @Override
    public BalmStats getStats() {
        return this.stats;
    }

    @Override
    public BalmRecipes getRecipes() {
        return this.recipes;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(it -> it.getModInfo().getDisplayName()).orElse(modId);
    }

    @Override
    public void initialize(String modId, NeoForgeLoadContext context, Runnable initializer) {
        ((NeoForgeBalmNetworking)this.networking).register(modId, context.modBus());
        ((NeoForgeBalmEntities)this.entities).register(modId, context.modBus());
        ((NeoForgeBalmStats)this.stats).register(modId, context.modBus());
        initializer.run();
        IEventBus modBus = context.modBus();
        modBus.addListener(event -> this.initializeAddons());
        DeferredRegisters.register(modId, modBus);
    }

    @Override
    public void initializeIfLoaded(String modId, String className) {
        if (this.isModLoaded(modId)) {
            this.addonClasses.add(className);
        }
    }

    @Override
    public <T> SidedProxy<T> sidedProxy(String commonName, String clientName) {
        SidedProxy proxy = new SidedProxy(commonName, clientName);
        try {
            if (FMLEnvironment.dist.isClient()) {
                proxy.resolveClient();
            } else {
                proxy.resolveCommon();
            }
        }
        catch (ProxyResolutionException e) {
            throw new RuntimeException(e);
        }
        return proxy;
    }

    private void initializeAddons() {
        for (String addonClass : this.addonClasses) {
            try {
                Class.forName(addonClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addServerReloadListener(ResourceLocation identifier, PreparableReloadListener reloadListener) {
        NeoForge.EVENT_BUS.addListener(event -> event.addListener(reloadListener));
    }

    @Override
    public void addServerReloadListener(ResourceLocation identifier, Consumer<ResourceManager> reloadListener) {
        NeoForge.EVENT_BUS.addListener(event -> event.addListener((PreparableReloadListener)((ResourceManagerReloadListener)reloadListener::accept)));
    }

    @Override
    public BalmComponents getComponents() {
        return this.components;
    }

    @Override
    public BalmModSupport getModSupport() {
        return this.modSupport;
    }

    @Override
    public BalmParticles getParticles() {
        return this.particles;
    }

    @Override
    public BalmPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public <T> PlatformProxy<T> platformProxy() {
        return new PlatformProxyImpl("neoforge");
    }

    @Override
    public <T> ModProxy<T> modProxy() {
        return new ModProxyImpl(this::isModLoaded);
    }

    @Override
    public String getPlatform() {
        return "neoforge";
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void onRuntimeAvailable(Runnable callback) {
        initCallbacks.add(callback);
        if (this.isReady()) {
            callback.run();
        }
    }

    public void initializeRuntime() {
        this.ready = true;
        for (Runnable callback : initCallbacks) {
            callback.run();
        }
    }

    @Override
    public BalmResources getResources() {
        return this.resources;
    }
}

