/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> UNLIMITED_CODEC = ListOperation.codec(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> codec(int p_336009_) {
        return Type.CODEC.dispatchMap("mode", ListOperation::mode, p_338141_ -> p_338141_.mapCodec).validate(p_335630_ -> {
            int $$3;
            ReplaceSection $$2;
            if (p_335630_ instanceof ReplaceSection && ($$2 = (ReplaceSection)p_335630_).size().isPresent() && ($$3 = $$2.size().get().intValue()) > p_336009_) {
                return DataResult.error(() -> "Size value too large: " + $$3 + ", max size is " + p_336009_);
            }
            return DataResult.success((Object)p_335630_);
        });
    }

    public Type mode();

    default public <T> List<T> apply(List<T> p_341145_, List<T> p_341340_) {
        return this.apply(p_341145_, p_341340_, Integer.MAX_VALUE);
    }

    public <T> List<T> apply(List<T> var1, List<T> var2, int var3);

    public static enum Type implements StringRepresentable
    {
        REPLACE_ALL("replace_all", ReplaceAll.MAP_CODEC),
        REPLACE_SECTION("replace_section", ReplaceSection.MAP_CODEC),
        INSERT("insert", Insert.MAP_CODEC),
        APPEND("append", Append.MAP_CODEC);

        public static final Codec<Type> CODEC;
        private final String id;
        final MapCodec<? extends ListOperation> mapCodec;

        private Type(String p_333913_, MapCodec<? extends ListOperation> p_333972_) {
            this.id = p_333913_;
            this.mapCodec = p_333972_;
        }

        public MapCodec<? extends ListOperation> mapCodec() {
            return this.mapCodec;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record ReplaceSection(int offset, Optional<Integer> size) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<ReplaceSection> MAP_CODEC = RecordCodecBuilder.mapCodec(p_338143_ -> p_338143_.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(ReplaceSection::offset), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("size").forGetter(ReplaceSection::size)).apply((Applicative)p_338143_, ReplaceSection::new));

        public ReplaceSection(int p_333961_) {
            this(p_333961_, Optional.empty());
        }

        @Override
        public Type mode() {
            return Type.REPLACE_SECTION;
        }

        @Override
        public <T> List<T> apply(List<T> p_333868_, List<T> p_334045_, int p_334033_) {
            ImmutableList $$6;
            int $$3 = p_333868_.size();
            if (this.offset > $$3) {
                LOGGER.error("Cannot replace when offset is out of bounds");
                return p_333868_;
            }
            ImmutableList.Builder $$4 = ImmutableList.builder();
            $$4.addAll(p_333868_.subList(0, this.offset));
            $$4.addAll(p_334045_);
            int $$5 = this.offset + this.size.orElse(p_334045_.size());
            if ($$5 < $$3) {
                $$4.addAll(p_333868_.subList($$5, $$3));
            }
            if (($$6 = $$4.build()).size() > p_334033_) {
                LOGGER.error("Contents overflow in section replacement");
                return p_333868_;
            }
            return $$6;
        }
    }

    public record StandAlone<T>(List<T> value, ListOperation operation) {
        public static <T> Codec<StandAlone<T>> codec(Codec<T> p_341683_, int p_341655_) {
            return RecordCodecBuilder.create(p_341682_ -> p_341682_.group((App)p_341683_.sizeLimitedListOf(p_341655_).fieldOf("values").forGetter(p_341601_ -> p_341601_.value), (App)ListOperation.codec(p_341655_).forGetter(p_341647_ -> p_341647_.operation)).apply((Applicative)p_341682_, StandAlone::new));
        }

        public List<T> apply(List<T> p_341623_) {
            return this.operation.apply(p_341623_, this.value);
        }
    }

    public static class Append
    implements ListOperation {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final Append INSTANCE = new Append();
        public static final MapCodec<Append> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private Append() {
        }

        @Override
        public Type mode() {
            return Type.APPEND;
        }

        @Override
        public <T> List<T> apply(List<T> p_333898_, List<T> p_333849_, int p_333915_) {
            if (p_333898_.size() + p_333849_.size() > p_333915_) {
                LOGGER.error("Contents overflow in section append");
                return p_333898_;
            }
            return Stream.concat(p_333898_.stream(), p_333849_.stream()).toList();
        }
    }

    public record Insert(int offset) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<Insert> MAP_CODEC = RecordCodecBuilder.mapCodec(p_338142_ -> p_338142_.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(Insert::offset)).apply((Applicative)p_338142_, Insert::new));

        @Override
        public Type mode() {
            return Type.INSERT;
        }

        @Override
        public <T> List<T> apply(List<T> p_333952_, List<T> p_333782_, int p_333792_) {
            int $$3 = p_333952_.size();
            if (this.offset > $$3) {
                LOGGER.error("Cannot insert when offset is out of bounds");
                return p_333952_;
            }
            if ($$3 + p_333782_.size() > p_333792_) {
                LOGGER.error("Contents overflow in section insertion");
                return p_333952_;
            }
            ImmutableList.Builder $$4 = ImmutableList.builder();
            $$4.addAll(p_333952_.subList(0, this.offset));
            $$4.addAll(p_333782_);
            $$4.addAll(p_333952_.subList(this.offset, $$3));
            return $$4.build();
        }
    }

    public static class ReplaceAll
    implements ListOperation {
        public static final ReplaceAll INSTANCE = new ReplaceAll();
        public static final MapCodec<ReplaceAll> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private ReplaceAll() {
        }

        @Override
        public Type mode() {
            return Type.REPLACE_ALL;
        }

        @Override
        public <T> List<T> apply(List<T> p_333855_, List<T> p_333756_, int p_333945_) {
            return p_333756_;
        }
    }
}

