/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<WallBlock> CODEC = WallBlock.simpleCodec(WallBlock::new);
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.WEST_WALL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final int WALL_WIDTH = 3;
    private static final int WALL_HEIGHT = 14;
    private static final int POST_WIDTH = 4;
    private static final int POST_COVER_WIDTH = 1;
    private static final int WALL_COVER_START = 7;
    private static final int WALL_COVER_END = 9;
    private static final VoxelShape POST_TEST = Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 9.0);
    private static final VoxelShape NORTH_TEST = Block.box(7.0, 0.0, 0.0, 9.0, 16.0, 9.0);
    private static final VoxelShape SOUTH_TEST = Block.box(7.0, 0.0, 7.0, 9.0, 16.0, 16.0);
    private static final VoxelShape WEST_TEST = Block.box(0.0, 0.0, 7.0, 9.0, 16.0, 9.0);
    private static final VoxelShape EAST_TEST = Block.box(7.0, 0.0, 7.0, 16.0, 16.0, 9.0);

    public MapCodec<WallBlock> codec() {
        return CODEC;
    }

    public WallBlock(BlockBehaviour.Properties p_57964_) {
        super(p_57964_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, true)).setValue(NORTH_WALL, WallSide.NONE)).setValue(EAST_WALL, WallSide.NONE)).setValue(SOUTH_WALL, WallSide.NONE)).setValue(WEST_WALL, WallSide.NONE)).setValue(WATERLOGGED, false));
        this.shapeByIndex = this.makeShapes(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape p_58034_, WallSide p_58035_, VoxelShape p_58036_, VoxelShape p_58037_) {
        if (p_58035_ == WallSide.TALL) {
            return Shapes.or(p_58034_, p_58037_);
        }
        if (p_58035_ == WallSide.LOW) {
            return Shapes.or(p_58034_, p_58036_);
        }
        return p_58034_;
    }

    private Map<BlockState, VoxelShape> makeShapes(float p_57966_, float p_57967_, float p_57968_, float p_57969_, float p_57970_, float p_57971_) {
        float $$6 = 8.0f - p_57966_;
        float $$7 = 8.0f + p_57966_;
        float $$8 = 8.0f - p_57967_;
        float $$9 = 8.0f + p_57967_;
        VoxelShape $$10 = Block.box($$6, 0.0, $$6, $$7, p_57968_, $$7);
        VoxelShape $$11 = Block.box($$8, p_57969_, 0.0, $$9, p_57970_, $$9);
        VoxelShape $$12 = Block.box($$8, p_57969_, $$8, $$9, p_57970_, 16.0);
        VoxelShape $$13 = Block.box(0.0, p_57969_, $$8, $$9, p_57970_, $$9);
        VoxelShape $$14 = Block.box($$8, p_57969_, $$8, 16.0, p_57970_, $$9);
        VoxelShape $$15 = Block.box($$8, p_57969_, 0.0, $$9, p_57971_, $$9);
        VoxelShape $$16 = Block.box($$8, p_57969_, $$8, $$9, p_57971_, 16.0);
        VoxelShape $$17 = Block.box(0.0, p_57969_, $$8, $$9, p_57971_, $$9);
        VoxelShape $$18 = Block.box($$8, p_57969_, $$8, 16.0, p_57971_, $$9);
        ImmutableMap.Builder $$19 = ImmutableMap.builder();
        for (Boolean $$20 : UP.getPossibleValues()) {
            for (WallSide $$21 : EAST_WALL.getPossibleValues()) {
                for (WallSide $$22 : NORTH_WALL.getPossibleValues()) {
                    for (WallSide $$23 : WEST_WALL.getPossibleValues()) {
                        for (WallSide $$24 : SOUTH_WALL.getPossibleValues()) {
                            VoxelShape $$25 = Shapes.empty();
                            $$25 = WallBlock.applyWallShape($$25, $$21, $$14, $$18);
                            $$25 = WallBlock.applyWallShape($$25, $$23, $$13, $$17);
                            $$25 = WallBlock.applyWallShape($$25, $$22, $$11, $$15);
                            $$25 = WallBlock.applyWallShape($$25, $$24, $$12, $$16);
                            if ($$20.booleanValue()) {
                                $$25 = Shapes.or($$25, $$10);
                            }
                            BlockState $$26 = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(UP, $$20)).setValue(EAST_WALL, $$21)).setValue(WEST_WALL, $$23)).setValue(NORTH_WALL, $$22)).setValue(SOUTH_WALL, $$24);
                            $$19.put((Object)((BlockState)$$26.setValue(WATERLOGGED, false)), (Object)$$25);
                            $$19.put((Object)((BlockState)$$26.setValue(WATERLOGGED, true)), (Object)$$25);
                        }
                    }
                }
            }
        }
        return $$19.build();
    }

    @Override
    protected VoxelShape getShape(BlockState p_58050_, BlockGetter p_58051_, BlockPos p_58052_, CollisionContext p_58053_) {
        return this.shapeByIndex.get(p_58050_);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState p_58055_, BlockGetter p_58056_, BlockPos p_58057_, CollisionContext p_58058_) {
        return this.collisionShapeByIndex.get(p_58055_);
    }

    @Override
    protected boolean isPathfindable(BlockState p_57996_, PathComputationType p_57999_) {
        return false;
    }

    private boolean connectsTo(BlockState p_58021_, boolean p_58022_, Direction p_58023_) {
        Block $$3 = p_58021_.getBlock();
        boolean $$4 = $$3 instanceof FenceGateBlock && FenceGateBlock.connectsToDirection(p_58021_, p_58023_);
        return p_58021_.is(BlockTags.WALLS) || !WallBlock.isExceptionForConnection(p_58021_) && p_58022_ || $$3 instanceof IronBarsBlock || $$4;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_57973_) {
        Level $$1 = p_57973_.getLevel();
        BlockPos $$2 = p_57973_.getClickedPos();
        FluidState $$3 = p_57973_.getLevel().getFluidState(p_57973_.getClickedPos());
        BlockPos $$4 = $$2.north();
        BlockPos $$5 = $$2.east();
        BlockPos $$6 = $$2.south();
        BlockPos $$7 = $$2.west();
        BlockPos $$8 = $$2.above();
        BlockState $$9 = $$1.getBlockState($$4);
        BlockState $$10 = $$1.getBlockState($$5);
        BlockState $$11 = $$1.getBlockState($$6);
        BlockState $$12 = $$1.getBlockState($$7);
        BlockState $$13 = $$1.getBlockState($$8);
        boolean $$14 = this.connectsTo($$9, $$9.isFaceSturdy($$1, $$4, Direction.SOUTH), Direction.SOUTH);
        boolean $$15 = this.connectsTo($$10, $$10.isFaceSturdy($$1, $$5, Direction.WEST), Direction.WEST);
        boolean $$16 = this.connectsTo($$11, $$11.isFaceSturdy($$1, $$6, Direction.NORTH), Direction.NORTH);
        boolean $$17 = this.connectsTo($$12, $$12.isFaceSturdy($$1, $$7, Direction.EAST), Direction.EAST);
        BlockState $$18 = (BlockState)this.defaultBlockState().setValue(WATERLOGGED, $$3.getType() == Fluids.WATER);
        return this.updateShape($$1, $$18, $$8, $$13, $$14, $$15, $$16, $$17);
    }

    @Override
    protected BlockState updateShape(BlockState p_58014_, Direction p_58015_, BlockState p_58016_, LevelAccessor p_58017_, BlockPos p_58018_, BlockPos p_58019_) {
        if (p_58014_.getValue(WATERLOGGED).booleanValue()) {
            p_58017_.scheduleTick(p_58018_, Fluids.WATER, Fluids.WATER.getTickDelay(p_58017_));
        }
        if (p_58015_ == Direction.DOWN) {
            return super.updateShape(p_58014_, p_58015_, p_58016_, p_58017_, p_58018_, p_58019_);
        }
        if (p_58015_ == Direction.UP) {
            return this.topUpdate(p_58017_, p_58014_, p_58019_, p_58016_);
        }
        return this.sideUpdate(p_58017_, p_58018_, p_58014_, p_58019_, p_58016_, p_58015_);
    }

    private static boolean isConnected(BlockState p_58011_, Property<WallSide> p_58012_) {
        return p_58011_.getValue(p_58012_) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape p_58039_, VoxelShape p_58040_) {
        return !Shapes.joinIsNotEmpty(p_58040_, p_58039_, BooleanOp.ONLY_FIRST);
    }

    private BlockState topUpdate(LevelReader p_57975_, BlockState p_57976_, BlockPos p_57977_, BlockState p_57978_) {
        boolean $$4 = WallBlock.isConnected(p_57976_, NORTH_WALL);
        boolean $$5 = WallBlock.isConnected(p_57976_, EAST_WALL);
        boolean $$6 = WallBlock.isConnected(p_57976_, SOUTH_WALL);
        boolean $$7 = WallBlock.isConnected(p_57976_, WEST_WALL);
        return this.updateShape(p_57975_, p_57976_, p_57977_, p_57978_, $$4, $$5, $$6, $$7);
    }

    private BlockState sideUpdate(LevelReader p_57989_, BlockPos p_57990_, BlockState p_57991_, BlockPos p_57992_, BlockState p_57993_, Direction p_57994_) {
        Direction $$6 = p_57994_.getOpposite();
        boolean $$7 = p_57994_ == Direction.NORTH ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, NORTH_WALL);
        boolean $$8 = p_57994_ == Direction.EAST ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, EAST_WALL);
        boolean $$9 = p_57994_ == Direction.SOUTH ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, SOUTH_WALL);
        boolean $$10 = p_57994_ == Direction.WEST ? this.connectsTo(p_57993_, p_57993_.isFaceSturdy(p_57989_, p_57992_, $$6), $$6) : WallBlock.isConnected(p_57991_, WEST_WALL);
        BlockPos $$11 = p_57990_.above();
        BlockState $$12 = p_57989_.getBlockState($$11);
        return this.updateShape(p_57989_, p_57991_, $$11, $$12, $$7, $$8, $$9, $$10);
    }

    private BlockState updateShape(LevelReader p_57980_, BlockState p_57981_, BlockPos p_57982_, BlockState p_57983_, boolean p_57984_, boolean p_57985_, boolean p_57986_, boolean p_57987_) {
        VoxelShape $$8 = p_57983_.getCollisionShape(p_57980_, p_57982_).getFaceShape(Direction.DOWN);
        BlockState $$9 = this.updateSides(p_57981_, p_57984_, p_57985_, p_57986_, p_57987_, $$8);
        return (BlockState)$$9.setValue(UP, this.shouldRaisePost($$9, p_57983_, $$8));
    }

    private boolean shouldRaisePost(BlockState p_58007_, BlockState p_58008_, VoxelShape p_58009_) {
        boolean $$13;
        boolean $$12;
        boolean $$3;
        boolean bl = $$3 = p_58008_.getBlock() instanceof WallBlock && p_58008_.getValue(UP) != false;
        if ($$3) {
            return true;
        }
        WallSide $$4 = p_58007_.getValue(NORTH_WALL);
        WallSide $$5 = p_58007_.getValue(SOUTH_WALL);
        WallSide $$6 = p_58007_.getValue(EAST_WALL);
        WallSide $$7 = p_58007_.getValue(WEST_WALL);
        boolean $$8 = $$5 == WallSide.NONE;
        boolean $$9 = $$7 == WallSide.NONE;
        boolean $$10 = $$6 == WallSide.NONE;
        boolean $$11 = $$4 == WallSide.NONE;
        boolean bl2 = $$12 = $$11 && $$8 && $$9 && $$10 || $$11 != $$8 || $$9 != $$10;
        if ($$12) {
            return true;
        }
        boolean bl3 = $$13 = $$4 == WallSide.TALL && $$5 == WallSide.TALL || $$6 == WallSide.TALL && $$7 == WallSide.TALL;
        if ($$13) {
            return false;
        }
        return p_58008_.is(BlockTags.WALL_POST_OVERRIDE) || WallBlock.isCovered(p_58009_, POST_TEST);
    }

    private BlockState updateSides(BlockState p_58025_, boolean p_58026_, boolean p_58027_, boolean p_58028_, boolean p_58029_, VoxelShape p_58030_) {
        return (BlockState)((BlockState)((BlockState)((BlockState)p_58025_.setValue(NORTH_WALL, this.makeWallState(p_58026_, p_58030_, NORTH_TEST))).setValue(EAST_WALL, this.makeWallState(p_58027_, p_58030_, EAST_TEST))).setValue(SOUTH_WALL, this.makeWallState(p_58028_, p_58030_, SOUTH_TEST))).setValue(WEST_WALL, this.makeWallState(p_58029_, p_58030_, WEST_TEST));
    }

    private WallSide makeWallState(boolean p_58042_, VoxelShape p_58043_, VoxelShape p_58044_) {
        if (p_58042_) {
            if (WallBlock.isCovered(p_58043_, p_58044_)) {
                return WallSide.TALL;
            }
            return WallSide.LOW;
        }
        return WallSide.NONE;
    }

    @Override
    protected FluidState getFluidState(BlockState p_58060_) {
        if (p_58060_.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(p_58060_);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState p_58046_, BlockGetter p_58047_, BlockPos p_58048_) {
        return p_58046_.getValue(WATERLOGGED) == false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58032_) {
        p_58032_.add(UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED);
    }

    @Override
    protected BlockState rotate(BlockState p_58004_, Rotation p_58005_) {
        switch (p_58005_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_58004_.setValue(NORTH_WALL, p_58004_.getValue(SOUTH_WALL))).setValue(EAST_WALL, p_58004_.getValue(WEST_WALL))).setValue(SOUTH_WALL, p_58004_.getValue(NORTH_WALL))).setValue(WEST_WALL, p_58004_.getValue(EAST_WALL));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_58004_.setValue(NORTH_WALL, p_58004_.getValue(EAST_WALL))).setValue(EAST_WALL, p_58004_.getValue(SOUTH_WALL))).setValue(SOUTH_WALL, p_58004_.getValue(WEST_WALL))).setValue(WEST_WALL, p_58004_.getValue(NORTH_WALL));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_58004_.setValue(NORTH_WALL, p_58004_.getValue(WEST_WALL))).setValue(EAST_WALL, p_58004_.getValue(NORTH_WALL))).setValue(SOUTH_WALL, p_58004_.getValue(EAST_WALL))).setValue(WEST_WALL, p_58004_.getValue(SOUTH_WALL));
            }
        }
        return p_58004_;
    }

    @Override
    protected BlockState mirror(BlockState p_58001_, Mirror p_58002_) {
        switch (p_58002_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_58001_.setValue(NORTH_WALL, p_58001_.getValue(SOUTH_WALL))).setValue(SOUTH_WALL, p_58001_.getValue(NORTH_WALL));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_58001_.setValue(EAST_WALL, p_58001_.getValue(WEST_WALL))).setValue(WEST_WALL, p_58001_.getValue(EAST_WALL));
            }
        }
        return super.mirror(p_58001_, p_58002_);
    }
}

