/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class ExplosionDamageCalculator {
    public Optional<Float> getBlockExplosionResistance(Explosion p_46099_, BlockGetter p_46100_, BlockPos p_46101_, BlockState p_46102_, FluidState p_46103_) {
        if (p_46102_.isAir() && p_46103_.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(Math.max(p_46102_.getBlock().getExplosionResistance(), p_46103_.getExplosionResistance())));
    }

    public boolean shouldBlockExplode(Explosion p_46094_, BlockGetter p_46095_, BlockPos p_46096_, BlockState p_46097_, float p_46098_) {
        return true;
    }

    public boolean shouldDamageEntity(Explosion p_314652_, Entity p_314454_) {
        return true;
    }

    public float getKnockbackMultiplier(Entity p_340973_) {
        return 1.0f;
    }

    public float getEntityDamageAmount(Explosion p_311793_, Entity p_311929_) {
        float $$2 = p_311793_.radius() * 2.0f;
        Vec3 $$3 = p_311793_.center();
        double $$4 = Math.sqrt(p_311929_.distanceToSqr($$3)) / (double)$$2;
        double $$5 = (1.0 - $$4) * (double)Explosion.getSeenPercent($$3, p_311929_);
        return (float)(($$5 * $$5 + $$5) / 2.0 * 7.0 * (double)$$2 + 1.0);
    }
}

