/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.AllOf;
import net.minecraft.world.item.enchantment.effects.ApplyMobEffect;
import net.minecraft.world.item.enchantment.effects.DamageEntity;
import net.minecraft.world.item.enchantment.effects.DamageItem;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.ExplodeEffect;
import net.minecraft.world.item.enchantment.effects.Ignite;
import net.minecraft.world.item.enchantment.effects.PlaySoundEffect;
import net.minecraft.world.item.enchantment.effects.ReplaceBlock;
import net.minecraft.world.item.enchantment.effects.ReplaceDisk;
import net.minecraft.world.item.enchantment.effects.RunFunction;
import net.minecraft.world.item.enchantment.effects.SetBlockProperties;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.item.enchantment.effects.SummonEntityEffect;
import net.minecraft.world.phys.Vec3;

public interface EnchantmentEntityEffect
extends EnchantmentLocationBasedEffect {
    public static final Codec<EnchantmentEntityEffect> CODEC = BuiltInRegistries.ENCHANTMENT_ENTITY_EFFECT_TYPE.byNameCodec().dispatch(EnchantmentEntityEffect::codec, Function.identity());

    public static MapCodec<? extends EnchantmentEntityEffect> bootstrap(Registry<MapCodec<? extends EnchantmentEntityEffect>> p_345205_) {
        Registry.register(p_345205_, "all_of", AllOf.EntityEffects.CODEC);
        Registry.register(p_345205_, "apply_mob_effect", ApplyMobEffect.CODEC);
        Registry.register(p_345205_, "damage_entity", DamageEntity.CODEC);
        Registry.register(p_345205_, "damage_item", DamageItem.CODEC);
        Registry.register(p_345205_, "explode", ExplodeEffect.CODEC);
        Registry.register(p_345205_, "ignite", Ignite.CODEC);
        Registry.register(p_345205_, "play_sound", PlaySoundEffect.CODEC);
        Registry.register(p_345205_, "replace_block", ReplaceBlock.CODEC);
        Registry.register(p_345205_, "replace_disk", ReplaceDisk.CODEC);
        Registry.register(p_345205_, "run_function", RunFunction.CODEC);
        Registry.register(p_345205_, "set_block_properties", SetBlockProperties.CODEC);
        Registry.register(p_345205_, "spawn_particles", SpawnParticlesEffect.CODEC);
        return Registry.register(p_345205_, "summon_entity", SummonEntityEffect.CODEC);
    }

    public void apply(ServerLevel var1, int var2, EnchantedItemInUse var3, Entity var4, Vec3 var5);

    @Override
    default public void onChangedBlock(ServerLevel p_345419_, int p_345173_, EnchantedItemInUse p_344724_, Entity p_346126_, Vec3 p_345614_, boolean p_346410_) {
        this.apply(p_345419_, p_345173_, p_344724_, p_346126_, p_345614_);
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec();
}

