/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BrushItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;

    public BrushItem(Item.Properties p_272907_) {
        super(p_272907_);
    }

    @Override
    public InteractionResult useOn(UseOnContext p_272607_) {
        Player $$1 = p_272607_.getPlayer();
        if ($$1 != null && this.calculateHitResult($$1).getType() == HitResult.Type.BLOCK) {
            $$1.startUsingItem(p_272607_.getHand());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack p_273490_) {
        return UseAnim.BRUSH;
    }

    @Override
    public int getUseDuration(ItemStack p_272765_, LivingEntity p_344739_) {
        return 200;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUseTick(Level p_273467_, LivingEntity p_273619_, ItemStack p_273316_, int p_273101_) {
        boolean $$10;
        void $$5;
        block10: {
            block9: {
                if (p_273101_ < 0 || !(p_273619_ instanceof Player)) {
                    p_273619_.releaseUsingItem();
                    return;
                }
                Player $$4 = (Player)p_273619_;
                HitResult $$6 = this.calculateHitResult((Player)$$5);
                if (!($$6 instanceof BlockHitResult)) break block9;
                BlockHitResult $$7 = (BlockHitResult)$$6;
                if ($$6.getType() == HitResult.Type.BLOCK) break block10;
            }
            p_273619_.releaseUsingItem();
            return;
        }
        int $$9 = this.getUseDuration(p_273316_, p_273619_) - p_273101_ + 1;
        boolean bl = $$10 = $$9 % 10 == 5;
        if ($$10) {
            BrushableBlockEntity $$17;
            boolean $$18;
            SoundEvent $$16;
            Object object;
            HumanoidArm $$13;
            void $$8;
            BlockPos $$11 = $$8.getBlockPos();
            BlockState $$12 = p_273467_.getBlockState($$11);
            HumanoidArm humanoidArm = $$13 = p_273619_.getUsedItemHand() == InteractionHand.MAIN_HAND ? $$5.getMainArm() : $$5.getMainArm().getOpposite();
            if ($$12.shouldSpawnTerrainParticles() && $$12.getRenderShape() != RenderShape.INVISIBLE) {
                this.spawnDustParticles(p_273467_, (BlockHitResult)$$8, $$12, p_273619_.getViewVector(0.0f), $$13);
            }
            if ((object = $$12.getBlock()) instanceof BrushableBlock) {
                BrushableBlock $$14 = (BrushableBlock)object;
                SoundEvent $$15 = $$14.getBrushSound();
            } else {
                $$16 = SoundEvents.BRUSH_GENERIC;
            }
            p_273467_.playSound((Player)$$5, $$11, $$16, SoundSource.BLOCKS);
            if (!p_273467_.isClientSide() && (object = p_273467_.getBlockEntity($$11)) instanceof BrushableBlockEntity && ($$18 = ($$17 = (BrushableBlockEntity)object).brush(p_273467_.getGameTime(), (Player)$$5, $$8.getDirection()))) {
                EquipmentSlot $$19 = p_273316_.equals($$5.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                p_273316_.hurtAndBreak(1, p_273619_, $$19);
            }
        }
    }

    private HitResult calculateHitResult(Player p_305856_) {
        return ProjectileUtil.getHitResultOnViewVector(p_305856_, p_281111_ -> !p_281111_.isSpectator() && p_281111_.isPickable(), p_305856_.blockInteractionRange());
    }

    private void spawnDustParticles(Level p_278327_, BlockHitResult p_278272_, BlockState p_278235_, Vec3 p_278337_, HumanoidArm p_285071_) {
        double $$5 = 3.0;
        int $$6 = p_285071_ == HumanoidArm.RIGHT ? 1 : -1;
        int $$7 = p_278327_.getRandom().nextInt(7, 12);
        BlockParticleOption $$8 = new BlockParticleOption(ParticleTypes.BLOCK, p_278235_);
        Direction $$9 = p_278272_.getDirection();
        DustParticlesDelta $$10 = DustParticlesDelta.fromDirection(p_278337_, $$9);
        Vec3 $$11 = p_278272_.getLocation();
        for (int $$12 = 0; $$12 < $$7; ++$$12) {
            p_278327_.addParticle($$8, $$11.x - (double)($$9 == Direction.WEST ? 1.0E-6f : 0.0f), $$11.y, $$11.z - (double)($$9 == Direction.NORTH ? 1.0E-6f : 0.0f), $$10.xd() * (double)$$6 * 3.0 * p_278327_.getRandom().nextDouble(), 0.0, $$10.zd() * (double)$$6 * 3.0 * p_278327_.getRandom().nextDouble());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 p_273421_, Direction p_272987_) {
            double $$2 = 0.0;
            return switch (p_272987_) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(p_273421_.z(), 0.0, -p_273421_.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
            };
        }
    }
}

