/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WitherSkull
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.defineId(WitherSkull.class, EntityDataSerializers.BOOLEAN);

    public WitherSkull(EntityType<? extends WitherSkull> p_37598_, Level p_37599_) {
        super((EntityType<? extends AbstractHurtingProjectile>)p_37598_, p_37599_);
    }

    public WitherSkull(Level p_37609_, LivingEntity p_37610_, Vec3 p_347464_) {
        super(EntityType.WITHER_SKULL, p_37610_, p_347464_, p_37609_);
    }

    @Override
    protected float getInertia() {
        return this.isDangerous() ? 0.73f : super.getInertia();
    }

    @Override
    public boolean isOnFire() {
        return false;
    }

    @Override
    public float getBlockExplosionResistance(Explosion p_37619_, BlockGetter p_37620_, BlockPos p_37621_, BlockState p_37622_, FluidState p_37623_, float p_37624_) {
        if (this.isDangerous() && WitherBoss.canDestroy(p_37622_)) {
            return Math.min(0.8f, p_37624_);
        }
        return p_37624_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onHitEntity(EntityHitResult p_37626_) {
        boolean $$8;
        super.onHitEntity(p_37626_);
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$1 = (ServerLevel)level;
        Entity $$3 = p_37626_.getEntity();
        Entity $$4 = this.getOwner();
        if ($$4 instanceof LivingEntity) {
            LivingEntity $$5 = (LivingEntity)$$4;
            DamageSource $$6 = this.damageSources().witherSkull(this, $$5);
            boolean $$7 = $$3.hurt($$6, 8.0f);
            if ($$7) {
                if ($$3.isAlive()) {
                    void $$2;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)$$2, $$3, $$6);
                } else {
                    $$5.heal(5.0f);
                }
            }
        } else {
            $$8 = $$3.hurt(this.damageSources().magic(), 5.0f);
        }
        if ($$8 && $$3 instanceof LivingEntity) {
            LivingEntity $$9 = (LivingEntity)$$3;
            int $$10 = 0;
            if (this.level().getDifficulty() == Difficulty.NORMAL) {
                $$10 = 10;
            } else if (this.level().getDifficulty() == Difficulty.HARD) {
                $$10 = 40;
            }
            if ($$10 > 0) {
                $$9.addEffect(new MobEffectInstance(MobEffects.WITHER, 20 * $$10, 1), this.getEffectSource());
            }
        }
    }

    @Override
    protected void onHit(HitResult p_37628_) {
        super.onHit(p_37628_);
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, false, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    @Override
    public boolean hurt(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325939_) {
        p_325939_.define(DATA_DANGEROUS, false);
    }

    public boolean isDangerous() {
        return this.entityData.get(DATA_DANGEROUS);
    }

    public void setDangerous(boolean p_37630_) {
        this.entityData.set(DATA_DANGEROUS, p_37630_);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_306205_) {
        super.addAdditionalSaveData(p_306205_);
        p_306205_.putBoolean("dangerous", this.isDangerous());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_305818_) {
        super.readAdditionalSaveData(p_305818_);
        this.setDangerous(p_305818_.getBoolean("dangerous"));
    }
}

