/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public abstract class Entity
implements SyncedDataHolder,
Nameable,
EntityAccess,
CommandSource,
ScoreHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ID_TAG = "id";
    public static final String PASSENGERS_TAG = "Passengers";
    private static final AtomicInteger ENTITY_COUNTER = new AtomicInteger();
    public static final int CONTENTS_SLOT_INDEX = 0;
    public static final int BOARDING_COOLDOWN = 60;
    public static final int TOTAL_AIR_SUPPLY = 300;
    public static final int MAX_ENTITY_TAG_COUNT = 1024;
    public static final float DELTA_AFFECTED_BY_BLOCKS_BELOW_0_2 = 0.2f;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_0_5 = 0.500001;
    public static final double DELTA_AFFECTED_BY_BLOCKS_BELOW_1_0 = 0.999999;
    public static final int BASE_TICKS_REQUIRED_TO_FREEZE = 140;
    public static final int FREEZE_HURT_FREQUENCY = 40;
    public static final int BASE_SAFE_FALL_DISTANCE = 3;
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double WATER_FLOW_SCALE = 0.014;
    private static final double LAVA_FAST_FLOW_SCALE = 0.007;
    private static final double LAVA_SLOW_FLOW_SCALE = 0.0023333333333333335;
    public static final String UUID_TAG = "UUID";
    private static double viewScale = 1.0;
    private final EntityType<?> type;
    private int id = ENTITY_COUNTER.incrementAndGet();
    public boolean blocksBuilding;
    private ImmutableList<Entity> passengers = ImmutableList.of();
    protected int boardingCooldown;
    @Nullable
    private Entity vehicle;
    private Level level;
    public double xo;
    public double yo;
    public double zo;
    private Vec3 position;
    private BlockPos blockPosition;
    private ChunkPos chunkPosition;
    private Vec3 deltaMovement = Vec3.ZERO;
    private float yRot;
    private float xRot;
    public float yRotO;
    public float xRotO;
    private AABB bb = INITIAL_AABB;
    private boolean onGround;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean verticalCollisionBelow;
    public boolean minorHorizontalCollision;
    public boolean hurtMarked;
    protected Vec3 stuckSpeedMultiplier = Vec3.ZERO;
    @Nullable
    private RemovalReason removalReason;
    public static final float DEFAULT_BB_WIDTH = 0.6f;
    public static final float DEFAULT_BB_HEIGHT = 1.8f;
    public float walkDistO;
    public float walkDist;
    public float moveDist;
    public float flyDist;
    public float fallDistance;
    private float nextStep = 1.0f;
    public double xOld;
    public double yOld;
    public double zOld;
    public boolean noPhysics;
    protected final RandomSource random = RandomSource.create();
    public int tickCount;
    private int remainingFireTicks = -this.getFireImmuneTicks();
    protected boolean wasTouchingWater;
    protected Object2DoubleMap<TagKey<Fluid>> fluidHeight = new Object2DoubleArrayMap(2);
    protected boolean wasEyeInWater;
    private final Set<TagKey<Fluid>> fluidOnEyes = new HashSet<TagKey<Fluid>>();
    public int invulnerableTime;
    protected boolean firstTick = true;
    protected final SynchedEntityData entityData;
    protected static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BYTE);
    protected static final int FLAG_ONFIRE = 0;
    private static final int FLAG_SHIFT_KEY_DOWN = 1;
    private static final int FLAG_SPRINTING = 3;
    private static final int FLAG_SWIMMING = 4;
    private static final int FLAG_INVISIBLE = 5;
    protected static final int FLAG_GLOWING = 6;
    protected static final int FLAG_FALL_FLYING = 7;
    private static final EntityDataAccessor<Integer> DATA_AIR_SUPPLY_ID = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<Component>> DATA_CUSTOM_NAME = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Boolean> DATA_CUSTOM_NAME_VISIBLE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_SILENT = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_NO_GRAVITY = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Pose> DATA_POSE = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.POSE);
    private static final EntityDataAccessor<Integer> DATA_TICKS_FROZEN = SynchedEntityData.defineId(Entity.class, EntityDataSerializers.INT);
    private EntityInLevelCallback levelCallback = EntityInLevelCallback.NULL;
    private final VecDeltaCodec packetPositionCodec = new VecDeltaCodec();
    public boolean noCulling;
    public boolean hasImpulse;
    @Nullable
    public PortalProcessor portalProcess;
    private int portalCooldown;
    private boolean invulnerable;
    protected UUID uuid = Mth.createInsecureUUID(this.random);
    protected String stringUUID = this.uuid.toString();
    private boolean hasGlowingTag;
    private final Set<String> tags = Sets.newHashSet();
    private final double[] pistonDeltas = new double[]{0.0, 0.0, 0.0};
    private long pistonDeltasGameTime;
    private EntityDimensions dimensions;
    private float eyeHeight;
    public boolean isInPowderSnow;
    public boolean wasInPowderSnow;
    public boolean wasOnFire;
    public Optional<BlockPos> mainSupportingBlockPos = Optional.empty();
    private boolean onGroundNoBlocks = false;
    private float crystalSoundIntensity;
    private int lastCrystalSoundPlayTick;
    private boolean hasVisualFire;
    @Nullable
    private BlockState inBlockState = null;

    public Entity(EntityType<?> p_19870_, Level p_19871_) {
        this.type = p_19870_;
        this.level = p_19871_;
        this.dimensions = p_19870_.getDimensions();
        this.position = Vec3.ZERO;
        this.blockPosition = BlockPos.ZERO;
        this.chunkPosition = ChunkPos.ZERO;
        SynchedEntityData.Builder $$2 = new SynchedEntityData.Builder(this);
        $$2.define(DATA_SHARED_FLAGS_ID, (byte)0);
        $$2.define(DATA_AIR_SUPPLY_ID, this.getMaxAirSupply());
        $$2.define(DATA_CUSTOM_NAME_VISIBLE, false);
        $$2.define(DATA_CUSTOM_NAME, Optional.empty());
        $$2.define(DATA_SILENT, false);
        $$2.define(DATA_NO_GRAVITY, false);
        $$2.define(DATA_POSE, Pose.STANDING);
        $$2.define(DATA_TICKS_FROZEN, 0);
        this.defineSynchedData($$2);
        this.entityData = $$2.build();
        this.setPos(0.0, 0.0, 0.0);
        this.eyeHeight = this.dimensions.eyeHeight();
    }

    public boolean isColliding(BlockPos p_20040_, BlockState p_20041_) {
        VoxelShape $$2 = p_20041_.getCollisionShape(this.level(), p_20040_, CollisionContext.of(this));
        VoxelShape $$3 = $$2.move(p_20040_.getX(), p_20040_.getY(), p_20040_.getZ());
        return Shapes.joinIsNotEmpty($$3, Shapes.create(this.getBoundingBox()), BooleanOp.AND);
    }

    public int getTeamColor() {
        PlayerTeam $$0 = this.getTeam();
        if ($$0 != null && ((Team)$$0).getColor().getColor() != null) {
            return ((Team)$$0).getColor().getColor();
        }
        return 0xFFFFFF;
    }

    public boolean isSpectator() {
        return false;
    }

    public final void unRide() {
        if (this.isVehicle()) {
            this.ejectPassengers();
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
    }

    public void syncPacketPositionCodec(double p_217007_, double p_217008_, double p_217009_) {
        this.packetPositionCodec.setBase(new Vec3(p_217007_, p_217008_, p_217009_));
    }

    public VecDeltaCodec getPositionCodec() {
        return this.packetPositionCodec;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int p_20235_) {
        this.id = p_20235_;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean addTag(String p_20050_) {
        if (this.tags.size() >= 1024) {
            return false;
        }
        return this.tags.add(p_20050_);
    }

    public boolean removeTag(String p_20138_) {
        return this.tags.remove(p_20138_);
    }

    public void kill() {
        this.remove(RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    public final void discard() {
        this.remove(RemovalReason.DISCARDED);
    }

    protected abstract void defineSynchedData(SynchedEntityData.Builder var1);

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public boolean equals(Object p_20245_) {
        if (p_20245_ instanceof Entity) {
            return ((Entity)p_20245_).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void remove(RemovalReason p_146834_) {
        this.setRemoved(p_146834_);
    }

    public void onClientRemoval() {
    }

    public void setPose(Pose p_20125_) {
        this.entityData.set(DATA_POSE, p_20125_);
    }

    public Pose getPose() {
        return this.entityData.get(DATA_POSE);
    }

    public boolean hasPose(Pose p_217004_) {
        return this.getPose() == p_217004_;
    }

    public boolean closerThan(Entity p_19951_, double p_19952_) {
        return this.position().closerThan(p_19951_.position(), p_19952_);
    }

    public boolean closerThan(Entity p_216993_, double p_216994_, double p_216995_) {
        double $$3 = p_216993_.getX() - this.getX();
        double $$4 = p_216993_.getY() - this.getY();
        double $$5 = p_216993_.getZ() - this.getZ();
        return Mth.lengthSquared($$3, $$5) < Mth.square(p_216994_) && Mth.square($$4) < Mth.square(p_216995_);
    }

    protected void setRot(float p_19916_, float p_19917_) {
        this.setYRot(p_19916_ % 360.0f);
        this.setXRot(p_19917_ % 360.0f);
    }

    public final void setPos(Vec3 p_146885_) {
        this.setPos(p_146885_.x(), p_146885_.y(), p_146885_.z());
    }

    public void setPos(double p_20210_, double p_20211_, double p_20212_) {
        this.setPosRaw(p_20210_, p_20211_, p_20212_);
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox() {
        return this.dimensions.makeBoundingBox(this.position);
    }

    protected void reapplyPosition() {
        this.setPos(this.position.x, this.position.y, this.position.z);
    }

    public void turn(double p_19885_, double p_19886_) {
        float $$2 = (float)p_19886_ * 0.15f;
        float $$3 = (float)p_19885_ * 0.15f;
        this.setXRot(this.getXRot() + $$2);
        this.setYRot(this.getYRot() + $$3);
        this.setXRot(Mth.clamp(this.getXRot(), -90.0f, 90.0f));
        this.xRotO += $$2;
        this.yRotO += $$3;
        this.xRotO = Mth.clamp(this.xRotO, -90.0f, 90.0f);
        if (this.vehicle != null) {
            this.vehicle.onPassengerTurned(this);
        }
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        this.level().getProfiler().push("entityBaseTick");
        this.inBlockState = null;
        if (this.isPassenger() && this.getVehicle().isRemoved()) {
            this.stopRiding();
        }
        if (this.boardingCooldown > 0) {
            --this.boardingCooldown;
        }
        this.walkDistO = this.walkDist;
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.handlePortal();
        if (this.canSpawnSprintParticle()) {
            this.spawnSprintParticle();
        }
        this.wasInPowderSnow = this.isInPowderSnow;
        this.isInPowderSnow = false;
        this.updateInWaterStateAndDoFluidPushing();
        this.updateFluidOnEyes();
        this.updateSwimming();
        if (this.level().isClientSide) {
            this.clearFire();
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune()) {
                this.setRemainingFireTicks(this.remainingFireTicks - 4);
                if (this.remainingFireTicks < 0) {
                    this.clearFire();
                }
            } else {
                if (this.remainingFireTicks % 20 == 0 && !this.isInLava()) {
                    this.hurt(this.damageSources().onFire(), 1.0f);
                }
                this.setRemainingFireTicks(this.remainingFireTicks - 1);
            }
            if (this.getTicksFrozen() > 0) {
                this.setTicksFrozen(0);
                this.level().levelEvent(null, 1009, this.blockPosition, 1);
            }
        }
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.checkBelowWorld();
        if (!this.level().isClientSide) {
            this.setSharedFlagOnFire(this.remainingFireTicks > 0);
        }
        this.firstTick = false;
        if (!this.level().isClientSide && this instanceof Leashable) {
            Leashable.tickLeash((Entity)((Object)((Leashable)((Object)this))));
        }
        this.level().getProfiler().pop();
    }

    public void setSharedFlagOnFire(boolean p_146869_) {
        this.setSharedFlag(0, p_146869_ || this.hasVisualFire);
    }

    public void checkBelowWorld() {
        if (this.getY() < (double)(this.level().getMinBuildHeight() - 64)) {
            this.onBelowWorld();
        }
    }

    public void setPortalCooldown() {
        this.portalCooldown = this.getDimensionChangingDelay();
    }

    public void setPortalCooldown(int p_287760_) {
        this.portalCooldown = p_287760_;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean isOnPortalCooldown() {
        return this.portalCooldown > 0;
    }

    protected void processPortalCooldown() {
        if (this.isOnPortalCooldown()) {
            --this.portalCooldown;
        }
    }

    public void lavaHurt() {
        if (this.fireImmune()) {
            return;
        }
        this.igniteForSeconds(15.0f);
        if (this.hurt(this.damageSources().lava(), 4.0f)) {
            this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
    }

    public final void igniteForSeconds(float p_345382_) {
        this.igniteForTicks(Mth.floor(p_345382_ * 20.0f));
    }

    public void igniteForTicks(int p_320711_) {
        if (this.remainingFireTicks < p_320711_) {
            this.setRemainingFireTicks(p_320711_);
        }
    }

    public void setRemainingFireTicks(int p_20269_) {
        this.remainingFireTicks = p_20269_;
    }

    public int getRemainingFireTicks() {
        return this.remainingFireTicks;
    }

    public void clearFire() {
        this.setRemainingFireTicks(0);
    }

    protected void onBelowWorld() {
        this.discard();
    }

    public boolean isFree(double p_20230_, double p_20231_, double p_20232_) {
        return this.isFree(this.getBoundingBox().move(p_20230_, p_20231_, p_20232_));
    }

    private boolean isFree(AABB p_20132_) {
        return this.level().noCollision(this, p_20132_) && !this.level().containsAnyLiquid(p_20132_);
    }

    public void setOnGround(boolean p_20181_) {
        this.onGround = p_20181_;
        this.checkSupportingBlock(p_20181_, null);
    }

    public void setOnGroundWithMovement(boolean p_289661_, Vec3 p_289653_) {
        this.onGround = p_289661_;
        this.checkSupportingBlock(p_289661_, p_289653_);
    }

    public boolean isSupportedBy(BlockPos p_287613_) {
        return this.mainSupportingBlockPos.isPresent() && this.mainSupportingBlockPos.get().equals(p_287613_);
    }

    protected void checkSupportingBlock(boolean p_289694_, @Nullable Vec3 p_289680_) {
        if (p_289694_) {
            AABB $$2 = this.getBoundingBox();
            AABB $$3 = new AABB($$2.minX, $$2.minY - 1.0E-6, $$2.minZ, $$2.maxX, $$2.minY, $$2.maxZ);
            Optional<BlockPos> $$4 = this.level.findSupportingBlock(this, $$3);
            if ($$4.isPresent() || this.onGroundNoBlocks) {
                this.mainSupportingBlockPos = $$4;
            } else if (p_289680_ != null) {
                AABB $$5 = $$3.move(-p_289680_.x, 0.0, -p_289680_.z);
                $$4 = this.level.findSupportingBlock(this, $$5);
                this.mainSupportingBlockPos = $$4;
            }
            this.onGroundNoBlocks = $$4.isEmpty();
        } else {
            this.onGroundNoBlocks = false;
            if (this.mainSupportingBlockPos.isPresent()) {
                this.mainSupportingBlockPos = Optional.empty();
            }
        }
    }

    public boolean onGround() {
        return this.onGround;
    }

    public void move(MoverType p_19973_, Vec3 p_19974_) {
        MovementEmission $$11;
        Vec3 $$2;
        double $$3;
        if (this.noPhysics) {
            this.setPos(this.getX() + p_19974_.x, this.getY() + p_19974_.y, this.getZ() + p_19974_.z);
            return;
        }
        this.wasOnFire = this.isOnFire();
        if (p_19973_ == MoverType.PISTON && (p_19974_ = this.limitPistonMovement(p_19974_)).equals(Vec3.ZERO)) {
            return;
        }
        this.level().getProfiler().push("move");
        if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
            p_19974_ = p_19974_.multiply(this.stuckSpeedMultiplier);
            this.stuckSpeedMultiplier = Vec3.ZERO;
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (($$3 = ($$2 = this.collide(p_19974_ = this.maybeBackOffFromEdge(p_19974_, p_19973_))).lengthSqr()) > 1.0E-7) {
            BlockHitResult $$4;
            if (this.fallDistance != 0.0f && $$3 >= 1.0 && ($$4 = this.level().clip(new ClipContext(this.position(), this.position().add($$2), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, this))).getType() != HitResult.Type.MISS) {
                this.resetFallDistance();
            }
            this.setPos(this.getX() + $$2.x, this.getY() + $$2.y, this.getZ() + $$2.z);
        }
        this.level().getProfiler().pop();
        this.level().getProfiler().push("rest");
        boolean $$5 = !Mth.equal(p_19974_.x, $$2.x);
        boolean $$6 = !Mth.equal(p_19974_.z, $$2.z);
        this.horizontalCollision = $$5 || $$6;
        this.verticalCollision = p_19974_.y != $$2.y;
        this.verticalCollisionBelow = this.verticalCollision && p_19974_.y < 0.0;
        this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor($$2) : false;
        this.setOnGroundWithMovement(this.verticalCollisionBelow, $$2);
        BlockPos $$7 = this.getOnPosLegacy();
        BlockState $$8 = this.level().getBlockState($$7);
        this.checkFallDamage($$2.y, this.onGround(), $$8, $$7);
        if (this.isRemoved()) {
            this.level().getProfiler().pop();
            return;
        }
        if (this.horizontalCollision) {
            Vec3 $$9 = this.getDeltaMovement();
            this.setDeltaMovement($$5 ? 0.0 : $$9.x, $$9.y, $$6 ? 0.0 : $$9.z);
        }
        Block $$10 = $$8.getBlock();
        if (p_19974_.y != $$2.y) {
            $$10.updateEntityAfterFallOn(this.level(), this);
        }
        if (this.onGround()) {
            $$10.stepOn(this.level(), $$7, $$8, this);
        }
        if (($$11 = this.getMovementEmission()).emitsAnything() && !this.isPassenger()) {
            double $$12 = $$2.x;
            double $$13 = $$2.y;
            double $$14 = $$2.z;
            this.flyDist += (float)($$2.length() * 0.6);
            BlockPos $$15 = this.getOnPos();
            BlockState $$16 = this.level().getBlockState($$15);
            boolean $$17 = this.isStateClimbable($$16);
            if (!$$17) {
                $$13 = 0.0;
            }
            this.walkDist += (float)$$2.horizontalDistance() * 0.6f;
            this.moveDist += (float)Math.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14) * 0.6f;
            if (this.moveDist > this.nextStep && !$$16.isAir()) {
                boolean $$18 = $$15.equals($$7);
                boolean $$19 = this.vibrationAndSoundEffectsFromBlock($$7, $$8, $$11.emitsSounds(), $$18, p_19974_);
                if (!$$18) {
                    $$19 |= this.vibrationAndSoundEffectsFromBlock($$15, $$16, false, $$11.emitsEvents(), p_19974_);
                }
                if ($$19) {
                    this.nextStep = this.nextStep();
                } else if (this.isInWater()) {
                    this.nextStep = this.nextStep();
                    if ($$11.emitsSounds()) {
                        this.waterSwimSound();
                    }
                    if ($$11.emitsEvents()) {
                        this.gameEvent(GameEvent.SWIM);
                    }
                }
            } else if ($$16.isAir()) {
                this.processFlappingMovement();
            }
        }
        this.tryCheckInsideBlocks();
        float $$20 = this.getBlockSpeedFactor();
        this.setDeltaMovement(this.getDeltaMovement().multiply($$20, 1.0, $$20));
        if (this.level().getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(p_20127_ -> p_20127_.is(BlockTags.FIRE) || p_20127_.is(Blocks.LAVA))) {
            if (this.remainingFireTicks <= 0) {
                this.setRemainingFireTicks(-this.getFireImmuneTicks());
            }
            if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
                this.playEntityOnFireExtinguishedSound();
            }
        }
        if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble())) {
            this.setRemainingFireTicks(-this.getFireImmuneTicks());
        }
        this.level().getProfiler().pop();
    }

    private boolean isStateClimbable(BlockState p_286733_) {
        return p_286733_.is(BlockTags.CLIMBABLE) || p_286733_.is(Blocks.POWDER_SNOW);
    }

    private boolean vibrationAndSoundEffectsFromBlock(BlockPos p_286221_, BlockState p_286549_, boolean p_286708_, boolean p_286543_, Vec3 p_286448_) {
        if (p_286549_.isAir()) {
            return false;
        }
        boolean $$5 = this.isStateClimbable(p_286549_);
        if ((this.onGround() || $$5 || this.isCrouching() && p_286448_.y == 0.0 || this.isOnRails()) && !this.isSwimming()) {
            if (p_286708_) {
                this.walkingStepSound(p_286221_, p_286549_);
            }
            if (p_286543_) {
                this.level().gameEvent(GameEvent.STEP, this.position(), GameEvent.Context.of(this, p_286549_));
            }
            return true;
        }
        return false;
    }

    protected boolean isHorizontalCollisionMinor(Vec3 p_196625_) {
        return false;
    }

    protected void tryCheckInsideBlocks() {
        try {
            this.checkInsideBlocks();
        }
        catch (Throwable $$0) {
            CrashReport $$1 = CrashReport.forThrowable($$0, "Checking entity block collision");
            CrashReportCategory $$2 = $$1.addCategory("Entity being checked for collision");
            this.fillCrashReportCategory($$2);
            throw new ReportedException($$1);
        }
    }

    protected void playEntityOnFireExtinguishedSound() {
        this.playSound(SoundEvents.GENERIC_EXTINGUISH_FIRE, 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    public void extinguishFire() {
        if (!this.level().isClientSide && this.wasOnFire) {
            this.playEntityOnFireExtinguishedSound();
        }
        this.clearFire();
    }

    protected void processFlappingMovement() {
        if (this.isFlapping()) {
            this.onFlap();
            if (this.getMovementEmission().emitsEvents()) {
                this.gameEvent(GameEvent.FLAP);
            }
        }
    }

    @Deprecated
    public BlockPos getOnPosLegacy() {
        return this.getOnPos(0.2f);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    public BlockPos getOnPos() {
        return this.getOnPos(1.0E-5f);
    }

    protected BlockPos getOnPos(float p_216987_) {
        if (this.mainSupportingBlockPos.isPresent()) {
            BlockPos $$1 = this.mainSupportingBlockPos.get();
            if (p_216987_ > 1.0E-5f) {
                BlockState $$2 = this.level().getBlockState($$1);
                if ((double)p_216987_ <= 0.5 && $$2.is(BlockTags.FENCES) || $$2.is(BlockTags.WALLS) || $$2.getBlock() instanceof FenceGateBlock) {
                    return $$1;
                }
                return $$1.atY(Mth.floor(this.position.y - (double)p_216987_));
            }
            return $$1;
        }
        int $$3 = Mth.floor(this.position.x);
        int $$4 = Mth.floor(this.position.y - (double)p_216987_);
        int $$5 = Mth.floor(this.position.z);
        return new BlockPos($$3, $$4, $$5);
    }

    protected float getBlockJumpFactor() {
        float $$0 = this.level().getBlockState(this.blockPosition()).getBlock().getJumpFactor();
        float $$1 = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getJumpFactor();
        return (double)$$0 == 1.0 ? $$1 : $$0;
    }

    protected float getBlockSpeedFactor() {
        BlockState $$0 = this.level().getBlockState(this.blockPosition());
        float $$1 = $$0.getBlock().getSpeedFactor();
        if ($$0.is(Blocks.WATER) || $$0.is(Blocks.BUBBLE_COLUMN)) {
            return $$1;
        }
        return (double)$$1 == 1.0 ? this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getSpeedFactor() : $$1;
    }

    protected Vec3 maybeBackOffFromEdge(Vec3 p_20019_, MoverType p_20020_) {
        return p_20019_;
    }

    protected Vec3 limitPistonMovement(Vec3 p_20134_) {
        if (p_20134_.lengthSqr() <= 1.0E-7) {
            return p_20134_;
        }
        long $$1 = this.level().getGameTime();
        if ($$1 != this.pistonDeltasGameTime) {
            Arrays.fill(this.pistonDeltas, 0.0);
            this.pistonDeltasGameTime = $$1;
        }
        if (p_20134_.x != 0.0) {
            double $$2 = this.applyPistonMovementRestriction(Direction.Axis.X, p_20134_.x);
            return Math.abs($$2) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3($$2, 0.0, 0.0);
        }
        if (p_20134_.y != 0.0) {
            double $$3 = this.applyPistonMovementRestriction(Direction.Axis.Y, p_20134_.y);
            return Math.abs($$3) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, $$3, 0.0);
        }
        if (p_20134_.z != 0.0) {
            double $$4 = this.applyPistonMovementRestriction(Direction.Axis.Z, p_20134_.z);
            return Math.abs($$4) <= (double)1.0E-5f ? Vec3.ZERO : new Vec3(0.0, 0.0, $$4);
        }
        return Vec3.ZERO;
    }

    private double applyPistonMovementRestriction(Direction.Axis p_20043_, double p_20044_) {
        int $$2 = p_20043_.ordinal();
        double $$3 = Mth.clamp(p_20044_ + this.pistonDeltas[$$2], -0.51, 0.51);
        p_20044_ = $$3 - this.pistonDeltas[$$2];
        this.pistonDeltas[$$2] = $$3;
        return p_20044_;
    }

    private Vec3 collide(Vec3 p_20273_) {
        boolean $$7;
        AABB $$1 = this.getBoundingBox();
        List<VoxelShape> $$2 = this.level().getEntityCollisions(this, $$1.expandTowards(p_20273_));
        Vec3 $$3 = p_20273_.lengthSqr() == 0.0 ? p_20273_ : Entity.collideBoundingBox(this, p_20273_, $$1, this.level(), $$2);
        boolean $$4 = p_20273_.x != $$3.x;
        boolean $$5 = p_20273_.y != $$3.y;
        boolean $$6 = p_20273_.z != $$3.z;
        boolean bl = $$7 = $$5 && p_20273_.y < 0.0;
        if (this.maxUpStep() > 0.0f && ($$7 || this.onGround()) && ($$4 || $$6)) {
            float[] $$12;
            AABB $$8 = $$7 ? $$1.move(0.0, $$3.y, 0.0) : $$1;
            AABB $$9 = $$8.expandTowards(p_20273_.x, this.maxUpStep(), p_20273_.z);
            if (!$$7) {
                $$9 = $$9.expandTowards(0.0, -1.0E-5f, 0.0);
            }
            List<VoxelShape> $$10 = Entity.collectColliders(this, this.level, $$2, $$9);
            float $$11 = (float)$$3.y;
            for (float $$13 : $$12 = Entity.collectCandidateStepUpHeights($$8, $$10, this.maxUpStep(), $$11)) {
                Vec3 $$14 = Entity.collideWithShapes(new Vec3(p_20273_.x, $$13, p_20273_.z), $$8, $$10);
                if (!($$14.horizontalDistanceSqr() > $$3.horizontalDistanceSqr())) continue;
                double $$15 = $$1.minY - $$8.minY;
                return $$14.add(0.0, -$$15, 0.0);
            }
        }
        return $$3;
    }

    private static float[] collectCandidateStepUpHeights(AABB p_345729_, List<VoxelShape> p_345260_, float p_346165_, float p_345968_) {
        FloatArraySet $$4 = new FloatArraySet(4);
        block0: for (VoxelShape $$5 : p_345260_) {
            DoubleList $$6 = $$5.getCoords(Direction.Axis.Y);
            DoubleListIterator doubleListIterator = $$6.iterator();
            while (doubleListIterator.hasNext()) {
                double $$7 = (Double)doubleListIterator.next();
                float $$8 = (float)($$7 - p_345729_.minY);
                if ($$8 < 0.0f || $$8 == p_345968_) continue;
                if ($$8 > p_346165_) continue block0;
                $$4.add($$8);
            }
        }
        float[] $$9 = $$4.toFloatArray();
        FloatArrays.unstableSort((float[])$$9);
        return $$9;
    }

    public static Vec3 collideBoundingBox(@Nullable Entity p_198895_, Vec3 p_198896_, AABB p_198897_, Level p_198898_, List<VoxelShape> p_198899_) {
        List<VoxelShape> $$5 = Entity.collectColliders(p_198895_, p_198898_, p_198899_, p_198897_.expandTowards(p_198896_));
        return Entity.collideWithShapes(p_198896_, p_198897_, $$5);
    }

    private static List<VoxelShape> collectColliders(@Nullable Entity p_344804_, Level p_345583_, List<VoxelShape> p_345198_, AABB p_345837_) {
        boolean $$6;
        ImmutableList.Builder $$4 = ImmutableList.builderWithExpectedSize((int)(p_345198_.size() + 1));
        if (!p_345198_.isEmpty()) {
            $$4.addAll(p_345198_);
        }
        WorldBorder $$5 = p_345583_.getWorldBorder();
        boolean bl = $$6 = p_344804_ != null && $$5.isInsideCloseToBorder(p_344804_, p_345837_);
        if ($$6) {
            $$4.add((Object)$$5.getCollisionShape());
        }
        $$4.addAll(p_345583_.getBlockCollisions(p_344804_, p_345837_));
        return $$4.build();
    }

    private static Vec3 collideWithShapes(Vec3 p_198901_, AABB p_198902_, List<VoxelShape> p_198903_) {
        boolean $$6;
        if (p_198903_.isEmpty()) {
            return p_198901_;
        }
        double $$3 = p_198901_.x;
        double $$4 = p_198901_.y;
        double $$5 = p_198901_.z;
        if ($$4 != 0.0 && ($$4 = Shapes.collide(Direction.Axis.Y, p_198902_, p_198903_, $$4)) != 0.0) {
            p_198902_ = p_198902_.move(0.0, $$4, 0.0);
        }
        boolean bl = $$6 = Math.abs($$3) < Math.abs($$5);
        if ($$6 && $$5 != 0.0 && ($$5 = Shapes.collide(Direction.Axis.Z, p_198902_, p_198903_, $$5)) != 0.0) {
            p_198902_ = p_198902_.move(0.0, 0.0, $$5);
        }
        if ($$3 != 0.0) {
            $$3 = Shapes.collide(Direction.Axis.X, p_198902_, p_198903_, $$3);
            if (!$$6 && $$3 != 0.0) {
                p_198902_ = p_198902_.move($$3, 0.0, 0.0);
            }
        }
        if (!$$6 && $$5 != 0.0) {
            $$5 = Shapes.collide(Direction.Axis.Z, p_198902_, p_198903_, $$5);
        }
        return new Vec3($$3, $$4, $$5);
    }

    protected float nextStep() {
        return (int)this.moveDist + 1;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.GENERIC_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.GENERIC_SPLASH;
    }

    protected void checkInsideBlocks() {
        AABB $$0 = this.getBoundingBox();
        BlockPos $$1 = BlockPos.containing($$0.minX + 1.0E-7, $$0.minY + 1.0E-7, $$0.minZ + 1.0E-7);
        BlockPos $$2 = BlockPos.containing($$0.maxX - 1.0E-7, $$0.maxY - 1.0E-7, $$0.maxZ - 1.0E-7);
        if (this.level().hasChunksAt($$1, $$2)) {
            BlockPos.MutableBlockPos $$3 = new BlockPos.MutableBlockPos();
            for (int $$4 = $$1.getX(); $$4 <= $$2.getX(); ++$$4) {
                for (int $$5 = $$1.getY(); $$5 <= $$2.getY(); ++$$5) {
                    for (int $$6 = $$1.getZ(); $$6 <= $$2.getZ(); ++$$6) {
                        if (!this.isAlive()) {
                            return;
                        }
                        $$3.set($$4, $$5, $$6);
                        BlockState $$7 = this.level().getBlockState($$3);
                        try {
                            $$7.entityInside(this.level(), $$3, this);
                            this.onInsideBlock($$7);
                            continue;
                        }
                        catch (Throwable $$8) {
                            CrashReport $$9 = CrashReport.forThrowable($$8, "Colliding entity with block");
                            CrashReportCategory $$10 = $$9.addCategory("Block being collided with");
                            CrashReportCategory.populateBlockDetails($$10, this.level(), $$3, $$7);
                            throw new ReportedException($$9);
                        }
                    }
                }
            }
        }
    }

    protected void onInsideBlock(BlockState p_20005_) {
    }

    public BlockPos adjustSpawnLocation(ServerLevel p_352356_, BlockPos p_352343_) {
        BlockPos $$2 = p_352356_.getSharedSpawnPos();
        Vec3 $$3 = $$2.getCenter();
        int $$4 = p_352356_.getChunkAt($$2).getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, $$2.getX(), $$2.getZ()) + 1;
        return BlockPos.containing($$3.x, $$4, $$3.z);
    }

    public void gameEvent(Holder<GameEvent> p_316133_, @Nullable Entity p_146854_) {
        this.level().gameEvent(p_146854_, p_316133_, this.position);
    }

    public void gameEvent(Holder<GameEvent> p_316256_) {
        this.gameEvent(p_316256_, this);
    }

    private void walkingStepSound(BlockPos p_281828_, BlockState p_282118_) {
        this.playStepSound(p_281828_, p_282118_);
        if (this.shouldPlayAmethystStepSound(p_282118_)) {
            this.playAmethystStepSound();
        }
    }

    protected void waterSwimSound() {
        Entity $$0 = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float $$1 = $$0 == this ? 0.35f : 0.4f;
        Vec3 $$2 = $$0.getDeltaMovement();
        float $$3 = Math.min(1.0f, (float)Math.sqrt($$2.x * $$2.x * (double)0.2f + $$2.y * $$2.y + $$2.z * $$2.z * (double)0.2f) * $$1);
        this.playSwimSound($$3);
    }

    protected BlockPos getPrimaryStepSoundBlockPos(BlockPos p_278049_) {
        BlockPos $$1 = p_278049_.above();
        BlockState $$2 = this.level().getBlockState($$1);
        if ($$2.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) || $$2.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS)) {
            return $$1;
        }
        return p_278049_;
    }

    protected void playCombinationStepSounds(BlockState p_277472_, BlockState p_277630_) {
        SoundType $$2 = p_277472_.getSoundType();
        this.playSound($$2.getStepSound(), $$2.getVolume() * 0.15f, $$2.getPitch());
        this.playMuffledStepSound(p_277630_);
    }

    protected void playMuffledStepSound(BlockState p_283110_) {
        SoundType $$1 = p_283110_.getSoundType();
        this.playSound($$1.getStepSound(), $$1.getVolume() * 0.05f, $$1.getPitch() * 0.8f);
    }

    protected void playStepSound(BlockPos p_20135_, BlockState p_20136_) {
        SoundType $$2 = p_20136_.getSoundType();
        this.playSound($$2.getStepSound(), $$2.getVolume() * 0.15f, $$2.getPitch());
    }

    private boolean shouldPlayAmethystStepSound(BlockState p_278069_) {
        return p_278069_.is(BlockTags.CRYSTAL_SOUND_BLOCKS) && this.tickCount >= this.lastCrystalSoundPlayTick + 20;
    }

    private void playAmethystStepSound() {
        this.crystalSoundIntensity *= (float)Math.pow(0.997, this.tickCount - this.lastCrystalSoundPlayTick);
        this.crystalSoundIntensity = Math.min(1.0f, this.crystalSoundIntensity + 0.07f);
        float $$0 = 0.5f + this.crystalSoundIntensity * this.random.nextFloat() * 1.2f;
        float $$1 = 0.1f + this.crystalSoundIntensity * 1.2f;
        this.playSound(SoundEvents.AMETHYST_BLOCK_CHIME, $$1, $$0);
        this.lastCrystalSoundPlayTick = this.tickCount;
    }

    protected void playSwimSound(float p_20213_) {
        this.playSound(this.getSwimSound(), p_20213_, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
    }

    protected void onFlap() {
    }

    protected boolean isFlapping() {
        return false;
    }

    public void playSound(SoundEvent p_19938_, float p_19939_, float p_19940_) {
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), p_19938_, this.getSoundSource(), p_19939_, p_19940_);
        }
    }

    public void playSound(SoundEvent p_216991_) {
        if (!this.isSilent()) {
            this.playSound(p_216991_, 1.0f, 1.0f);
        }
    }

    public boolean isSilent() {
        return this.entityData.get(DATA_SILENT);
    }

    public void setSilent(boolean p_20226_) {
        this.entityData.set(DATA_SILENT, p_20226_);
    }

    public boolean isNoGravity() {
        return this.entityData.get(DATA_NO_GRAVITY);
    }

    public void setNoGravity(boolean p_20243_) {
        this.entityData.set(DATA_NO_GRAVITY, p_20243_);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public final double getGravity() {
        return this.isNoGravity() ? 0.0 : this.getDefaultGravity();
    }

    protected void applyGravity() {
        double $$0 = this.getGravity();
        if ($$0 != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -$$0, 0.0));
        }
    }

    protected MovementEmission getMovementEmission() {
        return MovementEmission.ALL;
    }

    public boolean dampensVibrations() {
        return false;
    }

    protected void checkFallDamage(double p_19911_, boolean p_19912_, BlockState p_19913_, BlockPos p_19914_) {
        if (p_19912_) {
            if (this.fallDistance > 0.0f) {
                p_19913_.getBlock().fallOn(this.level(), p_19913_, p_19914_, this, this.fallDistance);
                this.level().gameEvent(GameEvent.HIT_GROUND, this.position, GameEvent.Context.of(this, this.mainSupportingBlockPos.map(p_286200_ -> this.level().getBlockState((BlockPos)p_286200_)).orElse(p_19913_)));
            }
            this.resetFallDistance();
        } else if (p_19911_ < 0.0) {
            this.fallDistance -= (float)p_19911_;
        }
    }

    public boolean fireImmune() {
        return this.getType().fireImmune();
    }

    public boolean causeFallDamage(float p_146828_, float p_146829_, DamageSource p_146830_) {
        if (this.type.is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return false;
        }
        if (this.isVehicle()) {
            for (Entity $$3 : this.getPassengers()) {
                $$3.causeFallDamage(p_146828_, p_146829_, p_146830_);
            }
        }
        return false;
    }

    public boolean isInWater() {
        return this.wasTouchingWater;
    }

    private boolean isInRain() {
        BlockPos $$0 = this.blockPosition();
        return this.level().isRainingAt($$0) || this.level().isRainingAt(BlockPos.containing($$0.getX(), this.getBoundingBox().maxY, $$0.getZ()));
    }

    private boolean isInBubbleColumn() {
        return this.getInBlockState().is(Blocks.BUBBLE_COLUMN);
    }

    public boolean isInWaterOrRain() {
        return this.isInWater() || this.isInRain();
    }

    public boolean isInWaterRainOrBubble() {
        return this.isInWater() || this.isInRain() || this.isInBubbleColumn();
    }

    public boolean isInWaterOrBubble() {
        return this.isInWater() || this.isInBubbleColumn();
    }

    public boolean isInLiquid() {
        return this.isInWaterOrBubble() || this.isInLava();
    }

    public boolean isUnderWater() {
        return this.wasEyeInWater && this.isInWater();
    }

    public void updateSwimming() {
        if (this.isSwimming()) {
            this.setSwimming(this.isSprinting() && this.isInWater() && !this.isPassenger());
        } else {
            this.setSwimming(this.isSprinting() && this.isUnderWater() && !this.isPassenger() && this.level().getFluidState(this.blockPosition).is(FluidTags.WATER));
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateInWaterStateAndDoWaterCurrentPushing();
        double $$0 = this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335;
        boolean $$1 = this.updateFluidHeightAndDoFluidPushing(FluidTags.LAVA, $$0);
        return this.isInWater() || $$1;
    }

    void updateInWaterStateAndDoWaterCurrentPushing() {
        Boat $$0;
        Entity entity = this.getVehicle();
        if (entity instanceof Boat && !($$0 = (Boat)entity).isUnderWater()) {
            this.wasTouchingWater = false;
        } else if (this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014)) {
            if (!this.wasTouchingWater && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.resetFallDistance();
            this.wasTouchingWater = true;
            this.clearFire();
        } else {
            this.wasTouchingWater = false;
        }
    }

    private void updateFluidOnEyes() {
        Boat $$2;
        this.wasEyeInWater = this.isEyeInFluid(FluidTags.WATER);
        this.fluidOnEyes.clear();
        double $$0 = this.getEyeY();
        Entity $$1 = this.getVehicle();
        if ($$1 instanceof Boat && !($$2 = (Boat)$$1).isUnderWater() && $$2.getBoundingBox().maxY >= $$0 && $$2.getBoundingBox().minY <= $$0) {
            return;
        }
        BlockPos $$3 = BlockPos.containing(this.getX(), $$0, this.getZ());
        FluidState $$4 = this.level().getFluidState($$3);
        double $$5 = (float)$$3.getY() + $$4.getHeight(this.level(), $$3);
        if ($$5 > $$0) {
            $$4.getTags().forEach(this.fluidOnEyes::add);
        }
    }

    protected void doWaterSplashEffect() {
        Entity $$0 = Objects.requireNonNullElse(this.getControllingPassenger(), this);
        float $$1 = $$0 == this ? 0.2f : 0.9f;
        Vec3 $$2 = $$0.getDeltaMovement();
        float $$3 = Math.min(1.0f, (float)Math.sqrt($$2.x * $$2.x * (double)0.2f + $$2.y * $$2.y + $$2.z * $$2.z * (double)0.2f) * $$1);
        if ($$3 < 0.25f) {
            this.playSound(this.getSwimSplashSound(), $$3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        } else {
            this.playSound(this.getSwimHighSpeedSplashSound(), $$3, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        }
        float $$4 = Mth.floor(this.getY());
        int $$5 = 0;
        while ((float)$$5 < 1.0f + this.dimensions.width() * 20.0f) {
            double $$6 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            double $$7 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + $$6, $$4 + 1.0f, this.getZ() + $$7, $$2.x, $$2.y - this.random.nextDouble() * (double)0.2f, $$2.z);
            ++$$5;
        }
        int $$8 = 0;
        while ((float)$$8 < 1.0f + this.dimensions.width() * 20.0f) {
            double $$9 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            double $$10 = (this.random.nextDouble() * 2.0 - 1.0) * (double)this.dimensions.width();
            this.level().addParticle(ParticleTypes.SPLASH, this.getX() + $$9, $$4 + 1.0f, this.getZ() + $$10, $$2.x, $$2.y, $$2.z);
            ++$$8;
        }
        this.gameEvent(GameEvent.SPLASH);
    }

    @Deprecated
    protected BlockState getBlockStateOnLegacy() {
        return this.level().getBlockState(this.getOnPosLegacy());
    }

    public BlockState getBlockStateOn() {
        return this.level().getBlockState(this.getOnPos());
    }

    public boolean canSpawnSprintParticle() {
        return this.isSprinting() && !this.isInWater() && !this.isSpectator() && !this.isCrouching() && !this.isInLava() && this.isAlive();
    }

    protected void spawnSprintParticle() {
        BlockPos $$0 = this.getOnPosLegacy();
        BlockState $$1 = this.level().getBlockState($$0);
        if ($$1.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 $$2 = this.getDeltaMovement();
            BlockPos $$3 = this.blockPosition();
            double $$4 = this.getX() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            double $$5 = this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.dimensions.width();
            if ($$3.getX() != $$0.getX()) {
                $$4 = Mth.clamp($$4, (double)$$0.getX(), (double)$$0.getX() + 1.0);
            }
            if ($$3.getZ() != $$0.getZ()) {
                $$5 = Mth.clamp($$5, (double)$$0.getZ(), (double)$$0.getZ() + 1.0);
            }
            this.level().addParticle(new BlockParticleOption(ParticleTypes.BLOCK, $$1), $$4, this.getY() + 0.1, $$5, $$2.x * -4.0, 1.5, $$2.z * -4.0);
        }
    }

    public boolean isEyeInFluid(TagKey<Fluid> p_204030_) {
        return this.fluidOnEyes.contains(p_204030_);
    }

    public boolean isInLava() {
        return !this.firstTick && this.fluidHeight.getDouble(FluidTags.LAVA) > 0.0;
    }

    public void moveRelative(float p_19921_, Vec3 p_19922_) {
        Vec3 $$2 = Entity.getInputVector(p_19922_, p_19921_, this.getYRot());
        this.setDeltaMovement(this.getDeltaMovement().add($$2));
    }

    private static Vec3 getInputVector(Vec3 p_20016_, float p_20017_, float p_20018_) {
        double $$3 = p_20016_.lengthSqr();
        if ($$3 < 1.0E-7) {
            return Vec3.ZERO;
        }
        Vec3 $$4 = ($$3 > 1.0 ? p_20016_.normalize() : p_20016_).scale(p_20017_);
        float $$5 = Mth.sin(p_20018_ * ((float)Math.PI / 180));
        float $$6 = Mth.cos(p_20018_ * ((float)Math.PI / 180));
        return new Vec3($$4.x * (double)$$6 - $$4.z * (double)$$5, $$4.y, $$4.z * (double)$$6 + $$4.x * (double)$$5);
    }

    @Deprecated
    public float getLightLevelDependentMagicValue() {
        if (this.level().hasChunkAt(this.getBlockX(), this.getBlockZ())) {
            return this.level().getLightLevelDependentMagicValue(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ()));
        }
        return 0.0f;
    }

    public void absMoveTo(double p_19891_, double p_19892_, double p_19893_, float p_19894_, float p_19895_) {
        this.absMoveTo(p_19891_, p_19892_, p_19893_);
        this.absRotateTo(p_19894_, p_19895_);
    }

    public void absRotateTo(float p_348662_, float p_348500_) {
        this.setYRot(p_348662_ % 360.0f);
        this.setXRot(Mth.clamp(p_348500_, -90.0f, 90.0f) % 360.0f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void absMoveTo(double p_20249_, double p_20250_, double p_20251_) {
        double $$3 = Mth.clamp(p_20249_, -3.0E7, 3.0E7);
        double $$4 = Mth.clamp(p_20251_, -3.0E7, 3.0E7);
        this.xo = $$3;
        this.yo = p_20250_;
        this.zo = $$4;
        this.setPos($$3, p_20250_, $$4);
    }

    public void moveTo(Vec3 p_20220_) {
        this.moveTo(p_20220_.x, p_20220_.y, p_20220_.z);
    }

    public void moveTo(double p_20105_, double p_20106_, double p_20107_) {
        this.moveTo(p_20105_, p_20106_, p_20107_, this.getYRot(), this.getXRot());
    }

    public void moveTo(BlockPos p_20036_, float p_20037_, float p_20038_) {
        this.moveTo(p_20036_.getBottomCenter(), p_20037_, p_20038_);
    }

    public void moveTo(Vec3 p_352318_, float p_352438_, float p_352125_) {
        this.moveTo(p_352318_.x, p_352318_.y, p_352318_.z, p_352438_, p_352125_);
    }

    public void moveTo(double p_20108_, double p_20109_, double p_20110_, float p_20111_, float p_20112_) {
        this.setPosRaw(p_20108_, p_20109_, p_20110_);
        this.setYRot(p_20111_);
        this.setXRot(p_20112_);
        this.setOldPosAndRot();
        this.reapplyPosition();
    }

    public final void setOldPosAndRot() {
        double $$0 = this.getX();
        double $$1 = this.getY();
        double $$2 = this.getZ();
        this.xo = $$0;
        this.yo = $$1;
        this.zo = $$2;
        this.xOld = $$0;
        this.yOld = $$1;
        this.zOld = $$2;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public float distanceTo(Entity p_20271_) {
        float $$1 = (float)(this.getX() - p_20271_.getX());
        float $$2 = (float)(this.getY() - p_20271_.getY());
        float $$3 = (float)(this.getZ() - p_20271_.getZ());
        return Mth.sqrt($$1 * $$1 + $$2 * $$2 + $$3 * $$3);
    }

    public double distanceToSqr(double p_20276_, double p_20277_, double p_20278_) {
        double $$3 = this.getX() - p_20276_;
        double $$4 = this.getY() - p_20277_;
        double $$5 = this.getZ() - p_20278_;
        return $$3 * $$3 + $$4 * $$4 + $$5 * $$5;
    }

    public double distanceToSqr(Entity p_20281_) {
        return this.distanceToSqr(p_20281_.position());
    }

    public double distanceToSqr(Vec3 p_20239_) {
        double $$1 = this.getX() - p_20239_.x;
        double $$2 = this.getY() - p_20239_.y;
        double $$3 = this.getZ() - p_20239_.z;
        return $$1 * $$1 + $$2 * $$2 + $$3 * $$3;
    }

    public void playerTouch(Player p_20081_) {
    }

    public void push(Entity p_20293_) {
        double $$2;
        if (this.isPassengerOfSameVehicle(p_20293_)) {
            return;
        }
        if (p_20293_.noPhysics || this.noPhysics) {
            return;
        }
        double $$1 = p_20293_.getX() - this.getX();
        double $$3 = Mth.absMax($$1, $$2 = p_20293_.getZ() - this.getZ());
        if ($$3 >= (double)0.01f) {
            $$3 = Math.sqrt($$3);
            $$1 /= $$3;
            $$2 /= $$3;
            double $$4 = 1.0 / $$3;
            if ($$4 > 1.0) {
                $$4 = 1.0;
            }
            $$1 *= $$4;
            $$2 *= $$4;
            $$1 *= (double)0.05f;
            $$2 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-$$1, 0.0, -$$2);
            }
            if (!p_20293_.isVehicle() && p_20293_.isPushable()) {
                p_20293_.push($$1, 0.0, $$2);
            }
        }
    }

    public void push(Vec3 p_347665_) {
        this.push(p_347665_.x, p_347665_.y, p_347665_.z);
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
        this.setDeltaMovement(this.getDeltaMovement().add(p_20286_, p_20287_, p_20288_));
        this.hasImpulse = true;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(DamageSource p_19946_, float p_19947_) {
        if (this.isInvulnerableTo(p_19946_)) {
            return false;
        }
        this.markHurt();
        return false;
    }

    public final Vec3 getViewVector(float p_20253_) {
        return this.calculateViewVector(this.getViewXRot(p_20253_), this.getViewYRot(p_20253_));
    }

    public Direction getNearestViewDirection() {
        return Direction.getNearest(this.getViewVector(1.0f));
    }

    public float getViewXRot(float p_20268_) {
        if (p_20268_ == 1.0f) {
            return this.getXRot();
        }
        return Mth.lerp(p_20268_, this.xRotO, this.getXRot());
    }

    public float getViewYRot(float p_20279_) {
        if (p_20279_ == 1.0f) {
            return this.getYRot();
        }
        return Mth.lerp(p_20279_, this.yRotO, this.getYRot());
    }

    public final Vec3 calculateViewVector(float p_20172_, float p_20173_) {
        float $$2 = p_20172_ * ((float)Math.PI / 180);
        float $$3 = -p_20173_ * ((float)Math.PI / 180);
        float $$4 = Mth.cos($$3);
        float $$5 = Mth.sin($$3);
        float $$6 = Mth.cos($$2);
        float $$7 = Mth.sin($$2);
        return new Vec3($$5 * $$6, -$$7, $$4 * $$6);
    }

    public final Vec3 getUpVector(float p_20290_) {
        return this.calculateUpVector(this.getViewXRot(p_20290_), this.getViewYRot(p_20290_));
    }

    protected final Vec3 calculateUpVector(float p_20215_, float p_20216_) {
        return this.calculateViewVector(p_20215_ - 90.0f, p_20216_);
    }

    public final Vec3 getEyePosition() {
        return new Vec3(this.getX(), this.getEyeY(), this.getZ());
    }

    public final Vec3 getEyePosition(float p_20300_) {
        double $$1 = Mth.lerp((double)p_20300_, this.xo, this.getX());
        double $$2 = Mth.lerp((double)p_20300_, this.yo, this.getY()) + (double)this.getEyeHeight();
        double $$3 = Mth.lerp((double)p_20300_, this.zo, this.getZ());
        return new Vec3($$1, $$2, $$3);
    }

    public Vec3 getLightProbePosition(float p_20309_) {
        return this.getEyePosition(p_20309_);
    }

    public final Vec3 getPosition(float p_20319_) {
        double $$1 = Mth.lerp((double)p_20319_, this.xo, this.getX());
        double $$2 = Mth.lerp((double)p_20319_, this.yo, this.getY());
        double $$3 = Mth.lerp((double)p_20319_, this.zo, this.getZ());
        return new Vec3($$1, $$2, $$3);
    }

    public HitResult pick(double p_19908_, float p_19909_, boolean p_19910_) {
        Vec3 $$3 = this.getEyePosition(p_19909_);
        Vec3 $$4 = this.getViewVector(p_19909_);
        Vec3 $$5 = $$3.add($$4.x * p_19908_, $$4.y * p_19908_, $$4.z * p_19908_);
        return this.level().clip(new ClipContext($$3, $$5, ClipContext.Block.OUTLINE, p_19910_ ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, this));
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive() && this.isPickable();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public void awardKillScore(Entity p_19953_, int p_19954_, DamageSource p_19955_) {
        if (p_19953_ instanceof ServerPlayer) {
            CriteriaTriggers.ENTITY_KILLED_PLAYER.trigger((ServerPlayer)p_19953_, this, p_19955_);
        }
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        double $$3 = this.getX() - p_20296_;
        double $$4 = this.getY() - p_20297_;
        double $$5 = this.getZ() - p_20298_;
        double $$6 = $$3 * $$3 + $$4 * $$4 + $$5 * $$5;
        return this.shouldRenderAtSqrDistance($$6);
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        double $$1 = this.getBoundingBox().getSize();
        if (Double.isNaN($$1)) {
            $$1 = 1.0;
        }
        return p_19883_ < ($$1 *= 64.0 * viewScale) * $$1;
    }

    public boolean saveAsPassenger(CompoundTag p_20087_) {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        String $$1 = this.getEncodeId();
        if ($$1 == null) {
            return false;
        }
        p_20087_.putString(ID_TAG, $$1);
        this.saveWithoutId(p_20087_);
        return true;
    }

    public boolean save(CompoundTag p_20224_) {
        if (this.isPassenger()) {
            return false;
        }
        return this.saveAsPassenger(p_20224_);
    }

    public CompoundTag saveWithoutId(CompoundTag p_20241_) {
        try {
            int $$3;
            if (this.vehicle != null) {
                p_20241_.put("Pos", this.newDoubleList(this.vehicle.getX(), this.getY(), this.vehicle.getZ()));
            } else {
                p_20241_.put("Pos", this.newDoubleList(this.getX(), this.getY(), this.getZ()));
            }
            Vec3 $$1 = this.getDeltaMovement();
            p_20241_.put("Motion", this.newDoubleList($$1.x, $$1.y, $$1.z));
            p_20241_.put("Rotation", this.newFloatList(this.getYRot(), this.getXRot()));
            p_20241_.putFloat("FallDistance", this.fallDistance);
            p_20241_.putShort("Fire", (short)this.remainingFireTicks);
            p_20241_.putShort("Air", (short)this.getAirSupply());
            p_20241_.putBoolean("OnGround", this.onGround());
            p_20241_.putBoolean("Invulnerable", this.invulnerable);
            p_20241_.putInt("PortalCooldown", this.portalCooldown);
            p_20241_.putUUID(UUID_TAG, this.getUUID());
            Component $$2 = this.getCustomName();
            if ($$2 != null) {
                p_20241_.putString("CustomName", Component.Serializer.toJson($$2, this.registryAccess()));
            }
            if (this.isCustomNameVisible()) {
                p_20241_.putBoolean("CustomNameVisible", this.isCustomNameVisible());
            }
            if (this.isSilent()) {
                p_20241_.putBoolean("Silent", this.isSilent());
            }
            if (this.isNoGravity()) {
                p_20241_.putBoolean("NoGravity", this.isNoGravity());
            }
            if (this.hasGlowingTag) {
                p_20241_.putBoolean("Glowing", true);
            }
            if (($$3 = this.getTicksFrozen()) > 0) {
                p_20241_.putInt("TicksFrozen", this.getTicksFrozen());
            }
            if (this.hasVisualFire) {
                p_20241_.putBoolean("HasVisualFire", this.hasVisualFire);
            }
            if (!this.tags.isEmpty()) {
                ListTag $$4 = new ListTag();
                for (String $$5 : this.tags) {
                    $$4.add(StringTag.valueOf($$5));
                }
                p_20241_.put("Tags", $$4);
            }
            this.addAdditionalSaveData(p_20241_);
            if (this.isVehicle()) {
                ListTag $$6 = new ListTag();
                for (Entity $$7 : this.getPassengers()) {
                    CompoundTag $$8;
                    if (!$$7.saveAsPassenger($$8 = new CompoundTag())) continue;
                    $$6.add($$8);
                }
                if (!$$6.isEmpty()) {
                    p_20241_.put(PASSENGERS_TAG, $$6);
                }
            }
        }
        catch (Throwable $$9) {
            CrashReport $$10 = CrashReport.forThrowable($$9, "Saving entity NBT");
            CrashReportCategory $$11 = $$10.addCategory("Entity being saved");
            this.fillCrashReportCategory($$11);
            throw new ReportedException($$10);
        }
        return p_20241_;
    }

    public void load(CompoundTag p_20259_) {
        try {
            ListTag $$1 = p_20259_.getList("Pos", 6);
            ListTag $$2 = p_20259_.getList("Motion", 6);
            ListTag $$3 = p_20259_.getList("Rotation", 5);
            double $$4 = $$2.getDouble(0);
            double $$5 = $$2.getDouble(1);
            double $$6 = $$2.getDouble(2);
            this.setDeltaMovement(Math.abs($$4) > 10.0 ? 0.0 : $$4, Math.abs($$5) > 10.0 ? 0.0 : $$5, Math.abs($$6) > 10.0 ? 0.0 : $$6);
            double $$7 = 3.0000512E7;
            this.setPosRaw(Mth.clamp($$1.getDouble(0), -3.0000512E7, 3.0000512E7), Mth.clamp($$1.getDouble(1), -2.0E7, 2.0E7), Mth.clamp($$1.getDouble(2), -3.0000512E7, 3.0000512E7));
            this.setYRot($$3.getFloat(0));
            this.setXRot($$3.getFloat(1));
            this.setOldPosAndRot();
            this.setYHeadRot(this.getYRot());
            this.setYBodyRot(this.getYRot());
            this.fallDistance = p_20259_.getFloat("FallDistance");
            this.remainingFireTicks = p_20259_.getShort("Fire");
            if (p_20259_.contains("Air")) {
                this.setAirSupply(p_20259_.getShort("Air"));
            }
            this.onGround = p_20259_.getBoolean("OnGround");
            this.invulnerable = p_20259_.getBoolean("Invulnerable");
            this.portalCooldown = p_20259_.getInt("PortalCooldown");
            if (p_20259_.hasUUID(UUID_TAG)) {
                this.uuid = p_20259_.getUUID(UUID_TAG);
                this.stringUUID = this.uuid.toString();
            }
            if (!(Double.isFinite(this.getX()) && Double.isFinite(this.getY()) && Double.isFinite(this.getZ()))) {
                throw new IllegalStateException("Entity has invalid position");
            }
            if (!Double.isFinite(this.getYRot()) || !Double.isFinite(this.getXRot())) {
                throw new IllegalStateException("Entity has invalid rotation");
            }
            this.reapplyPosition();
            this.setRot(this.getYRot(), this.getXRot());
            if (p_20259_.contains("CustomName", 8)) {
                String $$8 = p_20259_.getString("CustomName");
                try {
                    this.setCustomName(Component.Serializer.fromJson($$8, (HolderLookup.Provider)this.registryAccess()));
                }
                catch (Exception $$9) {
                    LOGGER.warn("Failed to parse entity custom name {}", (Object)$$8, (Object)$$9);
                }
            }
            this.setCustomNameVisible(p_20259_.getBoolean("CustomNameVisible"));
            this.setSilent(p_20259_.getBoolean("Silent"));
            this.setNoGravity(p_20259_.getBoolean("NoGravity"));
            this.setGlowingTag(p_20259_.getBoolean("Glowing"));
            this.setTicksFrozen(p_20259_.getInt("TicksFrozen"));
            this.hasVisualFire = p_20259_.getBoolean("HasVisualFire");
            if (p_20259_.contains("Tags", 9)) {
                this.tags.clear();
                ListTag $$10 = p_20259_.getList("Tags", 8);
                int $$11 = Math.min($$10.size(), 1024);
                for (int $$12 = 0; $$12 < $$11; ++$$12) {
                    this.tags.add($$10.getString($$12));
                }
            }
            this.readAdditionalSaveData(p_20259_);
            if (this.repositionEntityAfterLoad()) {
                this.reapplyPosition();
            }
        }
        catch (Throwable $$13) {
            CrashReport $$14 = CrashReport.forThrowable($$13, "Loading entity NBT");
            CrashReportCategory $$15 = $$14.addCategory("Entity being loaded");
            this.fillCrashReportCategory($$15);
            throw new ReportedException($$14);
        }
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    @Nullable
    protected final String getEncodeId() {
        EntityType<?> $$0 = this.getType();
        ResourceLocation $$1 = EntityType.getKey($$0);
        return !$$0.canSerialize() || $$1 == null ? null : $$1.toString();
    }

    protected abstract void readAdditionalSaveData(CompoundTag var1);

    protected abstract void addAdditionalSaveData(CompoundTag var1);

    protected ListTag newDoubleList(double ... p_20064_) {
        ListTag $$1 = new ListTag();
        for (double $$2 : p_20064_) {
            $$1.add(DoubleTag.valueOf($$2));
        }
        return $$1;
    }

    protected ListTag newFloatList(float ... p_20066_) {
        ListTag $$1 = new ListTag();
        for (float $$2 : p_20066_) {
            $$1.add(FloatTag.valueOf($$2));
        }
        return $$1;
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemLike p_19999_) {
        return this.spawnAtLocation(p_19999_, 0);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemLike p_20001_, int p_20002_) {
        return this.spawnAtLocation(new ItemStack(p_20001_), (float)p_20002_);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack p_19984_) {
        return this.spawnAtLocation(p_19984_, 0.0f);
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack p_19985_, float p_19986_) {
        if (p_19985_.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide) {
            return null;
        }
        ItemEntity $$2 = new ItemEntity(this.level(), this.getX(), this.getY() + (double)p_19986_, this.getZ(), p_19985_);
        $$2.setDefaultPickUpDelay();
        this.level().addFreshEntity($$2);
        return $$2;
    }

    public boolean isAlive() {
        return !this.isRemoved();
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float $$0 = this.dimensions.width() * 0.8f;
        AABB $$1 = AABB.ofSize(this.getEyePosition(), $$0, 1.0E-6, $$0);
        return BlockPos.betweenClosedStream($$1).anyMatch(p_201942_ -> {
            BlockState $$2 = this.level().getBlockState((BlockPos)p_201942_);
            return !$$2.isAir() && $$2.isSuffocating(this.level(), (BlockPos)p_201942_) && Shapes.joinIsNotEmpty($$2.getCollisionShape(this.level(), (BlockPos)p_201942_).move(p_201942_.getX(), p_201942_.getY(), p_201942_.getZ()), Shapes.create($$1), BooleanOp.AND);
        });
    }

    public InteractionResult interact(Player p_19978_, InteractionHand p_19979_) {
        Entity entity;
        if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable $$2 = (Leashable)((Object)entity);
            if ($$2.getLeashHolder() == p_19978_) {
                if (!this.level().isClientSide()) {
                    $$2.dropLeash(true, !p_19978_.hasInfiniteMaterials());
                    this.gameEvent(GameEvent.ENTITY_INTERACT, p_19978_);
                }
                return InteractionResult.sidedSuccess(this.level().isClientSide);
            }
            ItemStack $$3 = p_19978_.getItemInHand(p_19979_);
            if ($$3.is(Items.LEAD) && $$2.canHaveALeashAttachedToIt()) {
                if (!this.level().isClientSide()) {
                    $$2.setLeashedTo(p_19978_, true);
                }
                $$3.shrink(1);
                return InteractionResult.sidedSuccess(this.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canCollideWith(Entity p_20303_) {
        return p_20303_.canBeCollidedWith() && !this.isPassengerOfSameVehicle(p_20303_);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3.ZERO);
        this.tick();
        if (!this.isPassenger()) {
            return;
        }
        this.getVehicle().positionRider(this);
    }

    public final void positionRider(Entity p_20312_) {
        if (!this.hasPassenger(p_20312_)) {
            return;
        }
        this.positionRider(p_20312_, Entity::setPos);
    }

    protected void positionRider(Entity p_19957_, MoveFunction p_19958_) {
        Vec3 $$2 = this.getPassengerRidingPosition(p_19957_);
        Vec3 $$3 = p_19957_.getVehicleAttachmentPoint(this);
        p_19958_.accept(p_19957_, $$2.x - $$3.x, $$2.y - $$3.y, $$2.z - $$3.z);
    }

    public void onPassengerTurned(Entity p_20320_) {
    }

    public Vec3 getVehicleAttachmentPoint(Entity p_316322_) {
        return this.getAttachments().get(EntityAttachment.VEHICLE, 0, this.yRot);
    }

    public Vec3 getPassengerRidingPosition(Entity p_294938_) {
        return this.position().add(this.getPassengerAttachmentPoint(p_294938_, this.dimensions, 1.0f));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_294756_, EntityDimensions p_295396_, float p_296362_) {
        return Entity.getDefaultPassengerAttachmentPoint(this, p_294756_, p_295396_.attachments());
    }

    protected static Vec3 getDefaultPassengerAttachmentPoint(Entity p_316557_, Entity p_316799_, EntityAttachments p_316167_) {
        int $$3 = p_316557_.getPassengers().indexOf(p_316799_);
        return p_316167_.getClamped(EntityAttachment.PASSENGER, $$3, p_316557_.yRot);
    }

    public boolean startRiding(Entity p_20330_) {
        return this.startRiding(p_20330_, false);
    }

    public boolean showVehicleHealth() {
        return this instanceof LivingEntity;
    }

    public boolean startRiding(Entity p_19966_, boolean p_19967_) {
        if (p_19966_ == this.vehicle) {
            return false;
        }
        if (!p_19966_.couldAcceptPassenger()) {
            return false;
        }
        Entity $$2 = p_19966_;
        while ($$2.vehicle != null) {
            if ($$2.vehicle == this) {
                return false;
            }
            $$2 = $$2.vehicle;
        }
        if (!(p_19967_ || this.canRide(p_19966_) && p_19966_.canAddPassenger(this))) {
            return false;
        }
        if (this.isPassenger()) {
            this.stopRiding();
        }
        this.setPose(Pose.STANDING);
        this.vehicle = p_19966_;
        this.vehicle.addPassenger(this);
        p_19966_.getIndirectPassengersStream().filter(p_185984_ -> p_185984_ instanceof ServerPlayer).forEach(p_185982_ -> CriteriaTriggers.START_RIDING_TRIGGER.trigger((ServerPlayer)p_185982_));
        return true;
    }

    protected boolean canRide(Entity p_20339_) {
        return !this.isShiftKeyDown() && this.boardingCooldown <= 0;
    }

    public void ejectPassengers() {
        for (int $$0 = this.passengers.size() - 1; $$0 >= 0; --$$0) {
            ((Entity)this.passengers.get($$0)).stopRiding();
        }
    }

    public void removeVehicle() {
        if (this.vehicle != null) {
            Entity $$0 = this.vehicle;
            this.vehicle = null;
            $$0.removePassenger(this);
        }
    }

    public void stopRiding() {
        this.removeVehicle();
    }

    protected void addPassenger(Entity p_20349_) {
        if (p_20349_.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.passengers.isEmpty()) {
            this.passengers = ImmutableList.of((Object)p_20349_);
        } else {
            ArrayList $$1 = Lists.newArrayList(this.passengers);
            if (!this.level().isClientSide && p_20349_ instanceof Player && !(this.getFirstPassenger() instanceof Player)) {
                $$1.add(0, p_20349_);
            } else {
                $$1.add(p_20349_);
            }
            this.passengers = ImmutableList.copyOf((Collection)$$1);
        }
        this.gameEvent(GameEvent.ENTITY_MOUNT, p_20349_);
    }

    protected void removePassenger(Entity p_20352_) {
        if (p_20352_.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.passengers = this.passengers.size() == 1 && this.passengers.get(0) == p_20352_ ? ImmutableList.of() : (ImmutableList)this.passengers.stream().filter(p_350857_ -> p_350857_ != p_20352_).collect(ImmutableList.toImmutableList());
        p_20352_.boardingCooldown = 60;
        this.gameEvent(GameEvent.ENTITY_DISMOUNT, p_20352_);
    }

    protected boolean canAddPassenger(Entity p_20354_) {
        return this.passengers.isEmpty();
    }

    protected boolean couldAcceptPassenger() {
        return true;
    }

    public void lerpTo(double p_19896_, double p_19897_, double p_19898_, float p_19899_, float p_19900_, int p_19901_) {
        this.setPos(p_19896_, p_19897_, p_19898_);
        this.setRot(p_19899_, p_19900_);
    }

    public double lerpTargetX() {
        return this.getX();
    }

    public double lerpTargetY() {
        return this.getY();
    }

    public double lerpTargetZ() {
        return this.getZ();
    }

    public float lerpTargetXRot() {
        return this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.getYRot();
    }

    public void lerpHeadTo(float p_19918_, int p_19919_) {
        this.setYHeadRot(p_19918_);
    }

    public float getPickRadius() {
        return 0.0f;
    }

    public Vec3 getLookAngle() {
        return this.calculateViewVector(this.getXRot(), this.getYRot());
    }

    public Vec3 getHandHoldingItemAngle(Item p_204035_) {
        Entity entity = this;
        if (entity instanceof Player) {
            Player $$1 = (Player)entity;
            boolean $$2 = $$1.getOffhandItem().is(p_204035_) && !$$1.getMainHandItem().is(p_204035_);
            HumanoidArm $$3 = $$2 ? $$1.getMainArm().getOpposite() : $$1.getMainArm();
            return this.calculateViewVector(0.0f, this.getYRot() + (float)($$3 == HumanoidArm.RIGHT ? 80 : -80)).scale(0.5);
        }
        return Vec3.ZERO;
    }

    public Vec2 getRotationVector() {
        return new Vec2(this.getXRot(), this.getYRot());
    }

    public Vec3 getForward() {
        return Vec3.directionFromRotation(this.getRotationVector());
    }

    public void setAsInsidePortal(Portal p_351060_, BlockPos p_350462_) {
        if (this.isOnPortalCooldown()) {
            this.setPortalCooldown();
            return;
        }
        if (this.portalProcess == null || !this.portalProcess.isSamePortal(p_351060_)) {
            this.portalProcess = new PortalProcessor(p_351060_, p_350462_.immutable());
        } else {
            this.portalProcess.updateEntryPosition(p_350462_.immutable());
            this.portalProcess.setAsInsidePortalThisTick(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handlePortal() {
        void $$1;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel $$0 = (ServerLevel)level;
        this.processPortalCooldown();
        if (this.portalProcess == null) {
            return;
        }
        if (this.portalProcess.processPortalTeleportation((ServerLevel)$$1, this, this.canUsePortal(false))) {
            $$1.getProfiler().push("portal");
            this.setPortalCooldown();
            DimensionTransition $$2 = this.portalProcess.getPortalDestination((ServerLevel)$$1, this);
            if ($$2 != null) {
                ServerLevel $$3 = $$2.newLevel();
                if ($$1.getServer().isLevelEnabled($$3) && ($$3.dimension() == $$1.dimension() || this.canChangeDimensions((Level)$$1, $$3))) {
                    this.changeDimension($$2);
                }
            }
            $$1.getProfiler().pop();
        } else if (this.portalProcess.hasExpired()) {
            this.portalProcess = null;
        }
    }

    public int getDimensionChangingDelay() {
        Entity $$0 = this.getFirstPassenger();
        return $$0 instanceof ServerPlayer ? $$0.getDimensionChangingDelay() : 300;
    }

    public void lerpMotion(double p_20306_, double p_20307_, double p_20308_) {
        this.setDeltaMovement(p_20306_, p_20307_, p_20308_);
    }

    public void handleDamageEvent(DamageSource p_270704_) {
    }

    public void handleEntityEvent(byte p_19882_) {
        switch (p_19882_) {
            case 53: {
                HoneyBlock.showSlideParticles(this);
            }
        }
    }

    public void animateHurt(float p_265161_) {
    }

    public boolean isOnFire() {
        boolean $$0 = this.level() != null && this.level().isClientSide;
        return !this.fireImmune() && (this.remainingFireTicks > 0 || $$0 && this.getSharedFlag(0));
    }

    public boolean isPassenger() {
        return this.getVehicle() != null;
    }

    public boolean isVehicle() {
        return !this.passengers.isEmpty();
    }

    public boolean dismountsUnderwater() {
        return this.getType().is(EntityTypeTags.DISMOUNTS_UNDERWATER);
    }

    public boolean canControlVehicle() {
        return !this.getType().is(EntityTypeTags.NON_CONTROLLING_RIDER);
    }

    public void setShiftKeyDown(boolean p_20261_) {
        this.setSharedFlag(1, p_20261_);
    }

    public boolean isShiftKeyDown() {
        return this.getSharedFlag(1);
    }

    public boolean isSteppingCarefully() {
        return this.isShiftKeyDown();
    }

    public boolean isSuppressingBounce() {
        return this.isShiftKeyDown();
    }

    public boolean isDiscrete() {
        return this.isShiftKeyDown();
    }

    public boolean isDescending() {
        return this.isShiftKeyDown();
    }

    public boolean isCrouching() {
        return this.hasPose(Pose.CROUCHING);
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean p_20274_) {
        this.setSharedFlag(3, p_20274_);
    }

    public boolean isSwimming() {
        return this.getSharedFlag(4);
    }

    public boolean isVisuallySwimming() {
        return this.hasPose(Pose.SWIMMING);
    }

    public boolean isVisuallyCrawling() {
        return this.isVisuallySwimming() && !this.isInWater();
    }

    public void setSwimming(boolean p_20283_) {
        this.setSharedFlag(4, p_20283_);
    }

    public final boolean hasGlowingTag() {
        return this.hasGlowingTag;
    }

    public final void setGlowingTag(boolean p_146916_) {
        this.hasGlowingTag = p_146916_;
        this.setSharedFlag(6, this.isCurrentlyGlowing());
    }

    public boolean isCurrentlyGlowing() {
        if (this.level().isClientSide()) {
            return this.getSharedFlag(6);
        }
        return this.hasGlowingTag;
    }

    public boolean isInvisible() {
        return this.getSharedFlag(5);
    }

    public boolean isInvisibleTo(Player p_20178_) {
        if (p_20178_.isSpectator()) {
            return false;
        }
        PlayerTeam $$1 = this.getTeam();
        if ($$1 != null && p_20178_ != null && p_20178_.getTeam() == $$1 && ((Team)$$1).canSeeFriendlyInvisibles()) {
            return false;
        }
        return this.isInvisible();
    }

    public boolean isOnRails() {
        return false;
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> p_216996_) {
    }

    @Nullable
    public PlayerTeam getTeam() {
        return this.level().getScoreboard().getPlayersTeam(this.getScoreboardName());
    }

    public boolean isAlliedTo(Entity p_20355_) {
        return this.isAlliedTo(p_20355_.getTeam());
    }

    public boolean isAlliedTo(Team p_20032_) {
        if (this.getTeam() != null) {
            return this.getTeam().isAlliedTo(p_20032_);
        }
        return false;
    }

    public void setInvisible(boolean p_20304_) {
        this.setSharedFlag(5, p_20304_);
    }

    protected boolean getSharedFlag(int p_20292_) {
        return (this.entityData.get(DATA_SHARED_FLAGS_ID) & 1 << p_20292_) != 0;
    }

    protected void setSharedFlag(int p_20116_, boolean p_20117_) {
        byte $$2 = this.entityData.get(DATA_SHARED_FLAGS_ID);
        if (p_20117_) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)($$2 | 1 << p_20116_));
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (byte)($$2 & ~(1 << p_20116_)));
        }
    }

    public int getMaxAirSupply() {
        return 300;
    }

    public int getAirSupply() {
        return this.entityData.get(DATA_AIR_SUPPLY_ID);
    }

    public void setAirSupply(int p_20302_) {
        this.entityData.set(DATA_AIR_SUPPLY_ID, p_20302_);
    }

    public int getTicksFrozen() {
        return this.entityData.get(DATA_TICKS_FROZEN);
    }

    public void setTicksFrozen(int p_146918_) {
        this.entityData.set(DATA_TICKS_FROZEN, p_146918_);
    }

    public float getPercentFrozen() {
        int $$0 = this.getTicksRequiredToFreeze();
        return (float)Math.min(this.getTicksFrozen(), $$0) / (float)$$0;
    }

    public boolean isFullyFrozen() {
        return this.getTicksFrozen() >= this.getTicksRequiredToFreeze();
    }

    public int getTicksRequiredToFreeze() {
        return 140;
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        this.setRemainingFireTicks(this.remainingFireTicks + 1);
        if (this.remainingFireTicks == 0) {
            this.igniteForSeconds(8.0f);
        }
        this.hurt(this.damageSources().lightningBolt(), 5.0f);
    }

    public void onAboveBubbleCol(boolean p_20313_) {
        double $$3;
        Vec3 $$1 = this.getDeltaMovement();
        if (p_20313_) {
            double $$2 = Math.max(-0.9, $$1.y - 0.03);
        } else {
            $$3 = Math.min(1.8, $$1.y + 0.1);
        }
        this.setDeltaMovement($$1.x, $$3, $$1.z);
    }

    public void onInsideBubbleColumn(boolean p_20322_) {
        double $$3;
        Vec3 $$1 = this.getDeltaMovement();
        if (p_20322_) {
            double $$2 = Math.max(-0.3, $$1.y - 0.03);
        } else {
            $$3 = Math.min(0.7, $$1.y + 0.06);
        }
        this.setDeltaMovement($$1.x, $$3, $$1.z);
        this.resetFallDistance();
    }

    public boolean killedEntity(ServerLevel p_216988_, LivingEntity p_216989_) {
        return true;
    }

    public void checkSlowFallDistance() {
        if (this.getDeltaMovement().y() > -0.5 && this.fallDistance > 1.0f) {
            this.fallDistance = 1.0f;
        }
    }

    public void resetFallDistance() {
        this.fallDistance = 0.0f;
    }

    protected void moveTowardsClosestSpace(double p_20315_, double p_20316_, double p_20317_) {
        BlockPos $$3 = BlockPos.containing(p_20315_, p_20316_, p_20317_);
        Vec3 $$4 = new Vec3(p_20315_ - (double)$$3.getX(), p_20316_ - (double)$$3.getY(), p_20317_ - (double)$$3.getZ());
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        Direction $$6 = Direction.UP;
        double $$7 = Double.MAX_VALUE;
        for (Direction $$8 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double $$10;
            $$5.setWithOffset((Vec3i)$$3, $$8);
            if (this.level().getBlockState($$5).isCollisionShapeFullBlock(this.level(), $$5)) continue;
            double $$9 = $$4.get($$8.getAxis());
            double d = $$10 = $$8.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - $$9 : $$9;
            if (!($$10 < $$7)) continue;
            $$7 = $$10;
            $$6 = $$8;
        }
        float $$11 = this.random.nextFloat() * 0.2f + 0.1f;
        float $$12 = $$6.getAxisDirection().getStep();
        Vec3 $$13 = this.getDeltaMovement().scale(0.75);
        if ($$6.getAxis() == Direction.Axis.X) {
            this.setDeltaMovement($$12 * $$11, $$13.y, $$13.z);
        } else if ($$6.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement($$13.x, $$12 * $$11, $$13.z);
        } else if ($$6.getAxis() == Direction.Axis.Z) {
            this.setDeltaMovement($$13.x, $$13.y, $$12 * $$11);
        }
    }

    public void makeStuckInBlock(BlockState p_20006_, Vec3 p_20007_) {
        this.resetFallDistance();
        this.stuckSpeedMultiplier = p_20007_;
    }

    private static Component removeAction(Component p_20141_) {
        MutableComponent $$1 = p_20141_.plainCopy().setStyle(p_20141_.getStyle().withClickEvent(null));
        for (Component $$2 : p_20141_.getSiblings()) {
            $$1.append(Entity.removeAction($$2));
        }
        return $$1;
    }

    @Override
    public Component getName() {
        Component $$0 = this.getCustomName();
        if ($$0 != null) {
            return Entity.removeAction($$0);
        }
        return this.getTypeName();
    }

    protected Component getTypeName() {
        return this.type.getDescription();
    }

    public boolean is(Entity p_20356_) {
        return this == p_20356_;
    }

    public float getYHeadRot() {
        return 0.0f;
    }

    public void setYHeadRot(float p_20328_) {
    }

    public void setYBodyRot(float p_20338_) {
    }

    public boolean isAttackable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity p_20357_) {
        return false;
    }

    public String toString() {
        String $$0;
        String string = $$0 = this.level() == null ? "~NULL~" : this.level().toString();
        if (this.removalReason != null) {
            return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.id, $$0, this.getX(), this.getY(), this.getZ(), this.removalReason});
        }
        return String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getName().getString(), this.id, $$0, this.getX(), this.getY(), this.getZ());
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        return this.isRemoved() || this.invulnerable && !p_20122_.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !p_20122_.isCreativePlayer() || p_20122_.is(DamageTypeTags.IS_FIRE) && this.fireImmune() || p_20122_.is(DamageTypeTags.IS_FALL) && this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean p_20332_) {
        this.invulnerable = p_20332_;
    }

    public void copyPosition(Entity p_20360_) {
        this.moveTo(p_20360_.getX(), p_20360_.getY(), p_20360_.getZ(), p_20360_.getYRot(), p_20360_.getXRot());
    }

    public void restoreFrom(Entity p_20362_) {
        CompoundTag $$1 = p_20362_.saveWithoutId(new CompoundTag());
        $$1.remove("Dimension");
        this.load($$1);
        this.portalCooldown = p_20362_.portalCooldown;
        this.portalProcess = p_20362_.portalProcess;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Entity changeDimension(DimensionTransition p_350951_) {
        Entity $$8;
        void $$2;
        block9: {
            block8: {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block8;
                ServerLevel $$1 = (ServerLevel)level;
                if (!this.isRemoved()) break block9;
            }
            return null;
        }
        ServerLevel $$3 = p_350951_.newLevel();
        List<Entity> $$4 = this.getPassengers();
        this.unRide();
        ArrayList<Entity> $$5 = new ArrayList<Entity>();
        for (Entity $$6 : $$4) {
            Entity $$7 = $$6.changeDimension(p_350951_);
            if ($$7 == null) continue;
            $$5.add($$7);
        }
        $$2.getProfiler().push("changeDimension");
        Entity entity = $$8 = $$3.dimension() == $$2.dimension() ? this : this.getType().create($$3);
        if ($$8 != null) {
            if (this != $$8) {
                $$8.restoreFrom(this);
                this.removeAfterChangingDimensions();
            }
            $$8.moveTo(p_350951_.pos().x, p_350951_.pos().y, p_350951_.pos().z, p_350951_.yRot(), $$8.getXRot());
            $$8.setDeltaMovement(p_350951_.speed());
            if (this != $$8) {
                $$3.addDuringTeleport($$8);
            }
            for (Entity $$9 : $$5) {
                $$9.startRiding($$8, true);
            }
            $$2.resetEmptyTime();
            $$3.resetEmptyTime();
            p_350951_.postDimensionTransition().onTransition($$8);
        }
        $$2.getProfiler().pop();
        return $$8;
    }

    public void placePortalTicket(BlockPos p_352083_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel $$1 = (ServerLevel)level;
            $$1.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(p_352083_), 3, p_352083_);
        }
    }

    protected void removeAfterChangingDimensions() {
        this.setRemoved(RemovalReason.CHANGED_DIMENSION);
        Entity entity = this;
        if (entity instanceof Leashable) {
            Leashable $$0 = (Leashable)((Object)entity);
            $$0.dropLeash(true, false);
        }
    }

    public Vec3 getRelativePortalPosition(Direction.Axis p_20045_, BlockUtil.FoundRectangle p_20046_) {
        return PortalShape.getRelativePosition(p_20046_, p_20045_, this.position(), this.getDimensions(this.getPose()));
    }

    public boolean canUsePortal(boolean p_352898_) {
        return (p_352898_ || !this.isPassenger()) && this.isAlive();
    }

    public boolean canChangeDimensions(Level p_352904_, Level p_352909_) {
        return true;
    }

    public float getBlockExplosionResistance(Explosion p_19992_, BlockGetter p_19993_, BlockPos p_19994_, BlockState p_19995_, FluidState p_19996_, float p_19997_) {
        return p_19997_;
    }

    public boolean shouldBlockExplode(Explosion p_19987_, BlockGetter p_19988_, BlockPos p_19989_, BlockState p_19990_, float p_19991_) {
        return true;
    }

    public int getMaxFallDistance() {
        return 3;
    }

    public boolean isIgnoringBlockTriggers() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory p_20051_) {
        p_20051_.setDetail("Entity Type", () -> String.valueOf(EntityType.getKey(this.getType())) + " (" + this.getClass().getCanonicalName() + ")");
        p_20051_.setDetail("Entity ID", this.id);
        p_20051_.setDetail("Entity Name", () -> this.getName().getString());
        p_20051_.setDetail("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.getX(), this.getY(), this.getZ()));
        p_20051_.setDetail("Entity's Block location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level(), Mth.floor(this.getX()), Mth.floor(this.getY()), Mth.floor(this.getZ())));
        Vec3 $$1 = this.getDeltaMovement();
        p_20051_.setDetail("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", $$1.x, $$1.y, $$1.z));
        p_20051_.setDetail("Entity's Passengers", () -> this.getPassengers().toString());
        p_20051_.setDetail("Entity's Vehicle", () -> String.valueOf(this.getVehicle()));
    }

    public boolean displayFireAnimation() {
        return this.isOnFire() && !this.isSpectator();
    }

    public void setUUID(UUID p_20085_) {
        this.uuid = p_20085_;
        this.stringUUID = this.uuid.toString();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public String getStringUUID() {
        return this.stringUUID;
    }

    @Override
    public String getScoreboardName() {
        return this.stringUUID;
    }

    public boolean isPushedByFluid() {
        return true;
    }

    public static double getViewScale() {
        return viewScale;
    }

    public static void setViewScale(double p_20104_) {
        viewScale = p_20104_;
    }

    @Override
    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam(this.getTeam(), this.getName()).withStyle(p_185975_ -> p_185975_.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()));
    }

    public void setCustomName(@Nullable Component p_20053_) {
        this.entityData.set(DATA_CUSTOM_NAME, Optional.ofNullable(p_20053_));
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).orElse(null);
    }

    @Override
    public boolean hasCustomName() {
        return this.entityData.get(DATA_CUSTOM_NAME).isPresent();
    }

    public void setCustomNameVisible(boolean p_20341_) {
        this.entityData.set(DATA_CUSTOM_NAME_VISIBLE, p_20341_);
    }

    public boolean isCustomNameVisible() {
        return this.entityData.get(DATA_CUSTOM_NAME_VISIBLE);
    }

    public boolean teleportTo(ServerLevel p_265257_, double p_265407_, double p_265727_, double p_265410_, Set<RelativeMovement> p_265083_, float p_265573_, float p_265094_) {
        float $$7 = Mth.clamp(p_265094_, -90.0f, 90.0f);
        if (p_265257_ == this.level()) {
            this.moveTo(p_265407_, p_265727_, p_265410_, p_265573_, $$7);
            this.teleportPassengers();
            this.setYHeadRot(p_265573_);
        } else {
            this.unRide();
            Object $$8 = this.getType().create(p_265257_);
            if ($$8 != null) {
                ((Entity)$$8).restoreFrom(this);
                ((Entity)$$8).moveTo(p_265407_, p_265727_, p_265410_, p_265573_, $$7);
                ((Entity)$$8).setYHeadRot(p_265573_);
                this.setRemoved(RemovalReason.CHANGED_DIMENSION);
                p_265257_.addDuringTeleport((Entity)$$8);
            } else {
                return false;
            }
        }
        return true;
    }

    public void dismountTo(double p_146825_, double p_146826_, double p_146827_) {
        this.teleportTo(p_146825_, p_146826_, p_146827_);
    }

    public void teleportTo(double p_19887_, double p_19888_, double p_19889_) {
        if (!(this.level() instanceof ServerLevel)) {
            return;
        }
        this.moveTo(p_19887_, p_19888_, p_19889_, this.getYRot(), this.getXRot());
        this.teleportPassengers();
    }

    private void teleportPassengers() {
        this.getSelfAndPassengers().forEach(p_185977_ -> {
            for (Entity $$1 : p_185977_.passengers) {
                p_185977_.positionRider($$1, Entity::moveTo);
            }
        });
    }

    public void teleportRelative(double p_249341_, double p_252229_, double p_252038_) {
        this.teleportTo(this.getX() + p_249341_, this.getY() + p_252229_, this.getZ() + p_252038_);
    }

    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    @Override
    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> p_270372_) {
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_20059_) {
        if (DATA_POSE.equals(p_20059_)) {
            this.refreshDimensions();
        }
    }

    @Deprecated
    protected void fixupDimensions() {
        EntityDimensions $$1;
        Pose $$0 = this.getPose();
        this.dimensions = $$1 = this.getDimensions($$0);
        this.eyeHeight = $$1.eyeHeight();
    }

    public void refreshDimensions() {
        boolean $$3;
        EntityDimensions $$2;
        EntityDimensions $$0 = this.dimensions;
        Pose $$1 = this.getPose();
        this.dimensions = $$2 = this.getDimensions($$1);
        this.eyeHeight = $$2.eyeHeight();
        this.reapplyPosition();
        boolean bl = $$3 = (double)$$2.width() <= 4.0 && (double)$$2.height() <= 4.0;
        if (!(this.level.isClientSide || this.firstTick || this.noPhysics || !$$3 || !($$2.width() > $$0.width()) && !($$2.height() > $$0.height()) || this instanceof Player)) {
            this.fudgePositionAfterSizeChange($$0);
        }
    }

    public boolean fudgePositionAfterSizeChange(EntityDimensions p_347526_) {
        VoxelShape $$7;
        Optional<Vec3> $$8;
        double $$4;
        double $$3;
        EntityDimensions $$1 = this.getDimensions(this.getPose());
        Vec3 $$2 = this.position().add(0.0, (double)p_347526_.height() / 2.0, 0.0);
        VoxelShape $$5 = Shapes.create(AABB.ofSize($$2, $$3 = (double)Math.max(0.0f, $$1.width() - p_347526_.width()) + 1.0E-6, $$4 = (double)Math.max(0.0f, $$1.height() - p_347526_.height()) + 1.0E-6, $$3));
        Optional<Vec3> $$6 = this.level.findFreePosition(this, $$5, $$2, $$1.width(), $$1.height(), $$1.width());
        if ($$6.isPresent()) {
            this.setPos($$6.get().add(0.0, (double)(-$$1.height()) / 2.0, 0.0));
            return true;
        }
        if ($$1.width() > p_347526_.width() && $$1.height() > p_347526_.height() && ($$8 = this.level.findFreePosition(this, $$7 = Shapes.create(AABB.ofSize($$2, $$3, 1.0E-6, $$3)), $$2, $$1.width(), p_347526_.height(), $$1.width())).isPresent()) {
            this.setPos($$8.get().add(0.0, (double)(-p_347526_.height()) / 2.0 + 1.0E-6, 0.0));
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return Direction.fromYRot(this.getYRot());
    }

    public Direction getMotionDirection() {
        return this.getDirection();
    }

    protected HoverEvent createHoverEvent() {
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityTooltipInfo(this.getType(), this.getUUID(), this.getName()));
    }

    public boolean broadcastToPlayer(ServerPlayer p_19937_) {
        return true;
    }

    @Override
    public final AABB getBoundingBox() {
        return this.bb;
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox();
    }

    public final void setBoundingBox(AABB p_20012_) {
        this.bb = p_20012_;
    }

    public final float getEyeHeight(Pose p_20237_) {
        return this.getDimensions(p_20237_).eyeHeight();
    }

    public final float getEyeHeight() {
        return this.eyeHeight;
    }

    public Vec3 getLeashOffset(float p_249286_) {
        return this.getLeashOffset();
    }

    protected Vec3 getLeashOffset() {
        return new Vec3(0.0, this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public SlotAccess getSlot(int p_146919_) {
        return SlotAccess.NULL;
    }

    @Override
    public void sendSystemMessage(Component p_216998_) {
    }

    public Level getCommandSenderWorld() {
        return this.level();
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level().getServer();
    }

    public InteractionResult interactAt(Player p_19980_, Vec3 p_19981_, InteractionHand p_19982_) {
        return InteractionResult.PASS;
    }

    public boolean ignoreExplosion(Explosion p_312868_) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer p_20119_) {
    }

    public void stopSeenByPlayer(ServerPlayer p_20174_) {
    }

    public float rotate(Rotation p_20004_) {
        float $$1 = Mth.wrapDegrees(this.getYRot());
        switch (p_20004_) {
            case CLOCKWISE_180: {
                return $$1 + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return $$1 + 270.0f;
            }
            case CLOCKWISE_90: {
                return $$1 + 90.0f;
            }
        }
        return $$1;
    }

    public float mirror(Mirror p_20003_) {
        float $$1 = Mth.wrapDegrees(this.getYRot());
        switch (p_20003_) {
            case FRONT_BACK: {
                return -$$1;
            }
            case LEFT_RIGHT: {
                return 180.0f - $$1;
            }
        }
        return $$1;
    }

    public boolean onlyOpCanSetNbt() {
        return false;
    }

    public ProjectileDeflection deflection(Projectile p_319824_) {
        return this.getType().is(EntityTypeTags.DEFLECTS_PROJECTILES) ? ProjectileDeflection.REVERSE : ProjectileDeflection.NONE;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    public final boolean hasControllingPassenger() {
        return this.getControllingPassenger() != null;
    }

    public final List<Entity> getPassengers() {
        return this.passengers;
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.passengers.isEmpty() ? null : (Entity)this.passengers.get(0);
    }

    public boolean hasPassenger(Entity p_20364_) {
        return this.passengers.contains((Object)p_20364_);
    }

    public boolean hasPassenger(Predicate<Entity> p_146863_) {
        for (Entity $$1 : this.passengers) {
            if (!p_146863_.test($$1)) continue;
            return true;
        }
        return false;
    }

    private Stream<Entity> getIndirectPassengersStream() {
        return this.passengers.stream().flatMap(Entity::getSelfAndPassengers);
    }

    public Stream<Entity> getSelfAndPassengers() {
        return Stream.concat(Stream.of(this), this.getIndirectPassengersStream());
    }

    public Stream<Entity> getPassengersAndSelf() {
        return Stream.concat(this.passengers.stream().flatMap(Entity::getPassengersAndSelf), Stream.of(this));
    }

    public Iterable<Entity> getIndirectPassengers() {
        return () -> this.getIndirectPassengersStream().iterator();
    }

    public int countPlayerPassengers() {
        return (int)this.getIndirectPassengersStream().filter(p_185943_ -> p_185943_ instanceof Player).count();
    }

    public boolean hasExactlyOnePlayerPassenger() {
        return this.countPlayerPassengers() == 1;
    }

    public Entity getRootVehicle() {
        Entity $$0 = this;
        while ($$0.isPassenger()) {
            $$0 = $$0.getVehicle();
        }
        return $$0;
    }

    public boolean isPassengerOfSameVehicle(Entity p_20366_) {
        return this.getRootVehicle() == p_20366_.getRootVehicle();
    }

    public boolean hasIndirectPassenger(Entity p_20368_) {
        if (!p_20368_.isPassenger()) {
            return false;
        }
        Entity $$1 = p_20368_.getVehicle();
        if ($$1 == this) {
            return true;
        }
        return this.hasIndirectPassenger($$1);
    }

    public boolean isControlledByLocalInstance() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player $$0 = (Player)livingEntity;
            return $$0.isLocalPlayer();
        }
        return this.isEffectiveAi();
    }

    public boolean isEffectiveAi() {
        return !this.level().isClientSide;
    }

    protected static Vec3 getCollisionHorizontalEscapeVector(double p_19904_, double p_19905_, float p_19906_) {
        double $$3 = (p_19904_ + p_19905_ + (double)1.0E-5f) / 2.0;
        float $$4 = -Mth.sin(p_19906_ * ((float)Math.PI / 180));
        float $$5 = Mth.cos(p_19906_ * ((float)Math.PI / 180));
        float $$6 = Math.max(Math.abs($$4), Math.abs($$5));
        return new Vec3((double)$$4 * $$3 / (double)$$6, 0.0, (double)$$5 * $$3 / (double)$$6);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity p_20123_) {
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public Entity getVehicle() {
        return this.vehicle;
    }

    @Nullable
    public Entity getControlledVehicle() {
        return this.vehicle != null && this.vehicle.getControllingPassenger() == this ? this.vehicle : null;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.NORMAL;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    protected int getFireImmuneTicks() {
        return 1;
    }

    public CommandSourceStack createCommandSourceStack() {
        return new CommandSourceStack(this, this.position(), this.getRotationVector(), this.level() instanceof ServerLevel ? (ServerLevel)this.level() : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.level().getServer(), this);
    }

    protected int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int p_20311_) {
        return this.getPermissionLevel() >= p_20311_;
    }

    @Override
    public boolean acceptsSuccess() {
        return this.level().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return true;
    }

    public void lookAt(EntityAnchorArgument.Anchor p_20033_, Vec3 p_20034_) {
        Vec3 $$2 = p_20033_.apply(this);
        double $$3 = p_20034_.x - $$2.x;
        double $$4 = p_20034_.y - $$2.y;
        double $$5 = p_20034_.z - $$2.z;
        double $$6 = Math.sqrt($$3 * $$3 + $$5 * $$5);
        this.setXRot(Mth.wrapDegrees((float)(-(Mth.atan2($$4, $$6) * 57.2957763671875))));
        this.setYRot(Mth.wrapDegrees((float)(Mth.atan2($$5, $$3) * 57.2957763671875) - 90.0f));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getPreciseBodyRotation(float p_352259_) {
        return Mth.lerp(p_352259_, this.yRotO, this.yRot);
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> p_204032_, double p_204033_) {
        if (this.touchingUnloadedChunk()) {
            return false;
        }
        AABB $$2 = this.getBoundingBox().deflate(0.001);
        int $$3 = Mth.floor($$2.minX);
        int $$4 = Mth.ceil($$2.maxX);
        int $$5 = Mth.floor($$2.minY);
        int $$6 = Mth.ceil($$2.maxY);
        int $$7 = Mth.floor($$2.minZ);
        int $$8 = Mth.ceil($$2.maxZ);
        double $$9 = 0.0;
        boolean $$10 = this.isPushedByFluid();
        boolean $$11 = false;
        Vec3 $$12 = Vec3.ZERO;
        int $$13 = 0;
        BlockPos.MutableBlockPos $$14 = new BlockPos.MutableBlockPos();
        for (int $$15 = $$3; $$15 < $$4; ++$$15) {
            for (int $$16 = $$5; $$16 < $$6; ++$$16) {
                for (int $$17 = $$7; $$17 < $$8; ++$$17) {
                    double $$19;
                    $$14.set($$15, $$16, $$17);
                    FluidState $$18 = this.level().getFluidState($$14);
                    if (!$$18.is(p_204032_) || !(($$19 = (double)((float)$$16 + $$18.getHeight(this.level(), $$14))) >= $$2.minY)) continue;
                    $$11 = true;
                    $$9 = Math.max($$19 - $$2.minY, $$9);
                    if (!$$10) continue;
                    Vec3 $$20 = $$18.getFlow(this.level(), $$14);
                    if ($$9 < 0.4) {
                        $$20 = $$20.scale($$9);
                    }
                    $$12 = $$12.add($$20);
                    ++$$13;
                }
            }
        }
        if ($$12.length() > 0.0) {
            if ($$13 > 0) {
                $$12 = $$12.scale(1.0 / (double)$$13);
            }
            if (!(this instanceof Player)) {
                $$12 = $$12.normalize();
            }
            Vec3 $$21 = this.getDeltaMovement();
            $$12 = $$12.scale(p_204033_);
            double $$22 = 0.003;
            if (Math.abs($$21.x) < 0.003 && Math.abs($$21.z) < 0.003 && $$12.length() < 0.0045000000000000005) {
                $$12 = $$12.normalize().scale(0.0045000000000000005);
            }
            this.setDeltaMovement(this.getDeltaMovement().add($$12));
        }
        this.fluidHeight.put(p_204032_, $$9);
        return $$11;
    }

    public boolean touchingUnloadedChunk() {
        AABB $$0 = this.getBoundingBox().inflate(1.0);
        int $$1 = Mth.floor($$0.minX);
        int $$2 = Mth.ceil($$0.maxX);
        int $$3 = Mth.floor($$0.minZ);
        int $$4 = Mth.ceil($$0.maxZ);
        return !this.level().hasChunksAt($$1, $$3, $$2, $$4);
    }

    public double getFluidHeight(TagKey<Fluid> p_204037_) {
        return this.fluidHeight.getDouble(p_204037_);
    }

    public double getFluidJumpThreshold() {
        return (double)this.getEyeHeight() < 0.4 ? 0.0 : 0.4;
    }

    public final float getBbWidth() {
        return this.dimensions.width();
    }

    public final float getBbHeight() {
        return this.dimensions.height();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352110_) {
        return new ClientboundAddEntityPacket(this, p_352110_);
    }

    public EntityDimensions getDimensions(Pose p_19975_) {
        return this.type.getDimensions();
    }

    public final EntityAttachments getAttachments() {
        return this.dimensions.attachments();
    }

    public Vec3 position() {
        return this.position;
    }

    public Vec3 trackingPosition() {
        return this.position();
    }

    @Override
    public BlockPos blockPosition() {
        return this.blockPosition;
    }

    public BlockState getInBlockState() {
        if (this.inBlockState == null) {
            this.inBlockState = this.level().getBlockState(this.blockPosition());
        }
        return this.inBlockState;
    }

    public ChunkPos chunkPosition() {
        return this.chunkPosition;
    }

    public Vec3 getDeltaMovement() {
        return this.deltaMovement;
    }

    public void setDeltaMovement(Vec3 p_20257_) {
        this.deltaMovement = p_20257_;
    }

    public void addDeltaMovement(Vec3 p_250128_) {
        this.setDeltaMovement(this.getDeltaMovement().add(p_250128_));
    }

    public void setDeltaMovement(double p_20335_, double p_20336_, double p_20337_) {
        this.setDeltaMovement(new Vec3(p_20335_, p_20336_, p_20337_));
    }

    public final int getBlockX() {
        return this.blockPosition.getX();
    }

    public final double getX() {
        return this.position.x;
    }

    public double getX(double p_20166_) {
        return this.position.x + (double)this.getBbWidth() * p_20166_;
    }

    public double getRandomX(double p_20209_) {
        return this.getX((2.0 * this.random.nextDouble() - 1.0) * p_20209_);
    }

    public final int getBlockY() {
        return this.blockPosition.getY();
    }

    public final double getY() {
        return this.position.y;
    }

    public double getY(double p_20228_) {
        return this.position.y + (double)this.getBbHeight() * p_20228_;
    }

    public double getRandomY() {
        return this.getY(this.random.nextDouble());
    }

    public double getEyeY() {
        return this.position.y + (double)this.eyeHeight;
    }

    public final int getBlockZ() {
        return this.blockPosition.getZ();
    }

    public final double getZ() {
        return this.position.z;
    }

    public double getZ(double p_20247_) {
        return this.position.z + (double)this.getBbWidth() * p_20247_;
    }

    public double getRandomZ(double p_20263_) {
        return this.getZ((2.0 * this.random.nextDouble() - 1.0) * p_20263_);
    }

    public final void setPosRaw(double p_20344_, double p_20345_, double p_20346_) {
        if (this.position.x != p_20344_ || this.position.y != p_20345_ || this.position.z != p_20346_) {
            this.position = new Vec3(p_20344_, p_20345_, p_20346_);
            int $$3 = Mth.floor(p_20344_);
            int $$4 = Mth.floor(p_20345_);
            int $$5 = Mth.floor(p_20346_);
            if ($$3 != this.blockPosition.getX() || $$4 != this.blockPosition.getY() || $$5 != this.blockPosition.getZ()) {
                this.blockPosition = new BlockPos($$3, $$4, $$5);
                this.inBlockState = null;
                if (SectionPos.blockToSectionCoord($$3) != this.chunkPosition.x || SectionPos.blockToSectionCoord($$5) != this.chunkPosition.z) {
                    this.chunkPosition = new ChunkPos(this.blockPosition);
                }
            }
            this.levelCallback.onMove();
        }
    }

    public void checkDespawn() {
    }

    public Vec3 getRopeHoldPosition(float p_20347_) {
        return this.getPosition(p_20347_).add(0.0, (double)this.eyeHeight * 0.7, 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_146866_) {
        int $$1 = p_146866_.getId();
        double $$2 = p_146866_.getX();
        double $$3 = p_146866_.getY();
        double $$4 = p_146866_.getZ();
        this.syncPacketPositionCodec($$2, $$3, $$4);
        this.moveTo($$2, $$3, $$4);
        this.setXRot(p_146866_.getXRot());
        this.setYRot(p_146866_.getYRot());
        this.setId($$1);
        this.setUUID(p_146866_.getUUID());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void setIsInPowderSnow(boolean p_146925_) {
        this.isInPowderSnow = p_146925_;
    }

    public boolean canFreeze() {
        return !this.getType().is(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES);
    }

    public boolean isFreezing() {
        return (this.isInPowderSnow || this.wasInPowderSnow) && this.canFreeze();
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }

    public void setYRot(float p_146923_) {
        if (!Float.isFinite(p_146923_)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + p_146923_ + ", discarding.");
            return;
        }
        this.yRot = p_146923_;
    }

    public float getXRot() {
        return this.xRot;
    }

    public void setXRot(float p_146927_) {
        if (!Float.isFinite(p_146927_)) {
            Util.logAndPauseIfInIde("Invalid entity rotation: " + p_146927_ + ", discarding.");
            return;
        }
        this.xRot = p_146927_;
    }

    public boolean canSprint() {
        return false;
    }

    public float maxUpStep() {
        return 0.0f;
    }

    public void onExplosionHit(@Nullable Entity p_326352_) {
    }

    public final boolean isRemoved() {
        return this.removalReason != null;
    }

    @Nullable
    public RemovalReason getRemovalReason() {
        return this.removalReason;
    }

    @Override
    public final void setRemoved(RemovalReason p_146876_) {
        if (this.removalReason == null) {
            this.removalReason = p_146876_;
        }
        if (this.removalReason.shouldDestroy()) {
            this.stopRiding();
        }
        this.getPassengers().forEach(Entity::stopRiding);
        this.levelCallback.onRemove(p_146876_);
    }

    protected void unsetRemoved() {
        this.removalReason = null;
    }

    @Override
    public void setLevelCallback(EntityInLevelCallback p_146849_) {
        this.levelCallback = p_146849_;
    }

    @Override
    public boolean shouldBeSaved() {
        if (this.removalReason != null && !this.removalReason.shouldSave()) {
            return false;
        }
        if (this.isPassenger()) {
            return false;
        }
        return !this.isVehicle() || !this.hasExactlyOnePlayerPassenger();
    }

    @Override
    public boolean isAlwaysTicking() {
        return false;
    }

    public boolean mayInteract(Level p_146843_, BlockPos p_146844_) {
        return true;
    }

    public Level level() {
        return this.level;
    }

    protected void setLevel(Level p_285201_) {
        this.level = p_285201_;
    }

    public DamageSources damageSources() {
        return this.level().damageSources();
    }

    public RegistryAccess registryAccess() {
        return this.level().registryAccess();
    }

    protected void lerpPositionAndRotationStep(int p_294824_, double p_296038_, double p_294518_, double p_294658_, double p_294681_, double p_295540_) {
        double $$6 = 1.0 / (double)p_294824_;
        double $$7 = Mth.lerp($$6, this.getX(), p_296038_);
        double $$8 = Mth.lerp($$6, this.getY(), p_294518_);
        double $$9 = Mth.lerp($$6, this.getZ(), p_294658_);
        float $$10 = (float)Mth.rotLerp($$6, (double)this.getYRot(), p_294681_);
        float $$11 = (float)Mth.lerp($$6, (double)this.getXRot(), p_295540_);
        this.setPos($$7, $$8, $$9);
        this.setRot($$10, $$11);
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public Vec3 getKnownMovement() {
        LivingEntity livingEntity = this.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player $$0 = (Player)livingEntity;
            if (this.isAlive()) {
                return $$0.getKnownMovement();
            }
        }
        return this.getDeltaMovement();
    }

    @Nullable
    public ItemStack getWeaponItem() {
        return null;
    }

    public static enum RemovalReason {
        KILLED(true, false),
        DISCARDED(true, false),
        UNLOADED_TO_CHUNK(false, true),
        UNLOADED_WITH_PLAYER(false, false),
        CHANGED_DIMENSION(false, false);

        private final boolean destroy;
        private final boolean save;

        private RemovalReason(boolean p_146963_, boolean p_146964_) {
            this.destroy = p_146963_;
            this.save = p_146964_;
        }

        public boolean shouldDestroy() {
            return this.destroy;
        }

        public boolean shouldSave() {
            return this.save;
        }
    }

    public static enum MovementEmission {
        NONE(false, false),
        SOUNDS(true, false),
        EVENTS(false, true),
        ALL(true, true);

        final boolean sounds;
        final boolean events;

        private MovementEmission(boolean p_146942_, boolean p_146943_) {
            this.sounds = p_146942_;
            this.events = p_146943_;
        }

        public boolean emitsAnything() {
            return this.events || this.sounds;
        }

        public boolean emitsEvents() {
            return this.events;
        }

        public boolean emitsSounds() {
            return this.sounds;
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }
}

