/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class SortedArraySet<T>
extends AbstractSet<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Comparator<T> comparator;
    T[] contents;
    int size;

    private SortedArraySet(int p_14244_, Comparator<T> p_14245_) {
        this.comparator = p_14245_;
        if (p_14244_ < 0) {
            throw new IllegalArgumentException("Initial capacity (" + p_14244_ + ") is negative");
        }
        this.contents = SortedArraySet.castRawArray(new Object[p_14244_]);
    }

    public static <T extends Comparable<T>> SortedArraySet<T> create() {
        return SortedArraySet.create(10);
    }

    public static <T extends Comparable<T>> SortedArraySet<T> create(int p_14247_) {
        return new SortedArraySet(p_14247_, Comparator.naturalOrder());
    }

    public static <T> SortedArraySet<T> create(Comparator<T> p_144977_) {
        return SortedArraySet.create(p_144977_, 10);
    }

    public static <T> SortedArraySet<T> create(Comparator<T> p_144979_, int p_144980_) {
        return new SortedArraySet<T>(p_144980_, p_144979_);
    }

    private static <T> T[] castRawArray(Object[] p_14259_) {
        return p_14259_;
    }

    private int findIndex(T p_14270_) {
        return Arrays.binarySearch(this.contents, 0, this.size, p_14270_, this.comparator);
    }

    private static int getInsertionPosition(int p_14264_) {
        return -p_14264_ - 1;
    }

    @Override
    public boolean add(T p_14261_) {
        int $$1 = this.findIndex(p_14261_);
        if ($$1 >= 0) {
            return false;
        }
        int $$2 = SortedArraySet.getInsertionPosition($$1);
        this.addInternal(p_14261_, $$2);
        return true;
    }

    private void grow(int p_14268_) {
        if (p_14268_ <= this.contents.length) {
            return;
        }
        if (this.contents != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
            p_14268_ = (int)Math.max(Math.min((long)this.contents.length + (long)(this.contents.length >> 1), 0x7FFFFFF7L), (long)p_14268_);
        } else if (p_14268_ < 10) {
            p_14268_ = 10;
        }
        Object[] $$1 = new Object[p_14268_];
        System.arraycopy(this.contents, 0, $$1, 0, this.size);
        this.contents = SortedArraySet.castRawArray($$1);
    }

    private void addInternal(T p_14256_, int p_14257_) {
        this.grow(this.size + 1);
        if (p_14257_ != this.size) {
            System.arraycopy(this.contents, p_14257_, this.contents, p_14257_ + 1, this.size - p_14257_);
        }
        this.contents[p_14257_] = p_14256_;
        ++this.size;
    }

    void removeInternal(int p_14275_) {
        --this.size;
        if (p_14275_ != this.size) {
            System.arraycopy(this.contents, p_14275_ + 1, this.contents, p_14275_, this.size - p_14275_);
        }
        this.contents[this.size] = null;
    }

    private T getInternal(int p_14277_) {
        return this.contents[p_14277_];
    }

    public T addOrGet(T p_14254_) {
        int $$1 = this.findIndex(p_14254_);
        if ($$1 >= 0) {
            return this.getInternal($$1);
        }
        this.addInternal(p_14254_, SortedArraySet.getInsertionPosition($$1));
        return p_14254_;
    }

    @Override
    public boolean remove(Object p_14282_) {
        int $$1 = this.findIndex(p_14282_);
        if ($$1 >= 0) {
            this.removeInternal($$1);
            return true;
        }
        return false;
    }

    @Nullable
    public T get(T p_144982_) {
        int $$1 = this.findIndex(p_144982_);
        if ($$1 >= 0) {
            return this.getInternal($$1);
        }
        return null;
    }

    public T first() {
        return this.getInternal(0);
    }

    public T last() {
        return this.getInternal(this.size - 1);
    }

    @Override
    public boolean contains(Object p_14273_) {
        int $$1 = this.findIndex(p_14273_);
        return $$1 >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.contents, this.size, Object[].class);
    }

    @Override
    public <U> U[] toArray(U[] p_14286_) {
        if (p_14286_.length < this.size) {
            return Arrays.copyOf(this.contents, this.size, p_14286_.getClass());
        }
        System.arraycopy(this.contents, 0, p_14286_, 0, this.size);
        if (p_14286_.length > this.size) {
            p_14286_[this.size] = null;
        }
        return p_14286_;
    }

    @Override
    public void clear() {
        Arrays.fill(this.contents, 0, this.size, null);
        this.size = 0;
    }

    @Override
    public boolean equals(Object p_14279_) {
        if (this == p_14279_) {
            return true;
        }
        if (p_14279_ instanceof SortedArraySet) {
            SortedArraySet $$1 = (SortedArraySet)p_14279_;
            if (this.comparator.equals($$1.comparator)) {
                return this.size == $$1.size && Arrays.equals(this.contents, $$1.contents);
            }
        }
        return super.equals(p_14279_);
    }

    class ArrayIterator
    implements Iterator<T> {
        private int index;
        private int last = -1;

        ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < SortedArraySet.this.size;
        }

        @Override
        public T next() {
            if (this.index >= SortedArraySet.this.size) {
                throw new NoSuchElementException();
            }
            this.last = this.index++;
            return SortedArraySet.this.contents[this.last];
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            SortedArraySet.this.removeInternal(this.last);
            --this.index;
            this.last = -1;
        }
    }
}

