/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DelegatingOps<T> {
    private final RegistryInfoLookup lookupProvider;

    public static <T> RegistryOps<T> create(DynamicOps<T> p_256342_, HolderLookup.Provider p_255950_) {
        return RegistryOps.create(p_256342_, new HolderLookupAdapter(p_255950_));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> p_256278_, RegistryInfoLookup p_256479_) {
        return new RegistryOps<T>(p_256278_, p_256479_);
    }

    public static <T> Dynamic<T> injectRegistryContext(Dynamic<T> p_323625_, HolderLookup.Provider p_324054_) {
        return new Dynamic(p_324054_.createSerializationContext(p_323625_.getOps()), p_323625_.getValue());
    }

    private RegistryOps(DynamicOps<T> p_256313_, RegistryInfoLookup p_255799_) {
        super(p_256313_);
        this.lookupProvider = p_255799_;
    }

    public <U> RegistryOps<U> withParent(DynamicOps<U> p_330654_) {
        if (p_330654_ == this.delegate) {
            return this;
        }
        return new RegistryOps<U>(p_330654_, this.lookupProvider);
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends Registry<? extends E>> p_255757_) {
        return this.lookupProvider.lookup(p_255757_).map(RegistryInfo::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends Registry<? extends E>> p_256031_) {
        return this.lookupProvider.lookup(p_256031_).map(RegistryInfo::getter);
    }

    public boolean equals(Object p_341917_) {
        if (this == p_341917_) {
            return true;
        }
        if (p_341917_ == null || this.getClass() != p_341917_.getClass()) {
            return false;
        }
        RegistryOps $$1 = (RegistryOps)p_341917_;
        return this.delegate.equals((Object)$$1.delegate) && this.lookupProvider.equals($$1.lookupProvider);
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.lookupProvider.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends Registry<? extends E>> p_206833_) {
        return ExtraCodecs.retrieveContext(p_274811_ -> {
            if (p_274811_ instanceof RegistryOps) {
                RegistryOps $$2 = (RegistryOps)p_274811_;
                return $$2.lookupProvider.lookup(p_206833_).map(p_255527_ -> DataResult.success(p_255527_.getter(), (Lifecycle)p_255527_.elementsLifecycle())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(p_206833_)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(p_255526_ -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.Reference<E>> retrieveElement(ResourceKey<E> p_256347_) {
        ResourceKey $$1 = ResourceKey.createRegistryKey(p_256347_.registry());
        return ExtraCodecs.retrieveContext(p_274808_ -> {
            if (p_274808_ instanceof RegistryOps) {
                RegistryOps $$3 = (RegistryOps)p_274808_;
                return $$3.lookupProvider.lookup($$1).flatMap(p_255518_ -> p_255518_.getter().get(p_256347_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(p_256347_)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(p_255524_ -> null);
    }

    static final class HolderLookupAdapter
    implements RegistryInfoLookup {
        private final HolderLookup.Provider lookupProvider;
        private final Map<ResourceKey<? extends Registry<?>>, Optional<? extends RegistryInfo<?>>> lookups = new ConcurrentHashMap();

        public HolderLookupAdapter(HolderLookup.Provider p_341886_) {
            this.lookupProvider = p_341886_;
        }

        public <E> Optional<RegistryInfo<E>> lookup(ResourceKey<? extends Registry<? extends E>> p_341913_) {
            return this.lookups.computeIfAbsent(p_341913_, this::createLookup);
        }

        private Optional<RegistryInfo<Object>> createLookup(ResourceKey<? extends Registry<?>> p_341910_) {
            return this.lookupProvider.lookup(p_341910_).map(RegistryInfo::fromRegistryLookup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object p_341924_) {
            if (this == p_341924_) {
                return true;
            }
            if (!(p_341924_ instanceof HolderLookupAdapter)) return false;
            HolderLookupAdapter $$1 = (HolderLookupAdapter)p_341924_;
            if (!this.lookupProvider.equals($$1.lookupProvider)) return false;
            return true;
        }

        public int hashCode() {
            return this.lookupProvider.hashCode();
        }
    }

    public static interface RegistryInfoLookup {
        public <T> Optional<RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);
    }

    public record RegistryInfo<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
        public static <T> RegistryInfo<T> fromRegistryLookup(HolderLookup.RegistryLookup<T> p_326797_) {
            return new RegistryInfo<T>(p_326797_, p_326797_, p_326797_.registryLifecycle());
        }
    }
}

