/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.bettertitlescreen.handler;

import com.google.common.collect.Lists;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigurationHandler {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final CustomText CUSTOM_TEXT = new CustomText(BUILDER);
    public static final General GENERAL = new General(BUILDER);
    public static final ModConfigSpec spec = BUILDER.build();

    public static class CustomText {
        public final ModConfigSpec.ConfigValue<List<? extends String>> titleScreenText;
        static final String DEFAULT_TEXT = "\u00a74B\u00a76E\u00a7eT\u00a72T\u00a73E\u00a71R \u00a75T\u00a74I\u00a76T\u00a7eL\u00a72E \u00a73S\u00a71C\u00a75R\u00a74E\u00a76E\u00a7eN";

        CustomText(ModConfigSpec.Builder builder) {
            builder.push("custom text");
            this.titleScreenText = builder.comment("Insert the custom title screen text you want here (supports multiple lines)").translation("bettertitlescreen.configgui.titleScreenText").defineList("text", (List)Lists.newArrayList((Object[])new String[]{DEFAULT_TEXT}), o -> o instanceof String);
            builder.pop();
        }
    }

    public static class General {
        public final ModConfigSpec.BooleanValue titleScreenMCVersion;
        public final ModConfigSpec.BooleanValue titleScreenMCP;
        public final ModConfigSpec.BooleanValue titleScreenForge;
        public final ModConfigSpec.BooleanValue titleScreenMods;

        General(ModConfigSpec.Builder builder) {
            builder.push("versions");
            this.titleScreenMCVersion = builder.comment("Show which version of Minecraft the client is currently running.").translation("bettertitlescreen.configgui.mcVersion").define("showMcVersion", true);
            this.titleScreenMCP = builder.comment("Show which version of Minecraft Coder Pack (MCP) the client is running.").translation("bettertitlescreen.configgui.mcpVersion").define("showMcpVersion", false);
            this.titleScreenForge = builder.comment("Show which version of Minecraft Forge the client is running.").translation("bettertitlescreen.configgui.forgeVersion").define("showForgeVersion", false);
            this.titleScreenMods = builder.comment("Show how many mods are loaded.").translation("bettertitlescreen.configgui.modsLoaded").define("showModsLoaded", false);
            builder.pop();
        }
    }
}

