/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.EffectRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.TooltipFlag;

public class ScreenExtensionsHandler {
    public static final Map<Class<? extends AbstractContainerScreen<?>>, IEffectScreenExtension<? extends AbstractContainerScreen<?>>> EXTENSIONS = new IdentityHashMap();

    public static <T extends Screen, E extends IEffectScreenExtension<T>> E getExtension(T screen) {
        Class<?> c = screen.getClass();
        IEffectScreenExtension<? extends AbstractContainerScreen<?>> direct = EXTENSIONS.get(c);
        if (direct != null) {
            return (E)direct;
        }
        for (Map.Entry<Class<AbstractContainerScreen<?>>, IEffectScreenExtension<AbstractContainerScreen<?>>> e : EXTENSIONS.entrySet()) {
            if (!e.getKey().isInstance(screen)) continue;
            return (E)e.getValue();
        }
        return null;
    }

    public static <T extends AbstractContainerScreen<?>> void registerScreenExtension(Class<T> screenClass, IEffectScreenExtension<T> extension) {
        EXTENSIONS.put(screenClass, extension);
    }

    public static <T extends AbstractContainerScreen<?>> void unRegisterExtension(Class<T> screenClass) {
        EXTENSIONS.remove(screenClass);
    }

    public static void renderEffectTooltip(MobEffectInstance effect, Screen screen, GuiGraphics graphics, int x, int y, boolean showDuration) {
        if (!Jeed.PLUGIN.rendersTooltips()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        TooltipFlag.Default flag = mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        List<Component> tooltip = EffectRenderer.getTooltipsWithDescription(effect, (TooltipFlag)flag, true, showDuration);
        if (!tooltip.isEmpty()) {
            graphics.renderComponentTooltip(mc.font, tooltip, x, y);
        }
    }
}

