/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.jeed.Jeed;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public abstract class EffectRenderer {
    protected final Minecraft mc = Minecraft.getInstance();
    protected final boolean offset;

    protected EffectRenderer(boolean offset) {
        this.offset = offset;
    }

    public void render(GuiGraphics graphics, MobEffectInstance effectInstance) {
        this.render(graphics, effectInstance, 0, 0, 16, 16);
    }

    public void render(GuiGraphics graphics, MobEffectInstance effectInstance, int x, int y, int width, int height) {
        Holder effect = effectInstance.getEffect();
        MobEffectTextureManager textures = this.mc.getMobEffectTextures();
        TextureAtlasSprite sprite = textures.get(effect);
        this.render(graphics, sprite, x, y, width, height);
    }

    public void render(GuiGraphics graphics, TextureAtlasSprite sprite, int x, int y, int width, int height) {
        int o = this.offset ? -1 : 0;
        graphics.blit(x + o, y + o, 0, width + 2, height + 2, sprite);
    }

    public static List<Component> getTooltipsWithDescription(MobEffectInstance effectInstance, TooltipFlag tooltipFlag, boolean reactsToShift, boolean showDuration) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (effectInstance != null) {
            MobEffect effect = (MobEffect)effectInstance.getEffect().value();
            Object name = I18n.get((String)effect.getDescriptionId(), (Object[])new Object[0]);
            int amp = effectInstance.getAmplifier();
            if (amp >= 1 && amp <= 9) {
                name = (String)name + " " + I18n.get((String)("enchantment.level." + (amp + 1)), (Object[])new Object[0]);
            }
            tooltip.add((Component)Component.literal((String)name));
            if (showDuration) {
                tooltip.add(MobEffectUtil.formatDuration((MobEffectInstance)effectInstance, (float)1.0f, (float)Minecraft.getInstance().level.tickRateManager().tickrate()));
            }
            if (Jeed.hasEffectColor()) {
                MutableComponent colorValue = Component.literal((String)("#" + Integer.toHexString(effect.getColor())));
                colorValue.setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)effect.getColor())));
                MutableComponent color = Component.translatable((String)"jeed.tooltip.color").withStyle(ChatFormatting.GRAY);
                tooltip.add((Component)Component.translatable((String)"jeed.tooltip.color_complete", (Object[])new Object[]{color, colorValue}));
            }
            MobEffectCategory cat = effect.getCategory();
            if (effect.isBeneficial()) {
                tooltip.add((Component)Component.translatable((String)"jeed.tooltip.beneficial").withStyle(ChatFormatting.BLUE));
            } else if (cat == MobEffectCategory.NEUTRAL) {
                tooltip.add((Component)Component.translatable((String)"jeed.tooltip.neutral").withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.translatable((String)"jeed.tooltip.harmful").withStyle(ChatFormatting.RED));
            }
            boolean showDescription = reactsToShift && Screen.hasShiftDown();
            ResourceLocation res = null;
            if (showDescription || tooltipFlag.isAdvanced()) {
                res = BuiltInRegistries.MOB_EFFECT.getKey((Object)effect);
            }
            if (showDescription) {
                tooltip.add((Component)Component.translatable((String)("effect." + res.getNamespace() + "." + res.getPath() + ".description")).withStyle(ChatFormatting.GRAY));
            } else {
                ArrayList attributes = Lists.newArrayList();
                Holder holder = effectInstance.getEffect();
                ((MobEffect)holder.value()).createModifiers(effectInstance.getAmplifier(), (holderx, attributeModifierx) -> attributes.add(new Pair(holderx, attributeModifierx)));
                if (!attributes.isEmpty()) {
                    tooltip.add((Component)Component.empty());
                    tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
                    for (Pair pair : attributes) {
                        AttributeModifier am = (AttributeModifier)pair.getSecond();
                        double amount = am.amount();
                        double actualAmount = am.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && am.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? am.amount() : am.amount() * 100.0;
                        String descriptionId = ((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId();
                        if (amount > 0.0) {
                            tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + am.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(actualAmount), Component.translatable((String)descriptionId)}).withStyle(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(amount < 0.0)) continue;
                        tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + am.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(actualAmount *= -1.0), Component.translatable((String)descriptionId)}).withStyle(ChatFormatting.RED));
                    }
                }
            }
            if (tooltipFlag.isAdvanced()) {
                tooltip.add((Component)Component.literal((String)res.toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }
}

