/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern;

import com.cerbon.bosses_of_mass_destruction.structure.util.IStructurePiece;
import com.cerbon.bosses_of_mass_destruction.structure.void_blossom_cavern.ICaveDecorator;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SporeBlossomCaveDecorator
implements ICaveDecorator {
    private final int bottomOfWorld;
    private final RandomSource random;
    private final List<BlockPos> sporeBlossomPositions = new ArrayList<BlockPos>();
    private final ConfiguredFeature<SimpleBlockConfiguration, Feature<SimpleBlockConfiguration>> sporeBlossom = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.SPORE_BLOSSOM)));
    private final PlacedFeature placedFeature = new PlacedFeature(Holder.direct(this.sporeBlossom), Arrays.asList(CountPlacement.of((int)25), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))));

    public SporeBlossomCaveDecorator(int bottomOfWorld, RandomSource random) {
        this.bottomOfWorld = bottomOfWorld;
        this.random = random;
    }

    @Override
    public void onBlockPlaced(BlockPos pos, Block block) {
        if (pos.getY() > 20 + this.bottomOfWorld && this.random.nextInt(20) == 0 && block != Blocks.AIR) {
            this.sporeBlossomPositions.add(pos);
        }
    }

    @Override
    public void generate(WorldGenLevel level, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, BlockPos pos, IStructurePiece structurePiece) {
        Map<Pair, List<BlockPos>> groupedSporeBlossomPositions = this.sporeBlossomPositions.stream().collect(Collectors.groupingBy(p -> new Pair((Object)(p.getX() >> 3), (Object)(p.getZ() >> 3))));
        List<BlockPos> spacedSporeBlossomPositions = groupedSporeBlossomPositions.values().stream().map(list -> (BlockPos)list.get(0)).toList();
        for (BlockPos sporePos : spacedSporeBlossomPositions) {
            if (!boundingBox.isInside((Vec3i)sporePos)) continue;
            this.placedFeature.place(level, chunkGenerator, random, sporePos);
        }
    }
}

