/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.item.custom;

import com.cerbon.bosses_of_mass_destruction.packet.custom.SendVec3S2CPacket;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.structure.structure_repair.StructureRepair;
import com.cerbon.bosses_of_mass_destruction.util.VecId;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.network.Dispatcher;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BrimstoneNectarItem
extends Item {
    private final List<StructureRepair> structureRepairs;

    public BrimstoneNectarItem(Item.Properties properties, List<StructureRepair> structureRepairs) {
        super(properties);
        this.structureRepairs = structureRepairs;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.bosses_of_mass_destruction.brimstone_nectar.tooltip").withStyle(ChatFormatting.DARK_GRAY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player user, @NotNull InteractionHand hand) {
        BlockPos usePos;
        ServerLevel serverLevel;
        List<StructureRepair> structuresToRepair;
        ItemStack itemStack = user.getItemInHand(hand);
        if (!level.isClientSide && level instanceof ServerLevel && !(structuresToRepair = this.findStructuresToRepair(serverLevel = (ServerLevel)level, usePos = user.blockPosition())).isEmpty()) {
            this.scheduleStructureRepair(serverLevel, structuresToRepair, usePos);
            this.playSound((Level)serverLevel, user);
            user.getCooldowns().addCooldown((Item)this, 80);
            Dispatcher.sendToClientsLoadingPos((Object)new SendVec3S2CPacket(user.position(), VecId.BrimstoneParticleEffect.ordinal()), (ServerLevel)serverLevel, (Vec3)user.position());
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            user.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)false);
        }
        return InteractionResultHolder.pass((Object)itemStack);
    }

    private List<StructureRepair> findStructuresToRepair(ServerLevel level, BlockPos usePos) {
        return this.structureRepairs.stream().filter(structure -> {
            StructureStart structureStart = this.getStructureStart(level, usePos, (StructureRepair)structure);
            return structureStart.isValid() && structure.shouldRepairStructure(level, structureStart);
        }).toList();
    }

    private void scheduleStructureRepair(ServerLevel level, List<StructureRepair> structureToRepair, BlockPos usePos) {
        CapabilityUtils.getLevelEventScheduler((Level)level).addEvent((IEvent)new TimedEvent(() -> structureToRepair.forEach(structure -> structure.repairStructure(level, this.getStructureStart(level, usePos, (StructureRepair)structure))), 30));
    }

    private StructureStart getStructureStart(ServerLevel level, BlockPos blockPos, StructureRepair it) {
        return level.structureManager().getStructureAt(blockPos, (Structure)level.structureManager().registryAccess().registryOrThrow(Registries.STRUCTURE).getOrThrow(it.associatedStructure()));
    }

    private void playSound(Level level, Player user) {
        level.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)BMDSounds.BRIMSTONE.get(), SoundSource.NEUTRAL, 1.0f, SoundUtils.randomPitch((RandomSource)level.getRandom()));
    }
}

