/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.config.mob.ObsidilithConfig;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.CooldownAction;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.ai.goals.ActionGoal;
import com.cerbon.bosses_of_mass_destruction.entity.ai.goals.FindTargetGoal;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.AnvilAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.BurstAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithEffectHandler;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithMoveLogic;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ObsidilithUtils;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.PillarAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.ShieldDamageHandler;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.SpikeAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.WaveAction;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.CappedHeal;
import com.cerbon.bosses_of_mass_destruction.entity.damage.CompositeDamageHandler;
import com.cerbon.bosses_of_mass_destruction.entity.damage.DamageMemory;
import com.cerbon.bosses_of_mass_destruction.entity.util.BaseEntity;
import com.cerbon.bosses_of_mass_destruction.entity.util.EffectsImmunity;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.MobUtils;
import com.cerbon.cerbons_api.api.static_utilities.ParticleUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class ObsidilithEntity
extends BaseEntity {
    private final ObsidilithConfig mobConfig;
    private final Map<Byte, IActionWithCooldown> statusRegistry;
    private final ObsidilithMoveLogic moveLogic;
    private final ObsidilithEffectHandler effectHandler;
    private final List<BlockPos> activePillars = new ArrayList<BlockPos>();
    public byte currentAttack = 0;
    public static final EntityDataAccessor<Boolean> isShielded = SynchedEntityData.defineId(ObsidilithEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ObsidilithEntity(EntityType<? extends PathfinderMob> entityType, Level level, ObsidilithConfig mobConfig) {
        super(entityType, level);
        this.mobConfig = mobConfig;
        this.noCulling = true;
        this.statusRegistry = Map.of((byte)5, new BurstAction((LivingEntity)this), (byte)6, new WaveAction((Mob)this), (byte)7, new SpikeAction((Mob)this), (byte)8, new AnvilAction((Mob)this, mobConfig.anvilAttackExplosionStrength), (byte)9, new PillarAction((LivingEntity)this));
        DamageMemory damageMemory = new DamageMemory(10, (LivingEntity)this);
        this.moveLogic = new ObsidilithMoveLogic(this.statusRegistry, this, damageMemory);
        this.effectHandler = new ObsidilithEffectHandler((LivingEntity)this, CapabilityUtils.getLevelEventScheduler((Level)level));
        this.bossBar = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_12);
        this.damageHandler = new CompositeDamageHandler(this.moveLogic, new ShieldDamageHandler(this::isShielded), damageMemory);
        this.mobEffectHandler = new EffectsImmunity((MobEffect)MobEffects.WITHER.value(), (MobEffect)MobEffects.POISON.value());
        this.serverTick = new CappedHeal((Mob)this, ObsidilithUtils.hpPillarShieldMilestones, mobConfig.idleHealingPerTick);
        if (!level.isClientSide()) {
            this.goalSelector.addGoal(1, (Goal)this.buildAttackGoal());
            this.targetSelector.addGoal(2, new FindTargetGoal<Player>((Mob)this, Player.class, d -> this.getBoundingBox().inflate(d.doubleValue()), 10, true, false, null));
            this.preTickEvents.addEvent((IEvent)new TimedEvent(() -> SoundUtils.playSound((ServerLevel)((ServerLevel)level), (Vec3)this.position(), (SoundEvent)((SoundEvent)BMDSounds.WAVE_INDICATOR.get()), (SoundSource)SoundSource.HOSTILE, (float)1.5f, (float)0.7f, (double)24.0, null), 1));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(isShielded, (Object)false);
    }

    private ActionGoal buildAttackGoal() {
        CooldownAction attackAction = new CooldownAction(this.moveLogic, 80);
        return new ActionGoal(this::canContinueAttack, null, attackAction, null, attackAction);
    }

    @Override
    public void serverTick(ServerLevel serverLevel) {
        super.serverTick(serverLevel);
        this.activePillars.removeIf(pos -> this.level().getBlockState(pos).getBlock() != BMDBlocks.OBSIDILITH_RUNE.get() || !pos.closerThan((Vec3i)this.blockPosition(), 64.0));
        this.getEntityData().set(isShielded, (Object)(!this.activePillars.isEmpty() ? 1 : 0));
        if (this.tickCount % 40 == 0 && !this.activePillars.isEmpty()) {
            BlockPos pos2 = this.activePillars.get(new Random().nextInt(this.activePillars.size()));
            MathUtils.lineCallback((Vec3)VecUtils.asVec3((BlockPos)pos2).add(0.5, 0.5, 0.5), (Vec3)MobUtils.eyePos((Entity)this), (int)15, (vec3, i) -> this.preTickEvents.addEvent((IEvent)new TimedEvent(() -> ParticleUtils.spawnParticle((ServerLevel)serverLevel, (ParticleOptions)((ParticleOptions)BMDParticles.PILLAR_RUNE.get()), (Vec3)vec3, (Vec3)Vec3.ZERO, (int)0, (double)0.0), i.intValue())));
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void push(@NotNull Entity entity) {
    }

    public void die(@NotNull DamageSource damageSource) {
        if (this.mobConfig.spawnPillarOnDeath) {
            ObsidilithUtils.onDeath((LivingEntity)this, this.mobConfig.experienceDrop);
            if (this.level().isClientSide) {
                this.effectHandler.handleStatus((byte)3);
            }
        }
        super.die(damageSource);
    }

    public boolean canContinueAttack() {
        return this.isAlive() && this.getTarget() != null;
    }

    @Override
    public void handleEntityEvent(byte status) {
        IActionWithCooldown attackStatus = this.statusRegistry.get(status);
        if (attackStatus != null) {
            this.effectHandler.handleStatus(status);
            this.currentAttack = status;
            this.preTickEvents.addEvent((IEvent)new TimedEvent(() -> {
                this.currentAttack = 0;
            }, 40));
        }
        super.handleEntityEvent(status);
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)BMDSounds.OBSIDILITH_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)BMDSounds.OBSIDILITH_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "summon", 0, animationState -> {
            animationState.getController().setAnimation(RawAnimation.begin().thenPlay("summon"));
            return PlayState.CONTINUE;
        }));
    }

    @Override
    public void move(@NotNull MoverType type, @NotNull Vec3 movement) {
        super.move(type, new Vec3(0.0, movement.y, 0.0));
    }

    public boolean isOnFire() {
        return false;
    }

    public int getArmorValue() {
        return this.getTarget() != null ? super.getArmorValue() : 24;
    }

    public void checkDespawn() {
        MobUtils.preventDespawnExceptPeaceful((LivingEntity)this, (Level)this.level());
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, @NotNull DamageSource source) {
        return false;
    }

    public boolean isShielded() {
        return (Boolean)this.getEntityData().get(isShielded);
    }

    public void addActivePillar(BlockPos pos) {
        this.activePillars.add(pos);
    }

    @Override
    @NotNull
    public CompoundTag saveWithoutId(@NotNull CompoundTag compound) {
        int[] activePillarsArray = this.activePillars.stream().flatMapToInt(p -> IntStream.of(p.getX(), p.getY(), p.getZ())).toArray();
        compound.putIntArray("activePillars", activePillarsArray);
        return super.saveWithoutId(compound);
    }

    @Override
    public void load(@NotNull CompoundTag compound) {
        super.load(compound);
        if (compound.contains("activePillars")) {
            int[] activePillarsArray = compound.getIntArray("activePillars");
            for (int i = 0; i < activePillarsArray.length; i += 3) {
                BlockPos pos = new BlockPos(activePillarsArray[i], activePillarsArray[i + 1], activePillarsArray[i + 2]);
                this.activePillars.add(pos);
            }
        }
    }
}

