/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.lich;

import com.cerbon.bosses_of_mass_destruction.entity.GeoModel;
import com.cerbon.bosses_of_mass_destruction.entity.custom.lich.LichEntity;
import com.cerbon.bosses_of_mass_destruction.entity.util.animation.ICodeAnimations;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;

public class LichCodeAnimations
implements ICodeAnimations<LichEntity> {
    @Override
    public void animate(LichEntity animatable, AnimationState<?> data, GeoModel<LichEntity> geoModel) {
        float bodyYaw = Mth.rotLerp((float)data.getPartialTick(), (float)animatable.yBodyRotO, (float)animatable.yBodyRot);
        float headYaw = Mth.rotLerp((float)data.getPartialTick(), (float)animatable.yHeadRotO, (float)animatable.yHeadRot);
        float headPitch = Mth.lerp((float)data.getPartialTick(), (float)animatable.xRotO, (float)animatable.getXRot());
        Vec3 velocity = MathUtils.lerpVec((float)data.getPartialTick(), (Vec3)((Vec3)animatable.velocityHistory.get(1)), (Vec3)((Vec3)animatable.velocityHistory.get(0)));
        int neutralPoseDegree = 30;
        int maxDegreeVariation = 15;
        double bodyPitch = (double)MathUtils.directionToPitch((Vec3)velocity) * ((double)maxDegreeVariation / 90.0) + (double)neutralPoseDegree;
        float yaw = headYaw - bodyYaw;
        double adjustedHeadPitch = (double)headPitch - bodyPitch;
        BakedGeoModel model = geoModel.getBakedModel(geoModel.getModelResource(animatable));
        model.getBone("code_root").ifPresent(bone -> bone.setRotX((float)(-Math.toRadians(bodyPitch))));
        model.getBone("headBase").ifPresent(bone -> bone.setRotX((float)(-Math.toRadians(adjustedHeadPitch))));
        model.getBone("headBase").ifPresent(bone -> bone.setRotY((float)Math.toRadians(yaw)));
    }
}

