/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.client.render;

import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class LerpedPosRenderer<T extends Entity>
implements IRenderer<T> {
    private final Consumer<Vec3> callback;

    public LerpedPosRenderer(Consumer<Vec3> callback) {
        this.callback = callback;
    }

    @Override
    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        double x = Mth.lerp((double)partialTicks, (double)((Entity)entity).xo, (double)entity.getX());
        double y = Mth.lerp((double)partialTicks, (double)((Entity)entity).yo, (double)entity.getY());
        double z = Mth.lerp((double)partialTicks, (double)((Entity)entity).zo, (double)entity.getZ());
        this.callback.accept(new Vec3(x, y, z));
    }
}

