/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.block.custom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlockEntities;
import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.block.custom.ChunkCacheBlockEntity;
import com.cerbon.bosses_of_mass_destruction.block.custom.MonolithBlockEntity;
import com.cerbon.bosses_of_mass_destruction.capability.ChunkBlockCache;
import com.cerbon.bosses_of_mass_destruction.capability.util.BMDCapabilities;
import com.cerbon.bosses_of_mass_destruction.util.VanillaCopiesServer;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonolithBlock
extends BaseEntityBlock {
    public static final MapCodec<MonolithBlock> CODEC = MonolithBlock.simpleCodec(MonolithBlock::new);
    private static final VoxelShape xAxisShape = MonolithBlock.box((double)3.5, (double)0.0, (double)1.5, (double)12.5, (double)16.0, (double)14.5);
    private static final VoxelShape zAxisShape = MonolithBlock.box((double)1.5, (double)0.0, (double)3.5, (double)14.5, (double)16.0, (double)12.5);

    public MonolithBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.bosses_of_mass_destruction.monolith_block.tooltip_0").withStyle(ChatFormatting.DARK_GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.bosses_of_mass_destruction.monolith_block.tooltip_1").withStyle(ChatFormatting.DARK_GRAY));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MonolithBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return MonolithBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BMDBlockEntities.MONOLITH_BLOCK_ENTITY.get()), ChunkCacheBlockEntity::tick);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getAxis() == Direction.Axis.X ? xAxisShape : zAxisShape;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, @NotNull BlockState newState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos posFrom) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
        BlockState airState = Blocks.AIR.defaultBlockState();
        if (direction.getAxis() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            if (newState.is((Block)this) && newState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) != doubleBlockHalf) {
                return (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)newState.getValue((Property)HorizontalDirectionalBlock.FACING)));
            }
            return airState;
        }
        return super.updateShape(state, direction, newState, level, pos, posFrom);
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide && player.isCreative()) {
            VanillaCopiesServer.onBreakInCreative(level, pos, state, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        if (blockPos.getY() < 255 && ctx.getLevel().getBlockState(blockPos.above()).canBeReplaced(ctx)) {
            return (BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            return blockState.isFaceSturdy((BlockGetter)level, blockPos, Direction.UP);
        }
        return blockState.is((Block)this);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.rotate(mirror.getRotation((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING))).cycle((Property)DoorBlock.HINGE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.DOUBLE_BLOCK_HALF, HorizontalDirectionalBlock.FACING});
    }

    public static float getExplosionPower(ServerLevel level, BlockPos pos, float power) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Optional<ChunkBlockCache> blockCache = BMDCapabilities.getChunkBlockCache((Level)level);
        if (blockCache.isPresent()) {
            for (int x = chunkPos.x - 4; x <= chunkPos.x + 4; ++x) {
                for (int z = chunkPos.z - 4; z <= chunkPos.z + 4; ++z) {
                    List<BlockPos> blocks = blockCache.get().getBlocksFromChunk(new ChunkPos(x, z), (Block)BMDBlocks.MONOLITH_BLOCK.get());
                    for (BlockPos blockPos : blocks) {
                        if (Math.abs(blockPos.getX() - pos.getX()) >= 64 || Math.abs(blockPos.getY() - pos.getY()) >= 64 || Math.abs(blockPos.getZ() - pos.getZ()) >= 64) continue;
                        return power * 1.3f;
                    }
                }
            }
        }
        return power;
    }
}

