/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.item;

import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DyeBottleItem
extends Item {
    protected static final HashBiMap<DyeColor, Integer> COLOR_TO_DIFFUSE = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), DyeColor::getTextureDiffuseColor, (color, color2) -> color2, HashBiMap::create));
    private static final DyedItemColor DEFAULT_COLOR = new DyedItemColor(DyeBottleItem.getDyeInt(DyeColor.WHITE).intValue(), false);
    public static final DyedItemColor RED_COLOR = new DyedItemColor(DyeBottleItem.getDyeInt(DyeColor.RED).intValue(), false);

    public DyeBottleItem(Item.Properties properties) {
        super(properties);
    }

    public static SoftFluidStack createFluidStack(DyeColor color, int amount) {
        SoftFluidStack stack = SoftFluidStack.of(ModRegistry.DYE_SOFT_FLUID, (int)amount);
        stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(DyeBottleItem.getDyeInt(color).intValue(), true));
        return stack;
    }

    public static ItemStack fromFluidStack(SoftFluidStack stack) {
        ItemStack item = new ItemStack((ItemLike)ModRegistry.DYE_BOTTLE_ITEM.get());
        item.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)DEFAULT_COLOR)));
        return item;
    }

    public static int mixColor(int oldColor, int newColor, int oldAmount, int newAmount) {
        return new RGBColor(oldColor).asHCL().mixWith(new RGBColor(newColor).asHCL(), (float)newAmount / (float)(oldAmount + newAmount)).asRGB().toInt();
    }

    @NotNull
    private static Integer getDyeInt(DyeColor color) {
        return (Integer)COLOR_TO_DIFFUSE.get((Object)color);
    }

    public static DyeColor getClosestDye(SoftFluidStack stack) {
        return DyeBottleItem.getClosestDye(((DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)DEFAULT_COLOR)).rgb());
    }

    public static DyeColor getClosestDye(ItemStack stack) {
        return DyeBottleItem.getClosestDye(((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb());
    }

    public static DyeColor getClosestDye(int tintColor) {
        LABColor color = new RGBColor(tintColor).asLAB();
        double minDist = Double.MAX_VALUE;
        DyeColor minColor = null;
        for (DyeColor dyeColor : DyeColor.values()) {
            LABColor c2 = new RGBColor(DyeBottleItem.getDyeInt(dyeColor).intValue()).asLAB();
            double dist = c2.distTo((BaseColor)color);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minColor = dyeColor;
        }
        return minColor;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, list, tooltipFlag);
        DyedItemColor color = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
        if (color == null) {
            return;
        }
        DyeColor dye = (DyeColor)COLOR_TO_DIFFUSE.inverse().get((Object)color.rgb());
        if (dye != null) {
            list.add((Component)Component.translatable((String)("item.amendments.dye_bottle." + dye.getName())).withStyle(ChatFormatting.GRAY));
        } else if (tooltipFlag.isAdvanced()) {
            list.add((Component)Component.translatable((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", color.rgb())}).withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"item.dyed").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (interactionTarget instanceof Sheep) {
            Sheep sheep = (Sheep)interactionTarget;
            DyeColor dye = DyeBottleItem.getClosestDye(stack);
            if (sheep.isAlive() && !sheep.isSheared() && sheep.getColor() != dye) {
                sheep.level().playSound(player, (Entity)sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.level().isClientSide) {
                    sheep.setColor(dye);
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }
}

