/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.starfish_studios.another_furniture.block.ShelfBlock;
import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SmallShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    public SmallShelfRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(ShelfBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)ShelfBlock.FACING);
        float rotation = -direction.toYRot() + 180.0f;
        NonNullList<ItemStack> items = blockEntity.getItems();
        poseStack.pushPose();
        poseStack.translate(0.5, 1.18, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        for (int j = 0; j < items.size(); ++j) {
            ItemStack stack = (ItemStack)items.get(j);
            if (stack.isEmpty()) continue;
            int renderCount = this.getAmount(stack.getCount());
            for (int i = 0; i < renderCount; ++i) {
                float fx = -0.10375f * (float)(i - 1) * 0.5f % 0.09f;
                float fy = -0.04375f * (float)(i - 1) * 0.5f % 0.09f;
                float fz = -0.05375f * (float)(i - 1) * 0.5f % 0.09f;
                poseStack.pushPose();
                poseStack.translate(0.15 - 0.4 * (double)(j % 2), 0.0, -0.225 + 0.4 * (double)(j / 2));
                poseStack.translate(fx, fy, fz);
                poseStack.scale(0.375f, 0.375f, 0.375f);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public int getAmount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }
}

