/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.LampConnectorBlock;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFBlocks;
import com.starfish_studios.another_furniture.registry.AFItemTags;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LampBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final int LEVEL_MIN = 1;
    protected static final int LEVEL_MAX = 3;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty FACING = ModBlockStateProperties.FACING_EXCEPT_DOWN;
    public static final IntegerProperty LEVEL = ModBlockStateProperties.LEVEL_1_3;
    public static final BooleanProperty BASE = ModBlockStateProperties.BASE;
    protected static final VoxelShape AABB_UP = Block.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape AABB_UP_NORMAL = Shapes.or((VoxelShape)AABB_UP, (VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0));
    protected static final VoxelShape AABB_UP_TOP = Shapes.or((VoxelShape)AABB_UP, (VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0));
    protected static final VoxelShape AABB_NORTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)8.0, (double)5.0, (double)13.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)6.0, (double)16.0), Block.box((double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)8.0, (double)11.0), Block.box((double)7.0, (double)2.0, (double)11.0, (double)9.0, (double)4.0, (double)14.0)});
    protected static final VoxelShape AABB_EAST = ShapeUtil.rotateShape(AABB_NORTH, Direction.EAST);
    protected static final VoxelShape AABB_SOUTH = ShapeUtil.rotateShape(AABB_NORTH, Direction.SOUTH);
    protected static final VoxelShape AABB_WEST = ShapeUtil.rotateShape(AABB_NORTH, Direction.WEST);
    private final DyeColor color;

    public LampBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)LEVEL, (Comparable)Integer.valueOf(3))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BASE, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> AABB_NORTH;
            case Direction.EAST -> AABB_EAST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.WEST -> AABB_WEST;
            default -> (Boolean)state.getValue((Property)BASE) != false ? AABB_UP_NORMAL : AABB_UP_TOP;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        BlockState blockstate = this.defaultBlockState();
        if (level.hasNeighborSignal(pos)) {
            blockstate = (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return clickedFace != Direction.DOWN ? (BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)clickedFace)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)) : null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (state.getValue((Property)FACING) == Direction.UP && (direction == Direction.UP || direction == Direction.DOWN)) {
            LampConnectorBlock connectorBlock;
            LampBlock lampBlock;
            boolean bConnect;
            LampConnectorBlock connectorBlock2;
            LampBlock lampBlock2;
            BlockState aState = level.getBlockState(currentPos.above());
            BlockState bState = level.getBlockState(currentPos.below());
            Block block = aState.getBlock();
            boolean aConnect = block instanceof LampBlock && (lampBlock2 = (LampBlock)block).getColor() == this.getColor() && aState.getValue((Property)FACING) == Direction.UP || (block = aState.getBlock()) instanceof LampConnectorBlock && (connectorBlock2 = (LampConnectorBlock)block).getColor() == this.getColor();
            Block block2 = bState.getBlock();
            boolean bl = bConnect = block2 instanceof LampBlock && (lampBlock = (LampBlock)block2).getColor() == this.getColor() && bState.getValue((Property)FACING) == Direction.UP || (block2 = bState.getBlock()) instanceof LampConnectorBlock && (connectorBlock = (LampConnectorBlock)block2).getColor() == this.getColor();
            state = aConnect && !bConnect ? (BlockState)((BlockState)LampBlock.getLampConnectorByColor(this.color).defaultBlockState().setValue((Property)BASE, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))) : (!aConnect && bConnect ? (BlockState)state.setValue((Property)BASE, (Comparable)Boolean.valueOf(false)) : (aConnect ? (BlockState)((BlockState)LampBlock.getLampConnectorByColor(this.color).defaultBlockState().setValue((Property)BASE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))) : (BlockState)state.setValue((Property)BASE, (Comparable)Boolean.valueOf(true))));
        }
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos facingPos = pos.relative(direction.getOpposite());
        BlockState facingState = level.getBlockState(facingPos);
        return direction == Direction.UP || facingState.isFaceSturdy((BlockGetter)level, facingPos, direction);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (level.isClientSide) {
            return;
        }
        BlockState below = level.getBlockState(pos.below());
        boolean bl = powered = level.hasNeighborSignal(pos) || below.getBlock() instanceof LampConnectorBlock && (Boolean)below.getValue((Property)POWERED) != false;
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            if ((Boolean)state.getValue((Property)LIT) != powered) {
                state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(powered));
                level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        }
        level.setBlock(pos, state, 3);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(AFItemTags.LAMPS) && state.getValue((Property)FACING) == Direction.UP && hitResult.getDirection() == Direction.UP) {
            return ItemInteractionResult.FAIL;
        }
        if (player.isCrouching()) {
            int light = (Integer)state.getValue((Property)LEVEL);
            light = light >= 3 ? 1 : light + 1;
            state = (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(light));
        } else {
            state = (BlockState)state.cycle((Property)LIT);
        }
        level.setBlock(pos, state, 3);
        level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 1.0f, 1.0f);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, LIT, POWERED, FACING, LEVEL, BASE});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Block getLampConnectorByColor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> AFBlocks.WHITE_LAMP_CONNECTOR.get();
            case DyeColor.ORANGE -> AFBlocks.ORANGE_LAMP_CONNECTOR.get();
            case DyeColor.MAGENTA -> AFBlocks.MAGENTA_LAMP_CONNECTOR.get();
            case DyeColor.LIGHT_BLUE -> AFBlocks.LIGHT_BLUE_LAMP_CONNECTOR.get();
            case DyeColor.YELLOW -> AFBlocks.YELLOW_LAMP_CONNECTOR.get();
            case DyeColor.LIME -> AFBlocks.LIME_LAMP_CONNECTOR.get();
            case DyeColor.PINK -> AFBlocks.PINK_LAMP_CONNECTOR.get();
            case DyeColor.GRAY -> AFBlocks.GRAY_LAMP_CONNECTOR.get();
            case DyeColor.LIGHT_GRAY -> AFBlocks.LIGHT_GRAY_LAMP_CONNECTOR.get();
            case DyeColor.CYAN -> AFBlocks.CYAN_LAMP_CONNECTOR.get();
            case DyeColor.PURPLE -> AFBlocks.PURPLE_LAMP_CONNECTOR.get();
            case DyeColor.BLUE -> AFBlocks.BLUE_LAMP_CONNECTOR.get();
            case DyeColor.BROWN -> AFBlocks.BROWN_LAMP_CONNECTOR.get();
            case DyeColor.GREEN -> AFBlocks.GREEN_LAMP_CONNECTOR.get();
            case DyeColor.RED -> AFBlocks.RED_LAMP_CONNECTOR.get();
            case DyeColor.BLACK -> AFBlocks.BLACK_LAMP_CONNECTOR.get();
        };
    }
}

