/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<HorizontalConnectionType> HORIZONTAL_CONNECTION_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty VERTICAL_CONNECTION_TYPE = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE_UP_DOWN;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape WEST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public CurtainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HORIZONTAL_CONNECTION_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).setValue((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.UP)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.getValue(HORIZONTAL_CONNECTION_TYPE));
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && (type == HorizontalConnectionType.SINGLE || type == HorizontalConnectionType.MIDDLE) && state.getValue((Property)VERTICAL_CONNECTION_TYPE) == Direction.DOWN) {
            return Shapes.empty();
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)OPEN) != false ? Shapes.empty() : super.getCollisionShape(state, level, pos, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean sideR;
        Direction clickedFacingFace;
        Direction clickedFace;
        BlockPos pos;
        Level level = context.getLevel();
        if (!level.getBlockState((pos = context.getClickedPos()).below()).canBeReplaced(context) || level.isOutsideBuildHeight(pos.below())) {
            return null;
        }
        Direction facing = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos clickedFacingPos = clickedPos.relative(clickedFace = context.getClickedFace());
        BlockState clickedFacingState = level.getBlockState(clickedFacingPos);
        if (clickedFacingState.getBlock() instanceof CurtainBlock && (clickedFacingFace = (Direction)clickedFacingState.getValue((Property)FACING)) != clickedFace && clickedFacingFace.getOpposite() != clickedFace) {
            facing = clickedFacingFace;
        }
        if (facing.getAxis().isVertical()) {
            facing = context.getHorizontalDirection().getOpposite();
        }
        BlockState stateL = level.getBlockState(pos.relative(facing.getClockWise()));
        BlockState stateR = level.getBlockState(pos.relative(facing.getCounterClockWise()));
        boolean sideL = stateL.getBlock() instanceof CurtainBlock && stateL.getValue((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP && stateL.getValue((Property)FACING) == facing;
        boolean bl = sideR = stateR.getBlock() instanceof CurtainBlock && stateR.getValue((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP && stateR.getValue((Property)FACING) == facing;
        boolean open = sideL && sideR ? ((Boolean)stateL.getValue((Property)OPEN)).booleanValue() || ((Boolean)stateR.getValue((Property)OPEN)).booleanValue() : (sideR ? (Boolean)stateR.getValue((Property)OPEN) : (sideL ? (Boolean)stateL.getValue((Property)OPEN) : true));
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide) {
            return;
        }
        BlockPos blockPos = pos.below();
        level.setBlock(blockPos, (BlockState)((BlockState)state.setValue((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.DOWN)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(blockPos).getType() == Fluids.WATER)), 3);
        level.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean sideR;
        BlockState stateOpposite;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction facing_vertical = (Direction)state.getValue((Property)VERTICAL_CONNECTION_TYPE);
        if (direction.getAxis().isVertical() && (!((stateOpposite = level.getBlockState(currentPos.relative(facing_vertical.getOpposite()))).getBlock() instanceof CurtainBlock) || stateOpposite.getValue((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction != facing.getClockWise() && direction != facing.getCounterClockWise()) {
            return state;
        }
        BlockState stateL = level.getBlockState(currentPos.relative(facing.getClockWise()));
        BlockState stateR = level.getBlockState(currentPos.relative(facing.getCounterClockWise()));
        boolean sideL = stateL.getBlock() instanceof CurtainBlock && stateL.getValue((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical && stateL.getValue((Property)FACING) == facing;
        boolean bl = sideR = stateR.getBlock() instanceof CurtainBlock && stateR.getValue((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical && stateR.getValue((Property)FACING) == facing;
        HorizontalConnectionType type = sideL && sideR ? HorizontalConnectionType.MIDDLE : (sideR ? HorizontalConnectionType.LEFT : (sideL ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.setValue(HORIZONTAL_CONNECTION_TYPE, (Comparable)((Object)type));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (state.getValue((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP) {
            this.toggleFromTop(state, level, pos);
        } else {
            this.toggleFromTop(level.getBlockState(pos.above()), level, pos.above());
        }
        level.playSound(null, pos, AFSoundEvents.CURTAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void toggleFromTop(BlockState state, Level level, BlockPos pos) {
        boolean open = (Boolean)state.getValue((Property)OPEN) == false;
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction relativeLeft = facing.getClockWise();
        Direction relativeRight = facing.getCounterClockWise();
        this.toggleVertical(state, level, pos, open);
        this.toggleHorizontal(state, level, pos, open, facing, relativeLeft);
        this.toggleHorizontal(state, level, pos, open, facing, relativeRight);
    }

    public void toggleHorizontal(BlockState state, Level level, BlockPos pos, boolean open, Direction facing, Direction dir) {
        BlockPos facingHorizontalPos = pos.relative(dir);
        BlockState facingHorizontalState = level.getBlockState(facingHorizontalPos);
        if (facingHorizontalState.getBlock() instanceof CurtainBlock && facingHorizontalState.getValue((Property)FACING) == facing && state.getValue((Property)VERTICAL_CONNECTION_TYPE) == facingHorizontalState.getValue((Property)VERTICAL_CONNECTION_TYPE)) {
            this.toggleVertical(facingHorizontalState, level, facingHorizontalPos, open);
            this.toggleHorizontal(facingHorizontalState, level, facingHorizontalPos, open, facing, dir);
        }
    }

    public void toggleVertical(BlockState state, Level level, BlockPos pos, boolean open) {
        Direction facingVertical = (Direction)state.getValue((Property)VERTICAL_CONNECTION_TYPE);
        BlockPos facingVerticalPos = pos.relative(facingVertical.getOpposite());
        BlockState facingVerticalState = level.getBlockState(facingVerticalPos);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        if (facingVerticalState.getBlock() instanceof CurtainBlock && facingVertical == ((Direction)facingVerticalState.getValue((Property)VERTICAL_CONNECTION_TYPE)).getOpposite()) {
            level.setBlockAndUpdate(facingVerticalPos, (BlockState)facingVerticalState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HORIZONTAL_CONNECTION_TYPE, OPEN, VERTICAL_CONNECTION_TYPE, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

