/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.SeatBlock;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.util.block.HammerableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BenchBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<HorizontalConnectionType> CONNECTION_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE_1;
    public static final EnumProperty<HorizontalConnectionType> BACK_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE_2;
    public static final BooleanProperty BACK = ModBlockStateProperties.BACK;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape AABB_Z = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)7.0, (double)14.0);
    protected static final VoxelShape AABB_X = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)7.0, (double)16.0);
    protected static final VoxelShape AABB_EAST = Shapes.or((VoxelShape)AABB_X, (VoxelShape)Block.box((double)2.0, (double)7.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0));
    protected static final VoxelShape AABB_WEST = Shapes.or((VoxelShape)AABB_X, (VoxelShape)Block.box((double)12.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0));
    protected static final VoxelShape AABB_SOUTH = Shapes.or((VoxelShape)AABB_Z, (VoxelShape)Block.box((double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)16.0, (double)4.0));
    protected static final VoxelShape AABB_NORTH = Shapes.or((VoxelShape)AABB_Z, (VoxelShape)Block.box((double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0));

    public BenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(CONNECTION_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).setValue(BACK_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).setValue((Property)BACK, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.35f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos.relative((Direction)state.getValue((Property)FACING));
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        return ((Direction)state.getValue((Property)FACING)).toYRot();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)BACK)).booleanValue()) {
            return switch (facing) {
                case Direction.EAST -> AABB_EAST;
                case Direction.SOUTH -> AABB_SOUTH;
                case Direction.WEST -> AABB_WEST;
                default -> AABB_NORTH;
            };
        }
        return facing.getAxis() == Direction.Axis.Z ? AABB_Z : AABB_X;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        HorizontalConnectionType connection_type;
        boolean back_r_side;
        Direction facing;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction != (facing = (Direction)state.getValue((Property)FACING)).getClockWise() && direction != facing.getCounterClockWise()) {
            return state;
        }
        BlockState l_state = level.getBlockState(currentPos.relative(facing.getClockWise()));
        BlockState r_state = level.getBlockState(currentPos.relative(facing.getCounterClockWise()));
        boolean l_side = l_state.getBlock() instanceof BenchBlock && (l_state.getValue((Property)FACING) == facing || l_state.getValue((Property)FACING) == facing.getOpposite());
        boolean r_side = r_state.getBlock() instanceof BenchBlock && (r_state.getValue((Property)FACING) == facing || r_state.getValue((Property)FACING) == facing.getOpposite());
        boolean back_l_side = l_state.getBlock() instanceof BenchBlock && l_state.getValue((Property)FACING) == facing && (Boolean)l_state.getValue((Property)BACK) != false;
        boolean bl = back_r_side = r_state.getBlock() instanceof BenchBlock && r_state.getValue((Property)FACING) == facing && (Boolean)r_state.getValue((Property)BACK) != false;
        HorizontalConnectionType horizontalConnectionType = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (connection_type = l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        HorizontalConnectionType back_type = back_l_side && back_r_side ? HorizontalConnectionType.MIDDLE : (back_r_side ? HorizontalConnectionType.LEFT : (back_l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)((BlockState)state.setValue(CONNECTION_TYPE, (Comparable)((Object)connection_type))).setValue(BACK_TYPE, (Comparable)((Object)back_type));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.tryHammerBlock((Property)BACK, stack, state, (LevelAccessor)level, pos, player)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTION_TYPE, BACK_TYPE, BACK, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

