/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation;

import mod.azure.azurelib.common.internal.common.AzureLibException;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import mod.azure.azurelib.rewrite.animation.AzAnimationContext;
import mod.azure.azurelib.rewrite.animation.AzAnimationTimer;
import mod.azure.azurelib.rewrite.animation.AzAnimatorConfig;
import mod.azure.azurelib.rewrite.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelib.rewrite.animation.cache.AzBoneCache;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimation;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimations;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AzAnimator<T> {
    private final AzAnimationContext<T> reusableContext;
    private final AzAnimationControllerContainer<T> animationControllerContainer = new AzAnimationControllerContainer();
    public boolean reloadAnimations;

    protected AzAnimator() {
        this(AzAnimatorConfig.defaultConfig());
    }

    protected AzAnimator(AzAnimatorConfig config) {
        AzBoneCache boneCache = new AzBoneCache();
        AzAnimationTimer timer = new AzAnimationTimer(config);
        this.reusableContext = new AzAnimationContext(boneCache, config, timer);
    }

    public abstract void registerControllers(AzAnimationControllerContainer<T> var1);

    @NotNull
    public abstract ResourceLocation getAnimationLocation(T var1);

    public void animate(T animatable, float partialTicks) {
        this.reusableContext.animatable = animatable;
        AzBoneCache boneCache = this.reusableContext.boneCache();
        AzAnimationTimer timer = this.reusableContext.timer();
        timer.tick();
        this.preAnimationSetup(animatable, timer.getAnimTime(), partialTicks);
        if (!boneCache.isEmpty()) {
            for (AzAnimationController<T> controller : this.animationControllerContainer.getAll()) {
                controller.update();
            }
            this.reloadAnimations = false;
            boneCache.update(this.reusableContext);
        }
        this.setCustomAnimations(animatable, partialTicks);
    }

    protected void preAnimationSetup(T animatable, double animTime, float partialTicks) {
        this.applyMolangQueries(animatable, animTime, partialTicks);
    }

    protected void applyMolangQueries(T animatable, double animTime, float partialTicks) {
        this.applyMolangQueries(animatable, animTime);
    }

    @Deprecated
    private void applyMolangQueries(T animatable, double animTime) {
        ClientLevel level = Minecraft.getInstance().level;
        MolangParser parser = MolangParser.INSTANCE;
        if (level == null) {
            return;
        }
        parser.setMemoizedValue(MolangQueries.LIFE_TIME, () -> animTime / 20.0);
        parser.setMemoizedValue(MolangQueries.ACTOR_COUNT, () -> ((ClientLevel)level).getEntityCount());
        parser.setMemoizedValue(MolangQueries.TIME_OF_DAY, () -> (float)level.getDayTime() / 24000.0f);
        parser.setMemoizedValue(MolangQueries.MOON_PHASE, () -> ((ClientLevel)level).getMoonPhase());
    }

    public void setCustomAnimations(T animatable, float partialTicks) {
    }

    public void setActiveModel(AzBakedModel model) {
        boolean modelChanged = this.reusableContext.boneCache().setActiveModel(model);
        if (modelChanged) {
            this.animationControllerContainer.getAll().forEach(controller -> controller.boneAnimationQueueCache().clear());
        }
    }

    public AzBakedAnimation getAnimation(T animatable, String name) {
        ResourceLocation location = this.getAnimationLocation(animatable);
        AzBakedAnimations bakedAnimations = AzBakedAnimationCache.getInstance().getNullable(location);
        if (bakedAnimations == null) {
            throw new AzureLibException(location, "Unable to find animation.");
        }
        return bakedAnimations.getAnimation(name);
    }

    public AzAnimationContext<T> context() {
        return this.reusableContext;
    }

    public AzAnimationControllerContainer<T> getAnimationControllerContainer() {
        return this.animationControllerContainer;
    }
}

