/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.common.animatable;

import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.internal.common.network.packet.EntityAnimDataSyncPacket;
import mod.azure.azurelib.common.internal.common.network.packet.EntityAnimTriggerPacket;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface GeoEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((Entity)this).getId()).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).setData(dataTicket, data);
        } else {
            EntityAnimDataSyncPacket<D> entityAnimDataSyncPacket = new EntityAnimDataSyncPacket<D>(entity.getId(), false, dataTicket, data);
            Services.NETWORK.sendToTrackingEntityAndSelf(entityAnimDataSyncPacket, entity);
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).tryTriggerAnimation(controllerName, animName);
        } else {
            EntityAnimTriggerPacket entityAnimTriggerPacket = new EntityAnimTriggerPacket(entity.getId(), false, controllerName, animName);
            Services.NETWORK.sendToTrackingEntityAndSelf(entityAnimTriggerPacket, entity);
        }
    }

    @Override
    default public double getTick(Object entity) {
        return RenderUtils.getCurrentTick();
    }
}

