/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.sweenus.simplyswords.config.LootConfig;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.EnchantRandomlyFromTagLootFunction;

public class ModLootTableModifiers {
    private static final Supplier<List<Item>> swords = Suppliers.memoize(() -> BuiltInRegistries.ITEM.stream().filter(it -> it instanceof UniqueSwordItem).toList());
    private static final Set<RegistrySupplier<? extends Item>> lootableSuppliers = Set.of(ItemsRegistry.WATCHER_CLAYMORE, ItemsRegistry.BRIMSTONE_CLAYMORE, ItemsRegistry.STORMS_EDGE, ItemsRegistry.STORMBRINGER, ItemsRegistry.BRAMBLETHORN, ItemsRegistry.WATCHING_WARGLAIVE, ItemsRegistry.TOXIC_LONGSWORD, ItemsRegistry.EMBERBLADE, ItemsRegistry.FROSTFALL, ItemsRegistry.SOULPYRE, ItemsRegistry.MOLTEN_EDGE, ItemsRegistry.LIVYATAN, ItemsRegistry.ICEWHISPER, ItemsRegistry.ARCANETHYST, ItemsRegistry.THUNDERBRAND, ItemsRegistry.HEARTHFLAME, ItemsRegistry.TWISTED_BLADE, ItemsRegistry.SOULRENDER, ItemsRegistry.SOULKEEPER, ItemsRegistry.SOULSTEALER, ItemsRegistry.MJOLNIR, ItemsRegistry.SLUMBERING_LICHBLADE, ItemsRegistry.SHADOWSTING, ItemsRegistry.DORMANT_RELIC, ItemsRegistry.WHISPERWIND, ItemsRegistry.EMBERLASH, ItemsRegistry.WAXWEAVER, ItemsRegistry.HIVEHEART, ItemsRegistry.STARS_EDGE, ItemsRegistry.WICKPIERCER, ItemsRegistry.TEMPEST, ItemsRegistry.FLAMEWIND, ItemsRegistry.RIBBONCLEAVER, ItemsRegistry.CAELESTIS, ItemsRegistry.WRAITHFANG);
    private static Set<Item> lootableItems = Set.of();

    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            ResourceLocation id = key.location();
            if (((Boolean)LootConfig.INSTANCE.enableLootDrops.get()).booleanValue() && id.getPath().contains("chests") && !id.getPath().contains("spectrum") && (((Boolean)LootConfig.INSTANCE.enableLootInVillages.get()).booleanValue() || !id.getPath().contains("village"))) {
                LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(((Float)LootConfig.INSTANCE.standardLootTableWeight.get()).floatValue() / 100.0f))).apply((LootItemFunction.Builder)EnchantRandomlyFromTagLootFunction.create((TagKey<Enchantment>)EnchantmentTags.DAMAGE_EXCLUSIVE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_LONGSWORD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_TWINBLADE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_RAPIER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_CUTLASS.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_KATANA.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_GLAIVE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_WARGLAIVE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_SPEAR.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_SAI.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_CLAYMORE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_CHAKRAM.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_GREATAXE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_GREATHAMMER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_SCYTHE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.IRON_HALBERD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_LONGSWORD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_TWINBLADE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_RAPIER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_CUTLASS.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_KATANA.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_GLAIVE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_WARGLAIVE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_SPEAR.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_SAI.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_CLAYMORE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_GREATHAMMER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_CHAKRAM.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_GREATAXE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_SCYTHE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.GOLD_HALBERD.get())));
                context.addPool(pool);
            }
        });
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            ResourceLocation id = key.location();
            if (((Boolean)LootConfig.INSTANCE.enableLootDrops.get()).booleanValue() && id.getPath().contains("chests") && !id.getPath().contains("spectrum") && (((Boolean)LootConfig.INSTANCE.enableLootInVillages.get()).booleanValue() || !id.getPath().contains("village"))) {
                LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(((Float)LootConfig.INSTANCE.rareLootTableWeight.get()).floatValue() / 100.0f))).apply((LootItemFunction.Builder)EnchantRandomlyFromTagLootFunction.create((TagKey<Enchantment>)EnchantmentTags.DAMAGE_EXCLUSIVE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_LONGSWORD.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_TWINBLADE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_RAPIER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_CUTLASS.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_KATANA.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_SPEAR.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_GLAIVE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_WARGLAIVE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_SAI.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_CLAYMORE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_GREATHAMMER.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_CHAKRAM.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_GREATAXE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_SCYTHE.get()))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.DIAMOND_HALBERD.get())));
                context.addPool(pool);
            }
        });
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            ResourceLocation id = key.location();
            if (((Boolean)LootConfig.INSTANCE.enableLootDrops.get()).booleanValue() && id.getPath().contains("chests") && !id.getPath().contains("spectrum") && (((Boolean)LootConfig.INSTANCE.enableLootInVillages.get()).booleanValue() || !id.getPath().contains("village"))) {
                LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(((Float)LootConfig.INSTANCE.runicLootTableWeight.get()).floatValue() / 100.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemsRegistry.RUNIC_TABLET.get())));
                context.addPool(pool);
            }
        });
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            ResourceLocation id = key.location();
            if (((Boolean)LootConfig.INSTANCE.enableLootDrops.get()).booleanValue()) {
                Float lootChance = (Float)LootConfig.INSTANCE.uniqueLootTableOptions.get(id);
                if (lootChance != null && lootChance.floatValue() > 0.0f) {
                    LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(lootChance.floatValue() / 100.0f)));
                    ((List)swords.get()).stream().filter(item -> !LootConfig.INSTANCE.disabledUniqueWeaponLoot.contains(item) && ModLootTableModifiers.isLootableUnique(item)).forEach(item -> pool.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
                    context.addPool(pool);
                } else if (id.getPath().contains("chests") && !id.getPath().contains("spectrum")) {
                    LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)(((Float)LootConfig.INSTANCE.uniqueLootTableWeight.get()).floatValue() / 100.0f)));
                    ((List)swords.get()).stream().filter(item -> !LootConfig.INSTANCE.disabledUniqueWeaponLoot.contains(item) && ModLootTableModifiers.isLootableUnique(item)).forEach(item -> pool.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
                    context.addPool(pool);
                }
            }
        });
    }

    public static boolean isLootableUnique(Item item) {
        if (lootableItems.isEmpty()) {
            lootableItems = lootableSuppliers.stream().map(java.util.function.Supplier::get).collect(Collectors.toSet());
        }
        return lootableItems.contains(item.asItem());
    }
}

