/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ChanceDurationRadiusSettings;
import net.sweenus.simplyswords.power.RunefusedGemPower;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class WildfirePower
extends RunefusedGemPower {
    public WildfirePower() {
        super(false);
    }

    @Override
    public void postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int hitChance = Config.gemPowers.wildfire.chance;
        int duration = Config.gemPowers.wildfire.duration;
        if (attacker.getRandom().nextInt(100) <= hitChance) {
            target.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.WILDFIRE), duration, 3), (Entity)attacker);
            attacker.level().playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.getSoundSource(), 0.1f, 1.8f);
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        if (isRunic) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.wildfiresworditem.tooltip1").setStyle(Styles.RUNIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.runefused_power.wildfire").setStyle(Styles.RUNIC));
        }
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.wildfiresworditem.tooltip2")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.wildfiresworditem.tooltip3")).setStyle(Styles.RUNIC_DESCRIPTION));
        }
    }

    public static class Settings
    extends ChanceDurationRadiusSettings {
        public Settings() {
            super(10, 180, 10.0, (Supplier<? extends TooltipProvider>)GemPowerRegistry.WILDFIRE);
        }
    }
}

