/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.power.RunicGemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class MomentumPower
extends RunicGemPower {
    public MomentumPower(boolean isGreater) {
        super(isGreater);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, ItemStack itemStack) {
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        world.playSound(user, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_FLYBY_01.get(), user.getSoundSource(), 0.3f, 0.7f);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    @Override
    public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        int skillCooldown = Config.gemPowers.momentum.cooldown;
        if (user.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
            int velocity = 3;
            if (!user.onGround()) {
                velocity = 1;
            }
            if (remainingUseTicks >= 10 && user.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
                user.setDeltaMovement(user.getLookAngle().scale((double)(velocity + (this.isGreater() ? 1 : 0))));
                user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
                user.hurtMarked = true;
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
                }
            }
        }
    }

    @Override
    public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
            user.setDeltaMovement(0.0, 0.0, 0.0);
            user.hurtMarked = true;
        }
    }

    @Override
    public int getMaxUseTime(ItemStack stack) {
        return 15;
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.momentumsworditem.tooltip1").setStyle(Styles.RUNIC));
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.momentumsworditem.tooltip2").setStyle(Styles.RUNIC_DESCRIPTION)));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.momentumsworditem.tooltip3").setStyle(Styles.RUNIC_DESCRIPTION)));
        }
    }

    public static class Settings
    extends TooltipSettings {
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=1)
        public int cooldown = 140;

        public Settings() {
            super((Supplier<? extends TooltipProvider>)GemPowerRegistry.MOMENTUM);
        }
    }
}

