/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.power.RunefusedGemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class FrostWardPower
extends RunefusedGemPower {
    public FrostWardPower() {
        super(false);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, LivingEntity user, int slot, boolean selected) {
        int frequency = Config.gemPowers.frostWard.frequency;
        if (user.tickCount % frequency == 0) {
            int duration = Config.gemPowers.frostWard.duration;
            double sRadius = Config.gemPowers.frostWard.radius;
            double vRadius = Config.gemPowers.frostWard.radius / 2.0;
            double x = user.getX();
            double y = user.getY();
            double z = user.getZ();
            ServerLevel serverWorld = (ServerLevel)world;
            AABB box = new AABB(x + sRadius, y + vRadius, z + sRadius, x - sRadius, y - vRadius, z - sRadius);
            for (Entity entity : serverWorld.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user) || !((double)le.distanceTo((Entity)user) < sRadius)) continue;
                Snowball snowball = new Snowball(EntityType.SNOWBALL, (Level)serverWorld);
                snowball.absMoveTo(user.getX(), user.getY() + 1.5, user.getZ());
                snowball.setOwner((Entity)user);
                le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration));
                snowball.setDeltaMovement(le.getX() - user.getX(), le.getY() - user.getY() - 1.0, le.getZ() - user.getZ());
                serverWorld.addFreshEntity((Entity)snowball);
            }
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        if (isRunic) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.frostwardsworditem.tooltip1").setStyle(Styles.RUNIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.runefused_power.frost_ward").setStyle(Styles.RUNIC));
        }
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.frostwardsworditem.tooltip2")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.frostwardsworditem.tooltip3")).setStyle(Styles.RUNIC_DESCRIPTION));
        }
    }

    public static class Settings
    extends TooltipSettings {
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=1)
        public int frequency = 20;
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedDouble.Restrict(min=0.0)
        public double radius = 5.0;
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=0)
        public int duration = 60;

        public Settings() {
            super((Supplier<? extends TooltipProvider>)GemPowerRegistry.FROST_WARD);
        }
    }
}

